<?php
/**
 * Action form view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting = $this->setting;
$current = $setting->getSetting( 'action_type', 'form' );
$dspForm = ' style="display:none";';
if ( $current == 'form' ) {
  $dspForm = '';
}
?>

<!-- start: .ipjck-section-select-content -->
<div id="ipjck-section-form" class="ipjck-section-select-content"<?php echo $dspForm; ?>>

  <?php
  //Form Code
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-y ipjck-help-abs">
    <div class="ipjck-form-label">
      <label for="ipjck-imb-responder-code"><?php _e( 'Form Code', IPJCK_SLUG ); ?></label>
    </div>
    <div class="ipjck-field">

      <?php
      $code = $setting->getSetting( 'autoresponder_code', '' );
      ?>
      <textarea class="ipjck-input ipjck-input-full ipjck-input-optin" id="ipjck-imb-responder-code" name="autoresponder_code" rows="7"><?php echo $code; ?></textarea>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Code of autoresponder form which can be obtained from the online email marketing you use such as MailChimp, AWeber', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  $hdisplay = ' style="display:none;"';
  if ( ! empty( $code ) ) {
      $hdisplay = '';
  }
  $data = IPJck_Form::parse( $code );
  ?>
  <!-- start: .ipjck-optin-settings -->
  <div class="ipjck-optin-settings"<?php echo $hdisplay; ?>>

  <?php
  //Form Action URL
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="ipjck-imb-responder-action"><?php _e( 'Action URL', IPJCK_SLUG ); ?></label>
    </div>
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
      <?php
      $action = $setting->getSetting( 'autoresponder_action', $data['action'] );
      ?>
      <input type="text" id="ipjck-imb-responder-action" class="ipjck-input ipjck-input-full ipjck-input-autoresponder-action" name="autoresponder_action" value="<?php echo $action; ?>">
      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'The url of the script that will handle the optin form', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  //Form Email Field
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="ipjck-imb-responder-email"><?php _e( 'Form Email Field', IPJCK_SLUG ); ?></label>
    </div>
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
      <select name="autoresponder_email" id="ipjck-imb-responder-email">
        <option value="0">-- <?php _e( 'Select field', IPJCK_SLUG ); ?> --</option>
          <?php
          $value = stripslashes( $setting->getSetting( 'autoresponder_email', '' ) );
          if ( ! empty( $data['fields'] )) {
            foreach( $data['fields'] as $field ) {
              $sltd = '';
              if ( $field == $value ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $field . '"' . $sltd . '>' . $field . '</option>';
            }
          }
          ?>
        </select>
        <?php
        $label = stripslashes( $setting->getSetting( 'autoresponder_email_label', '' ) );
        ?>
        <input class="ipjck-input ipjck-input-full mt10" type="text" id="ipjck-imb-responder-email-label" value="<?php echo $label; ?>" name="autoresponder_email_label" placeholder="<?php _e( 'Input email label', IPJCK_SLUG ); ?>">
        <div class="ipjck-help">
          <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
          <div class="ipjck-help-content ipjck-hide">
            <?php _e( 'Set the input of the email optin form. Select a name that represents an email input and specify the title of the email input', IPJCK_SLUG ); ?>
          </div>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field-row -->

    <?php
    //Form Name Field
    ?>
    <!-- start: .ipjck-field-row -->
    <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
      <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
        <label for="ipjck-imb-responder-name"><?php _e( 'Form Name Field', IPJCK_SLUG ); ?></label>
      </div>
      <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
        <div class="ipjck-onoff mr10">
          <?php
          $val = $setting->getSetting( 'autoresponder_name_activate', 'true' );
          if ( $val == 'false' ) {
            $clon  = '';
            $cloff = ' active';
          } else {
            $clon  = ' active';
            $cloff = '';
          }
          ?>
          <div class="ipjck-btn-group">
            <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
            <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
          </div>
          <input type="hidden" class="ipjck-onoff-value" name="autoresponder_name_activate" value="<?php echo $val; ?>" />
        </div>

        <select name="autoresponder_name" id="ipjck-imb-responder-name">
          <option value="0">-- <?php _e( 'Select field', IPJCK_SLUG ); ?> --</option>
          <?php
          $value = stripslashes( $setting->getSetting( 'autoresponder_name', '' ) );
          if ( ! empty( $data['fields'] )) {
            foreach( $data['fields'] as $field ) {
              $sltd = '';
              if ( $field == $value ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $field . '"' . $sltd . '>' . $field . '</option>';
            }
          }
          ?>
        </select>
        <?php
        $label = stripslashes( $setting->getSetting( 'autoresponder_name_label', '' ) );
        ?>
        <input class="ipjck-input ipjck-input-full mt10" type="text" id="ipjck-imb-responder-name-label" value="<?php echo $label; ?>" name="autoresponder_name_label" placeholder="<?php _e( 'Input name label', IPJCK_SLUG ); ?>">
        <div class="ipjck-help">
          <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
          <div class="ipjck-help-content ipjck-hide">
            <?php _e( 'Set the input name of the optin form. You can set whether to display the input name or not. if shown you should choose a name that represents the input name and determine the title of the input name', IPJCK_SLUG ); ?>
          </div>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field-row -->

  </div>
  <!-- end: .ipjck-optin-settings -->

  <?php
  /*
   * Button label
   */
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-form-button-label"><?php _e( 'Button Label', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
      <?php
      $label = stripslashes( $setting->getSetting( 'form_button_label' ) );
      ?>
      <input type="text" id="input-form-button-label" class="ipjck-input ipjck-input-full" name="form_button_label" value="<?php echo $label; ?>">

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide"><?php _e( 'The label of the button.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

  <h4 class="ipjck-field-title mb0 py10">
    <?php _e( 'Form Design', IPJCK_SLUG ); ?>
  </h4>

  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-form-layout">
        <?php _e( 'Form Layout', IPJCK_SLUG ); ?>
      </label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

      <select name="form_layout" id="input-form-layout">
        <?php
        $current = $this->setting->getSetting( 'form_layout', 'horizontal' );
        $types   = array(
          'vertical'   => __( 'Vertical', IPJCK_SLUG ),
          'horizontal' => __( 'Horizontal', IPJCK_SLUG )
        );
        foreach( $types as $key => $label )
        {
          $sltd = '';
          if ( $current == $key ) {
            $sltd = ' selected="selected"';
          }
          echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
        }
        ?>
      </select>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Set the layout of the form.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

  <!-- start: .ipjck-section-select -->
  <div class="ipjck-section-select">

    <!-- start: .ipjck-field-row -->
    <div class="ipjck-field-row ipjck-field-x">
      <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
        <label for="input-form-size">
          <?php _e( 'Form Input Size', IPJCK_SLUG ); ?>
        </label>
      </div>

      <!-- start: .ipjck-field -->
      <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

        <select name="form_size" id="input-form-size" class="ipjck-input ipjck-section-select-options">
          <?php
          $current = $setting->getSetting( 'form_size', 'widthauto' );
          $types   = array(
            'widthcustom' => __( 'Custom Size', IPJCK_SLUG ),
            'widthauto'   => __( 'Auto', IPJCK_SLUG )
          );
          foreach( $types as $key => $label )
          {
            $sltd = '';
            if ( $current == $key ) {
              $sltd = ' selected="selected"';
            }
            echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
          }
          ?>
        </select>

        <div class="ipjck-help">
          <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
          <div class="ipjck-help-content ipjck-hide">
            <?php _e( 'Set the form input size.', IPJCK_SLUG ); ?>
          </div>
        </div>
      </div>
      <!-- end: .ipjck-field -->
    </div>
    <!-- end: .ipjck-field-row -->

    <?php
    //Custom options
    //
    $dspCustom = ' display:none;';
    if ( $current == 'widthcustom' ) {
      $dspCustom = '';
    }
    ?>
    <!-- start: .ipjck-section-select-content -->
    <div id="ipjck-section-widthcustom" class="ipjck-section-select-content" style="border-bottom:1px solid #ddd;<?php echo $dspCustom; ?>">

      <?php
      /*
       * Form Input Width
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-form-width"><?php _e( 'Form Input Width', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $width = $setting->getSetting( 'form_width', 240 );
          ?>
          <div class="ipjck-input-group mr5">
            <input type="text" id="input-form-width" class="ipjck-input ipjck-input-xs" name="form_width" value="<?php echo $width; ?>">
             <div class="ipjck-input-addon">px</div>
          </div>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Width ( in pixel ) of the form input.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

    </div>
    <!-- end: .ipjck-section-select-content -->

  </div>
  <!-- end: .ipjck-section-select -->

  <?php
  /*
   * Background Color
   */
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-form-background-color">
        <?php _e( 'Input Background Color', IPJCK_SLUG ); ?>
      </label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

      <?php
      $color = stripslashes( $setting->getSetting( 'form_background_color', '#ffffff' ) );
      ?>
      <input type="text" class="ipjck-color-picker" id="input-form-background-color" name="form_background_color" value="<?php echo $color; ?>" />

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Set background color for the input form.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  /*
   * Border
   */
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-form-border-width"><?php _e( 'Input Border', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

      <?php
      $color   = stripslashes( $setting->getSetting( 'form_border_color', '#bbbbbb' ) );
      $bowidth = $setting->getSetting( 'form_border_width', 0 );
      ?>
      <div class="ipjck-input-group mr5">
        <input type="text" id="input-form-border-width" class="ipjck-input ipjck-input-xxs" name="form_border_width" value="<?php echo $bowidth; ?>">
        <div class="ipjck-input-addon">px</div>
      </div>
      <input type="text" class="ipjck-color-picker" id="input-form-border-color" name="form_border_color" value="<?php echo $color; ?>" />

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Add border for the input form.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  //Border radius
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
        <label for="input-form-border-radius"><?php _e( 'Input Border Radius', IPJCK_SLUG ); ?></label>
    </div>
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

        <select name="form_border_radius" id="input-form-border-radius">
        <?php
        $current = stripslashes( $setting->getSetting( 'form_border_radius', 'none' ));
        $styles  = array(
            'none' => __( 'None', IPJCK_SLUG ),
            'xs'   => __( 'Extra Small', IPJCK_SLUG ),
            'sm'   => __( 'Small', IPJCK_SLUG ),
            'md'   => __( 'Medium', IPJCK_SLUG ),
            'lg'   => __( 'Large', IPJCK_SLUG )
        );
        foreach( $styles as $key => $label ) {
            $sltd = '';
            if ( $key == $current ) {
                $sltd = ' selected="selected"';
            }
            echo '<option value="' . $key . '"' . $sltd .'>'. $label .'</option>';
        }
        ?>
        </select>

        <div class="ipjck-help">
          <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
            <?php _e( 'Add radius in the input form.', IPJCK_SLUG ); ?>
          </div>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  /*
   * Text Color
   */
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-form-text-color"><?php _e( 'Input Text Color', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

      <?php
      $color = stripslashes( $setting->getSetting( 'form_text_color', '#666666' ) );
      ?>
      <input type="text" class="ipjck-color-picker" id="input-form-text-color" name="form_text_color" value="<?php echo $color; ?>" />

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Set text color for the input form.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  /*
   * Font Size
   */
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-form-font-size"><?php _e( 'Input Font Size', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

      <?php
      $size = absint( $setting->getSetting( 'form_font_size', '14' ) );
      ?>
      <div class="ipjck-input-group mr5">
        <input type="text" id="input-form-font-size" class="ipjck-input ipjck-input-xxs" name="form_font_size" value="<?php echo $size; ?>">
        <div class="ipjck-input-addon">px</div>
      </div>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Set the font size of the form input.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  //Font Family
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-form-font-family"><?php _e( 'Input Font Family', IPJCK_SLUG ); ?></label>
    </div>
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

      <?php
      $current = $setting->getSetting( 'form_font_family', 'roboto' );
      $fonts   = IPJck_Font::getOptions();
      $fname   = IPJck_Font::getFontName( $current );
      ?>
      <span class="ipjck-font-family">
        <div class="ipjck-menu ipjck-fancy-option">
          <div class="ipjck-selected">
            <div class="ipjck-selected-box">
              <span data-select="<?php echo $current; ?>"><?php echo $fname; ?></span>
            </div>
            <span class="toggle"></span>
          </div>
          <div class="ipjck-select" style="display: none;">
            <div class="ipjck-select-content">
              <ul class="clearfix">
                <?php
                foreach( $fonts as $fkey => $label ) :
                ?>
                <li data-select="<?php echo $fkey; ?>">
                  <strong class="ipjck-select-label">
                    <?php echo $label; ?>
                  </strong>
                </li>
                <?php
                endforeach;
                ?>
              </ul>
            </div>
          </div>
          <input type="hidden" name="form_font_family" class="ipjck-input-select" value="<?php echo $current; ?>" />
        </div>
      </span>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'The font family of the text in your box form.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field-row -->


  <?php
  /*
   * Inner Shadow
   */
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-form-inner-shadow"><?php _e( 'Input Inner Shadow', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
      <div class="ipjck-onoff">
          <?php
          $val  = $setting->getSetting( 'form_inner_shadow', 'false' );
          if ( $val == 'false' ) {
              $clon  = '';
              $cloff = ' active';
          } else {
              $clon  = ' active';
              $cloff = '';
          }
          ?>
          <div class="ipjck-btn-group">
            <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
            <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
          </div>
          <input type="hidden" class="ipjck-onoff-value" name="form_inner_shadow" value="<?php echo $val; ?>" />
      </div>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Determines whether to add a shadow effect on the inner of the input form.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  /*
   * Outer Shadow
   */
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-form-outer-shadow"><?php _e( 'Input Outer Shadow', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
      <div class="ipjck-onoff">
          <?php
          $val  = $this->setting->getSetting( 'form_outer_shadow', 'false' );
          if ( $val == 'false' ) {
              $clon  = '';
              $cloff = ' active';
          } else {
              $clon  = ' active';
              $cloff = '';
          }
          ?>
          <div class="ipjck-btn-group">
            <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
            <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
          </div>
          <input type="hidden" class="ipjck-onoff-value" name="form_outer_shadow" value="<?php echo $val; ?>" />
      </div>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Determines whether to add a shadow effect on the outer of the input form.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  //Button design
  $this->prefix = 'form_';
  $this->view( 'admin/widget/action/button-design' );
  ?>

</div>
<!-- end: .ipjck-section-select-content -->