<?php
/**
 * Button design view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting = $this->setting;
$pf = $this->prefix;
?>

<h4 class="ipjck-field-title mb0 py10">
  <?php _e( 'Button Design', IPJCK_SLUG ); ?>
</h4>

<?php
/*
 * Template
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
    <label for="input-<?php echo $pf; ?>button-template">
      <?php _e( 'Template', IPJCK_SLUG ); ?>
    </label>
  </div>

  <!-- start: .ipjck-field -->
  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

    <div class="ipjck-input-button-image-stock ipjck-image-option">
      <ul class="_options ipjck-clear">
        <?php
        $current = $this->setting->getSetting( $pf . 'button_template' );
        $root    = IPJCK_BASE_URL . 'assets/img/buttons/button-template-';
        $options = range(1,8);

        foreach( $options as $value )
        {
          $sltd = '';
          if ( $value == $current ) {
            $sltd = ' _selected';
          }
          $src  = $root . $value . '.png';
          echo '<li><span class="_item' . $sltd . '" data-value="' . $value . '">';
          echo '<img src="' . $src . '" alt="' . $value . '">';
          echo '<span class="_selected-overlay"><i class="ipchm-fa ipchm-fa-check-circle"></i></span>';
          echo '</span>';
          echo '</li>';
        }
        ?>
        <input type="hidden" class="_value-selected" name="<?php echo $pf; ?>button_template" value="<?php echo $current; ?>">
      </ul>
    </div>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'Select an image for your button.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->

<?php
//Button style color
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
    <label for="input-<?php echo $pf; ?>button-style-color"><?php _e( 'Button Style Color', IPJCK_SLUG ); ?></label>
  </div>
  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

    <select name="<?php echo $pf; ?>button_style_color" id="input-<?php echo $pf; ?>button-style-color">
      <?php
      $current = $this->setting->getSetting( $pf . 'button_style_color', 'clean' );
      $colors  = array(
        'clean'    => __( 'Clean', IPJCK_SLUG ),
        'dark'     => __( 'Dark', IPJCK_SLUG ),
        'red'      => __( 'Red', IPJCK_SLUG ),
        'blue'     => __( 'Blue', IPJCK_SLUG ),
        'green'    => __( 'Green', IPJCK_SLUG ),
        'orange'   => __( 'Orange', IPJCK_SLUG ),
        'gold'     => __( 'Gold', IPJCK_SLUG ),
        'aqua'     => __( 'Aqua', IPJCK_SLUG ),
        'purple'   => __( 'Purple', IPJCK_SLUG ),
        'lime'     => __( 'Lime', IPJCK_SLUG )
      );
      foreach( $colors as $skey => $label ) {
        $sltd = '';
        if ( $skey == $current ) {
          $sltd = ' selected="selected"';
        }
        echo '<option value="' . $skey . '"' . $sltd .'>'. $label .'</option>';
      }
      ?>
    </select>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'The style color of the button in main content.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
</div>
<!-- end: .ipjck-field-row -->

<?php
//Size
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
    <label for="input-<?php echo $pf; ?>button-size"><?php _e( 'Size', IPJCK_SLUG ); ?></label>
  </div>
  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

    <select name="<?php echo $pf; ?>button_size" id="input-<?php echo $pf; ?>button-size">
      <?php
      $current = $setting->getSetting( $pf . 'button_size', 'lg' );
      $styles  = array(
        'sm'    => __( 'Small', IPJCK_SLUG ),
        'md'    => __( 'Medium', IPJCK_SLUG ),
        'lg'    => __( 'Large', IPJCK_SLUG ),
        'vg'    => __( 'Very Large', IPJCK_SLUG )
      );
      foreach( $styles as $skey => $label ) {
        $sltd = '';
        if ( $skey == $current ) {
          $sltd = ' selected="selected"';
        }
        echo '<option value="' . $skey . '"' . $sltd .'>'. $label .'</option>';
      }
      ?>
    </select>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'The size of the button.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
</div>
<!-- end: .ipjck-field-row -->

<?php
//Full Width
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
    <label for="input-<?php echo $pf; ?>button-full-width">
      <?php _e( 'Full Width', IPJCK_SLUG ); ?>
    </label>
  </div>
  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

    <div class="ipjck-onoff">
      <?php
      $val  = $this->setting->getSetting( $pf . 'button_full_width', 'false' );
      if ( $val == 'false' ) {
          $clon  = '';
          $cloff = ' active';
      } else {
          $clon  = ' active';
          $cloff = '';
      }
      ?>
      <div class="ipjck-btn-group">
        <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
        <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
      </div>
      <input type="hidden" class="ipjck-onoff-value" name="<?php echo $pf; ?>button_full_width" value="<?php echo $val; ?>" />
    </div>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'Set on to switch button to full width.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
</div>
<!-- end: .ipjck-field-row -->

<?php
//Border radius
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
    <label for="input-<?php echo $pf; ?>button-radius"><?php _e( 'Radius', IPJCK_SLUG ); ?></label>
  </div>
  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

    <select name="<?php echo $pf; ?>button_radius" id="input-<?php echo $pf; ?>button-radius">
      <?php
      $current = $setting->getSetting( $pf . 'button_radius', 'none' );
      $styles  = array(
        'none' => __( 'None', IPJCK_SLUG ),
        'sm'   => __( 'Small', IPJCK_SLUG ),
        'md'   => __( 'Medium', IPJCK_SLUG ),
        'lg'   => __( 'Large', IPJCK_SLUG ),
        'ov'   => __( 'Oval', IPJCK_SLUG )
      );
      foreach( $styles as $skey => $label ) {
        $sltd = '';
        if ( $skey == $current ) {
          $sltd = ' selected="selected"';
        }
        echo '<option value="' . $skey . '"' . $sltd .'>'. $label .'</option>';
      }
      ?>
    </select>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'The radius of the button.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
</div>
<!-- end: .ipjck-field-row -->

<?php
//Icon Position
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
    <label for="input-<?php echo $pf; ?>button-icon-position"><?php _e( 'Icon Position', IPJCK_SLUG ); ?></label>
  </div>
  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

    <select name="<?php echo $pf; ?>button_icon_position" id="input-<?php echo $pf; ?>button-icon-position">
      <?php
      $current = $setting->getSetting( $pf . 'button_icon_position', 'left' );
      $styles  = array(
        'none'  => __( 'None', IPJCK_SLUG ),
        'left'  => __( 'Left', IPJCK_SLUG ),
        'right' => __( 'Right', IPJCK_SLUG )
      );
      foreach( $styles as $skey => $label ) {
        $sltd = '';
        if ( $skey == $current ) {
          $sltd = ' selected="selected"';
        }
        echo '<option value="' . $skey . '"' . $sltd .'>'. $label .'</option>';
      }
      ?>
    </select>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'The icon position in the button.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
</div>
<!-- end: .ipjck-field-row -->

<?php
/*
 * Button Icon
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
    <label for="input-<?php echo $pf; ?>button-icon"><?php _e( 'Button Icon', IPJCK_SLUG ); ?></label>
  </div>

  <!-- start: .ipjck-field -->
  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
    <?php
    $icon = stripslashes( $setting->getSetting( $pf . 'button_icon' ) );
    IPJck_Faicon::get_html_option( $pf . 'button_icon', $icon );
    ?>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide"><?php _e( 'The icon of the button.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->