<?php
/**
 * Manage box style view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting  = $this->setting;
$template = $setting->getSetting( 'template', 1 );
?>
<div id="ipjck-section-design" class="ipjck-tab-content">
  <div class="ipjck-tab-inner">

    <div class="ipjck-title-content ipjck-hide">
      <i class="ipjck-fa ipjck-fa-paint-brush"></i>
      <div class="ipjck-title-text">
        <h3><?php _e( 'Design', IPJCK_SLUG ); ?></h3>
        <p><?php _e( 'Set the style of the widget', IPJCK_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipjck-fields -->
    <div class="ipjck-fields">

      <h4 class="ipjck-field-title mb0 py10">
        <?php _e( 'General', IPJCK_SLUG ); ?>
      </h4>

      <?php
      //Position
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-md-3 col-sm-12">
          <label for="input-slide-position"><?php _e( 'Position', IPJCK_SLUG ); ?></label>
        </div>
        <div class="ipjck-field col-md-9 col-sm-12">

          <select name="slide_position" id="input-slide-position">
            <?php
            $current = $this->setting->getSetting( 'slide_position', 'bottom_right' );
            $options = array(
              'top_left'      => __( 'Top Left', IPJCK_SLUG ),
              'top_right'     => __( 'Top Right', IPJCK_SLUG ),
              'bottom_left'   => __( 'Bottom Left', IPJCK_SLUG ),
              'bottom_right'  => __( 'Bottom Right', IPJCK_SLUG )
            );
            foreach( $options as $key => $label )
            {
              $sltd = '';
              if ( $current == $key ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The position of widget slide in.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Modal Width
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-slide-width"><?php _e( 'Width', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $width = $setting->getSetting( 'slide_width', 320 );
          ?>
          <div class="ipjck-input-group mr5">
            <input type="text" id="input-slide-width" class="ipjck-input ipjck-input-xs" name="slide_width" value="<?php echo $width; ?>">
             <div class="ipjck-input-addon">px</div>
          </div>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Width ( in pixel ) of the slide in widget.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      //Mobile
      $this->view( 'admin/widget/design/mobile' );
      
      //
      //Padding
      if ( $template > 2 ) {
        $this->hidePadding = true;
      } else {
        $this->hidePadding2 = true;
      }
      if ( $template == 3 ) {
        $this->topPaddingLabel    = __( 'Header Section Padding', IPJCK_SLUG );
        $this->bottomPaddingLabel = __( 'Content Section Padding', IPJCK_SLUG );
      } 
      elseif ( $template == 4 || $template == 6 ) {
        $this->topPaddingLabel    = __( 'Main Section Padding', IPJCK_SLUG );
        $this->bottomPaddingLabel = __( 'Bottom Section Padding', IPJCK_SLUG );
      } 
      elseif ( $template == 5 ) {
        $this->topPaddingLabel    = __( 'Main Section Padding', IPJCK_SLUG );
        $this->bottomPaddingLabel = __( 'Content Section Padding', IPJCK_SLUG );
      } 
      else {
        $this->topPaddingLabel    = __( 'Top Section Padding', IPJCK_SLUG );
        $this->bottomPaddingLabel = __( 'Bottom Section Padding', IPJCK_SLUG );
      }
      $this->view( 'admin/widget/design/padding' );
      $this->view( 'admin/widget/design/padding2' );

      //
      //Background
      if ( $template > 2 ) {
        $this->hideBackground = true;
      } else {
        $this->hideBackground2 = true;
      }
      if ( $template == 3 ) {
        $this->mainBgLabel = __( 'Header Section Background', IPJCK_SLUG );
        $this->secBgLabel  = __( 'Content Section Background', IPJCK_SLUG );
      } 
      elseif ( $template == 4 || $template == 6 ) {
        $this->mainBgLabel = __( 'Main Section Background', IPJCK_SLUG );
        $this->secBgLabel  = __( 'Bottom Section Background', IPJCK_SLUG );
      } 
      elseif ( $template == 5 ) {
        $this->mainBgLabel = __( 'Main Section Background', IPJCK_SLUG );
        $this->secBgLabel  = __( 'Content Section Background', IPJCK_SLUG );
      } 
      else {
        $this->mainBgLabel = __( 'Top Section Background', IPJCK_SLUG );
        $this->secBgLabel  = __( 'Bottom Section Background', IPJCK_SLUG );
      }
      $this->view( 'admin/widget/design/background' );
      $this->view( 'admin/widget/design/background2' );

      //Border
      $this->view( 'admin/widget/design/border' );
      //Text
      $this->view( 'admin/widget/design/text' );
      //Close
      $this->view( 'admin/widget/design/close' );
      //Minimize
      $this->view( 'admin/widget/design/minimize' );
      ?>

    </div>
    <!-- end: .ipjck-fields -->

  </div>
</div>