<?php
/**
 * Admin statistic view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipjck-section-statistic" class="ipjck-tab-content ipjck-save-hide">
  <div class="ipjck-tab-inner">

    <div class="ipjck-title-content ipjck-hide">
      <i class="ipjck-fa ipjck-fa-line-chart"></i>
      <div class="ipjck-title-text">
        <h3><?php _e( 'Statistic', IPJCK_SLUG ); ?></h3>
        <p><?php _e( 'See the statistic data for your page', IPJCK_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipjck-fields -->
    <div class="ipjck-fields">

      <!-- start: .ipjck-statistic-page -->
      <div class="ipjck-statistic-page">

        <?php
        $clicks   = 0;
        $views    = 0;
        $submits  = 0;
        $rate     = 0;
        $model    = new IPJck_Model_PageStat();
        $pageId = $this->page->ID;
        $stats 		= $model->getStatByPage( $pageId );

        if ( ! empty( $stats )) {
          $clicks  = $stats->stat_click;
          $views   = $stats->stat_view;
          $submits = $stats->stat_subscribe;
          if ( ! empty( $stats->stat_view ) && ! empty( $stats->stat_click )) {
            $rate = $stats->stat_click/$stats->stat_view;
            $rate = number_format( $rate, 2, '.', '' );
          }
        }
        ?>

        <div class="ipjck-stat-filter ipjck-clear">
          <div class="ipjck-stat-nav">
            <div class="container container-fluid">
							<ul class="row">
								<li class="col-sm-3 ipjck-nav-view ipjck-nav-blue active">
									<a href="#stat-view">
										<i class="ipjck-fa ipjck-fa-eye"></i>
										<span class="stat-value">
											<strong> <?php echo number_format( $views); ?></strong>
											<em> <?php _e( 'Views', IPJCK_SLUG ); ?></em>
										</span>
									</a>
								</li>
								<li class="col-sm-3 ipjck-nav-click ipjck-nav-orange">
									<a href="#stat-click">
										<i class="ipjck-fa ipjck-fa-mouse-pointer"></i>
										<span class="stat-value">
											<strong> <?php echo number_format( $clicks ); ?></strong>
											<em> <?php _e( 'Clicks', IPJCK_SLUG ); ?></em>
										</span>
									</a>
								</li>
								<li class="col-sm-3 ipjck-nav-rate ipjck-nav-green active">
									<a class="ipjck-no-chart" href="#stat-rate">
										<i class="ipjck-fa ipjck-fa-line-chart"></i>
										<span class="stat-value">
											<strong> <?php echo $rate; ?></strong>
											<em> <?php _e( 'Conversion Rate', IPJCK_SLUG ); ?></em>
										</span>
									</a>
								</li>
							</ul>
						</div>
          </div>
          <div class="ipjck-date-filter">
            <form action="" method="post">
              <input type="hidden" id="value-pageid" name="pageid" value="<?php echo $pageId; ?>" />
              <input type="hidden" id="value-stat-type" name="stat_type" value="view" />
              <?php
              $dateStart = date('m/d/Y');
              $dateEnd   = date('m/d/Y');
              ?>
              <strong> <?php _e( 'Filter By Date', IPJCK_SLUG ); ?>: </strong>
              <span class="ipjck-date-input">
                <input type="text" id="date-start" name="cdatestart" value="<?php echo $dateStart; ?>" />
                -
                <input type="text" id="date-end" name="cdateend" value="<?php echo $dateEnd; ?>" />
              </span>
              <span class="ipjck-do-filter">
                <input type="submit" id="do-filter-date" class="button button-primary" name="do_filter_date" value="<?php _e( 'Go', IPJCK_SLUG ); ?>" />
              </span>
            </form>
          </div>
        </div>

        <div class="ipjck-stat-main">
          <h4><?php _e( 'Views Statistic', IPJCK_SLUG ); ?></h4>
          <div class="ipjck-stat-chart">

            <script type="text/javascript" src="https://www.google.com/jsapi"></script>
            <script type="text/javascript">
              google.load("visualization", "1", {packages:["corechart"]});
              google.setOnLoadCallback(drawChart);
              function drawChart() 
              {
                var dataTable = new google.visualization.DataTable();
                dataTable.addColumn( 'date', '<?php _e( 'Date', IPJCK_SLUG ); ?>' );
                dataTable.addColumn( 'number', '<?php _e( 'View', IPJCK_SLUG ); ?>' );

                var rows = [
                <?php
                $stdata = $model->getStatisticData( $pageId, 'view' );
                if ( $stdata ) {
                  foreach( $stdata as $data ) {
                    $timestamp = strtotime( $data->gdate );
                    $phpdate   = getdate($timestamp);

                    echo '[new Date('
                            . $phpdate['year'] . ', '
                            . ( $phpdate['mon']  - 1 ) . ', '
                            . $phpdate['mday'] . ',0,0,0), '
                            . $data->value
                        . '],';
                  }
                }
                ?>
                ];
                dataTable.addRows( rows );

                var options = {
                    series: [{pointSize:6}]
                };
                var chart = new google.visualization.LineChart(document.getElementById('ipjck-chart-div'));
                chart.draw(dataTable, options);
              }
            </script>

            <div 
            	id="ipjck-chart-div" 
            	class="ipjck-chart-main" 
            	style="width: 100%; height: 500px;"></div>
            <div class="ipjck-chart-load" style="display: none;">
              <?php
              $src = IPJCK_BASE_URL . 'assets/img/loading.gif';
              ?>
              <img src="<?php echo $src; ?>" alt="Loading..." />
            </div>

          </div>
        </div>

      </div>
      <!-- end: .ipjck-statistic -->

    </div>
    <!-- end: .ipjck-fields -->

  </div>
</div>
