<?php
/**
 * Admin manage seo content of review page
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */
$setting = $this->setting;
?>
<div id="ipjck-section-seo" class="ipjck-tab-content">
  <div class="ipjck-tab-inner">

    <div class="ipjck-title-content ipjck-hide">
      <i class="ipjck-fa ipjck-fa-globe"></i>
      <div class="ipjck-title-text">
        <h3><?php _e( 'SEO', IPJCK_SLUG ); ?></h3>
        <p><?php _e( 'Manage SEO content for the page', IPJCK_SLUG ); ?></p>
      </div>
    </div>
    <!-- start: .ipjck-fields -->
    <div class="ipjck-fields">

      <?php
      /*
       * Meta Title
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-seo-meta-title"><?php _e( 'Meta Title', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $title = $setting->getSetting( 'seo_meta_title' );
          ?>
          <input type="text" id="input-seo-meta-title" class="ipjck-input ipjck-input-full" name="seo_meta_title" value="<?php echo $title; ?>">

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The meta title content for the page.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Meta Description
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-seo-meta-description"><?php _e( 'Meta Description', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $description = $setting->getSetting( 'seo_meta_description' );
          ?>
          <input type="text" id="input-seo-meta-description" class="ipjck-input ipjck-input-full" name="seo_meta_description" value="<?php echo $description; ?>">

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The meta description content for the page.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Meta Keywords
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-seo-meta-keywords"><?php _e( 'Meta Keywords', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $keywords = $setting->getSetting( 'seo_meta_keywords' );
          ?>
          <input type="text" id="input-seo-meta-keywords" class="ipjck-input ipjck-input-full" name="seo_meta_keywords" value="<?php echo $keywords; ?>">

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The meta keywords content for the page.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Open Graph Image URL
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-seo-graph-image"><?php _e( 'Open Graph Image URL', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $url = $setting->getSetting( 'seo_graph_image' );
          ?>
          <input type="text" id="input-seo-graph-image" class="ipjck-input ipjck-input-full" name="seo_graph_image" value="<?php echo $url; ?>">

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The open graph image url for the page.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Favicon URL
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-seo-favicon"><?php _e( 'Favicon URL', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $url = $setting->getSetting( 'seo_favicon' );
          ?>
          <input type="text" id="input-seo-favicon" class="ipjck-input ipjck-input-full" name="seo_favicon" value="<?php echo $url; ?>">

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The favicon url for the page.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Tracking Code
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-seo-tracking-code"><?php _e( 'Tracking Code', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $code = $setting->getSetting( 'seo_tracking_code' );
          ?>
          <textarea id="input-seo-tracking-code" class="ipjck-input ipjck-input-full" name="seo_tracking_code"><?php echo $code; ?></textarea>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The tracking code for the page.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

    </div>
    <!-- end: .ipjck-fields -->
  </div>
</div>
