<?php
/**
 * Manage box style view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting  = $this->setting;
$template = $setting->getSetting( 'template', 1 );
?>
<div id="ipjck-section-design" class="ipjck-tab-content">
  <div class="ipjck-tab-inner">

    <div class="ipjck-title-content ipjck-hide">
      <i class="ipjck-fa ipjck-fa-paint-brush"></i>
      <div class="ipjck-title-text">
        <h3><?php _e( 'Design', IPJCK_SLUG ); ?></h3>
        <p><?php _e( 'Set the style of the widget', IPJCK_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipjck-fields -->
    <div class="ipjck-fields">

      <h4 class="ipjck-field-title mb0 py10">
        <?php _e( 'General', IPJCK_SLUG ); ?>
      </h4>

      <!-- start: .ipjck-section-select -->
      <div class="ipjck-section-select">

        <!-- start: .ipjck-field-row -->
        <div class="ipjck-field-row ipjck-field-x">
          <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
            <label for="input-modal-size">
              <?php _e( 'Modal Size', IPJCK_SLUG ); ?>
            </label>
          </div>

          <!-- start: .ipjck-field -->
          <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

            <select name="modal_size" id="input-modal-size" class="ipjck-input ipjck-section-select-options">
              <?php
              $current = $setting->getSetting( 'modal_size', 'custom' );
              $types   = array(
                'custom' => __( 'Custom Size', IPJCK_SLUG ),
                'full'   => __( 'Full Size', IPJCK_SLUG )
              );
              foreach( $types as $key => $label )
              {
                $sltd = '';
                if ( $current == $key ) {
                  $sltd = ' selected="selected"';
                }
                echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
              }
              ?>
            </select>

            <div class="ipjck-help">
              <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
              <div class="ipjck-help-content ipjck-hide">
                <?php _e( 'Set the modal size.', IPJCK_SLUG ); ?>
              </div>
            </div>
          </div>
          <!-- end: .ipjck-field -->
        </div>
        <!-- end: .ipjck-field-row -->

        <?php
        //Custom options
        //
        $dspCustom = ' style="display:none";';
        if ( $current == 'custom' ) {
          $dspCustom = '';
        }
        ?>
        <!-- start: .ipjck-section-select-content -->
        <div id="ipjck-section-custom" class="ipjck-section-select-content"<?php echo $dspCustom; ?>>

          <?php
          /*
           * Modal Width
           */
          ?>
          <!-- start: .ipjck-field-row -->
          <div class="ipjck-field-row ipjck-field-x">
            <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
              <label for="input-modal-width"><?php _e( 'Modal Width', IPJCK_SLUG ); ?></label>
            </div>

            <!-- start: .ipjck-field -->
            <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

              <?php
              $width = $setting->getSetting( 'modal_width', 600 );
              ?>
              <div class="ipjck-input-group mr5">
                <input type="text" id="input-modal-width" class="ipjck-input ipjck-input-xs" name="modal_width" value="<?php echo $width; ?>">
                 <div class="ipjck-input-addon">px</div>
              </div>

              <div class="ipjck-help">
                <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
                <div class="ipjck-help-content ipjck-hide">
                  <?php _e( 'Width ( in pixel ) of the modal popup.', IPJCK_SLUG ); ?>
                </div>
              </div>
            </div>
            <!-- end: .ipjck-field -->
          </div>
          <!-- end: .ipjck-field-row -->

          <?php
          /*
           * Modal Height
           */
          ?>
          <!-- start: .ipjck-field-row -->
          <div class="ipjck-field-row ipjck-field-x" style="border-bottom:1px solid #ddd;">
            <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
              <label for="input-modal-height"><?php _e( 'Modal Height', IPJCK_SLUG ); ?></label>
            </div>

            <!-- start: .ipjck-field -->
            <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

              <?php
              $height = $setting->getSetting( 'modal_height' );
              ?>
              <div class="ipjck-input-group mr5">
                <input type="text" id="input-modal-height" class="ipjck-input ipjck-input-xs" name="modal_height" value="<?php echo $height; ?>">
                 <div class="ipjck-input-addon">px</div>
              </div>

              <div class="ipjck-help">
                <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
                <div class="ipjck-help-content ipjck-hide">
                  <?php _e( 'Height ( in pixel ) of the modal popup.', IPJCK_SLUG ); ?>
                </div>
              </div>
            </div>
            <!-- end: .ipjck-field -->
          </div>
          <!-- end: .ipjck-field-row -->

        </div>
        <!-- end: .ipjck-section-select-content -->

      </div>
      <!-- end: .ipjck-section-select -->

      <?php
      //Mobile
      $this->view( 'admin/widget/design/mobile' );
      //
      //Padding
      if ( $template > 3 ) {
        $this->hidePadding = true;
      } else {
        $this->hidePadding2 = true;
      }
      if ( $template == 6 ) {
        $this->topPaddingLabel    = __( 'Left Section Padding', IPJCK_SLUG );
        $this->bottomPaddingLabel = __( 'Right Section Padding', IPJCK_SLUG );
      } 
      elseif ( $template == 7 ) {
        $this->topPaddingLabel    = __( 'Main Section Padding', IPJCK_SLUG );
        $this->bottomPaddingLabel = __( 'Content Section Padding', IPJCK_SLUG );
      } 
      else {
        $this->topPaddingLabel    = __( 'Top Section Padding', IPJCK_SLUG );
        $this->bottomPaddingLabel = __( 'Bottom Section Padding', IPJCK_SLUG );
      }
      $this->view( 'admin/widget/design/padding' );
      $this->view( 'admin/widget/design/padding2' );
      //
      //Background
      if ( $template > 3 ) {
        $this->hideBackground = true;
      } else {
        $this->hideBackground2 = true;
      }
      if ( $template == 6 ) {
        $this->mainBgLabel = __( 'Left Section Background', IPJCK_SLUG );
        $this->secBgLabel  = __( 'Right Section Background', IPJCK_SLUG );
      } 
      elseif ( $template == 7 ) {
        $this->mainBgLabel = __( 'Content Section Background', IPJCK_SLUG );
        $this->secBgLabel  = __( 'Main Section Background', IPJCK_SLUG );
      } 
      else {
        $this->mainBgLabel = __( 'Top Section Background', IPJCK_SLUG );
        $this->secBgLabel  = __( 'Bottom Section Background', IPJCK_SLUG );
      }
      $this->view( 'admin/widget/design/background' );
      $this->view( 'admin/widget/design/background2' );
      ?>

      <h4 class="ipjck-field-title mb0 py10">
        <?php _e( 'Background Overlay', IPJCK_SLUG ); ?>
      </h4>

      <?php
      //
      //Background overlay setting
      //
      ?>

      <?php
      /*
       * Background Overlay Color
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-background-overlay-color"><?php _e( 'Background Overlay Color', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

          <?php
          $color = stripslashes( $setting->getSetting( 'background_overlay_color', '#000000' ) );
          ?>
          <input type="text" class="ipjck-color-picker" id="input-background-overlay-color" name="background_overlay_color" value="<?php echo $color; ?>" />

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Set background overlay color.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Background opacity
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-background-overlay-opacity">
            <?php _e( 'Background Overlay Opacity', IPJCK_SLUG ); ?>
          </label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $opacity = $setting->getSetting( 'background_overlay_opacity' );
          $options = array(
              0    => __( 'None', IPJCK_SLUG ),
              10   => __( '10%', IPJCK_SLUG ),
              20   => __( '20%', IPJCK_SLUG ),
              30   => __( '30%', IPJCK_SLUG ),
              40   => __( '40%', IPJCK_SLUG ),
              50   => __( '50%', IPJCK_SLUG ),
              60   => __( '60%', IPJCK_SLUG ),
              70   => __( '70%', IPJCK_SLUG ),
              80   => __( '80%', IPJCK_SLUG ),
              90   => __( '90%', IPJCK_SLUG ),
          );
          ?>
          <select name="background_overlay_opacity" id="input-background-overlay-opacity">
            <?php
            foreach( $options as $key => $label )
            {
              $sltd = '';
              if ( $key == $opacity ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Make transparency for the background overlay.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      //Border
      $this->view( 'admin/widget/design/border' );
      //Text
      $this->view( 'admin/widget/design/text' );
      //Close
      $this->view( 'admin/widget/design/close' );
      ?>

    </div>
    <!-- end: .ipjck-fields -->

  </div>
</div>