<?php
/**
 * Meta box options view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipjck-metabox" class="ipjck-wrap">
  <div class="container-fluid container ipjck-form">
    <div class="ipjck-fields">

      <?php
      /*
       * Type
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="ipjck-input-metabox-type"><?php _e( 'Type', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

          <select name="ipjck_post_type" id="ipjck-input-metabox-type">
            <option value="0"><?php _e( 'None', IPJCK_SLUG ); ?></option>
            <?php
            $currentType = get_post_meta( $this->post->ID, '__ipjck_post_type', true );
            $options = array();

            if ( ! empty( $this->modals )) {
              $options['modal'] = __( 'Modal Popup', IPJCK_SLUG );
            }
            if ( ! empty( $this->bars )) {
              $options['bar'] = __( 'Info Bar', IPJCK_SLUG );
            }
            if ( ! empty( $this->slides )) {
              $options['slide'] = __( 'Slide In', IPJCK_SLUG );
            }

            if ( ! empty( $options ))
            {
              foreach( $options as $key => $label )
              {
                $sltd = '';
                if ( $key == $currentType ) {
                  $sltd = ' selected="selected"';
                }
                echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
              }
            }
            ?>
          </select>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Modal
       */

      if ( ! empty( $this->modals )) :

        $dspModal = ' style="display:none;"';
        if ( $currentType == 'modal' ) {
          $dspModal = '';
        }
      ?>
      <!-- start: .ipjck-field-row -->
      <div id="ipjck-input-metabox-modal" class="ipjck-input-metabox-widget ipjck-field-row ipjck-field-x"<?php echo $dspModal; ?>>
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="ipjck-input-modal"><?php _e( 'Modal Popup', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

          <select name="ipjck_post_modal" id="ipjck-input-modal">
            <option value="0"><?php _e( 'None', IPJCK_SLUG ); ?></option>
            <?php
            $current = get_post_meta( $this->post->ID, '__ipjck_post_modal', true );

            if ( ! empty( $this->modals ))
            {
              foreach( $this->modals as $modal )
              {
                $sltd = '';
                if ( $modal->ID == $current ) {
                  $sltd = ' selected="selected"';
                }
                echo '<option value="' . $modal->ID . '"' . $sltd . '>' . $modal->post_title . '</option>';
              }
            }
            ?>
          </select>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      endif;
      //End modal
      ?>

      <?php
      /*
       * Bar
       */

      if ( ! empty( $this->bars )) :

        $dspBar = ' style="display:none;"';
        if ( $currentType == 'bar' ) {
          $dspBar = '';
        }
      ?>
      <!-- start: .ipjck-field-row -->
      <div id="ipjck-input-metabox-bar" class="ipjck-input-metabox-widget ipjck-field-row ipjck-field-x"<?php echo $dspBar; ?>>
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="ipjck-input-bar"><?php _e( 'Info Bar', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

          <select name="ipjck_post_bar" id="ipjck-input-bar">
            <option value="0"><?php _e( 'None', IPJCK_SLUG ); ?></option>
            <?php
            $current = get_post_meta( $this->post->ID, '__ipjck_post_bar', true );

            if ( ! empty( $this->bars ))
            {
              foreach( $this->bars as $bar )
              {
                $sltd = '';
                if ( $bar->ID == $current ) {
                  $sltd = ' selected="selected"';
                }
                echo '<option value="' . $bar->ID . '"' . $sltd . '>' . $bar->post_title . '</option>';
              }
            }
            ?>
          </select>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      endif;
      //End bar
      ?>

      <?php
      /*
       * Slide In
       */

      if ( ! empty( $this->slides )) :

        $dspSlide = ' style="display:none;"';
        if ( $currentType == 'slide' ) {
          $dspSlide = '';
        }
      ?>
      <!-- start: .ipjck-field-row -->
      <div id="ipjck-input-metabox-slide" class="ipjck-input-metabox-widget ipjck-field-row ipjck-field-x"<?php echo $dspSlide; ?>>
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="ipjck-input-slide"><?php _e( 'Slide In', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

          <select name="ipjck_post_slide" id="ipjck-input-slide">
            <option value="0"><?php _e( 'None', IPJCK_SLUG ); ?></option>
            <?php
            $current = get_post_meta( $this->post->ID, '__ipjck_post_slide', true );

            if ( ! empty( $this->slides ))
            {
              foreach( $this->slides as $slide )
              {
                $sltd = '';
                if ( $slide->ID == $current ) {
                  $sltd = ' selected="selected"';
                }
                echo '<option value="' . $slide->ID . '"' . $sltd . '>' . $slide->post_title . '</option>';
              }
            }
            ?>
          </select>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      endif;
      //End slide
      ?>

    </div>
  </div>
  <?php wp_nonce_field( plugin_basename( __FILE__ ), 'ipjck_mbox_nonce' ); ?>
</div>
