<?php
/**
 * Admin setting view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipjck-setting" class="wrap ipjck-wrap ipjck-admin">
  <div class="ipjck-inner">

    <?php
    $this->view( 'admin/general/header' );
    ?>

    <div class="ipjck-main">
      <div class="ipjck-main-info"></div>

      <div class="ipjck-primary">
        <div class="ipjck-manage-wrap">
          <?php
          $formAction = admin_url( 'admin-ajax.php' ) . '?doajax=1&ipjck=1&action=setting';
          ?>
          <form id="ipjck-form-setting" class="ipjck-form-container ipjck-form" method="post" action="<?php echo $formAction; ?>" enctype="multipart/form-data">

            <div class="container-fluid container">
              <div class="mb40">

                <h3 class="ipjck-field-title mb20 py10">
                  <?php _e( 'Result Permalink', IPJCK_SLUG ); ?>
                </h3>
                <p><?php _e( 'Set the base path permalink for all your result page:', IPJCK_SLUG ); ?></p>

                <!-- start: .fields -->
                <div class="fields">

                  <!-- start: .ipjck-field-row -->
                  <div class="ipjck-field-row ipjck-field-x">
                    <div class="ipjck-form-label col-lg-2 col-md-3 col-sm-4">
                      <label for="input-result-base-path"><?php _e( 'Result Page Base Path', IPJCK_SLUG ); ?></label>
                    </div>
                    <div class="ipjck-field col-lg-6 col-md-8 col-sm-8">
                      <?php
                      $resultPath = get_option( '__ipjck_base_path', 'result' );
                      ?>
                      <input type="text" id="input-result-base-path" class="ipjck-input ipjck-input-full" name="result_base_path" value="<?php echo $resultPath; ?>">
                    </div>
                  </div>
                  <!-- start: .ipjck-field-row -->
                </div>

              </div>
              <!-- end: .fields -->

              <h3 class="ipjck-field-title mb20 py10">
                <?php _e( 'General Widgets', IPJCK_SLUG ); ?>
              </h3>
              <p><?php _e( 'Show widgets in all page. If it is determined that all of the settings of widget object in every page of the website will be ignored.', IPJCK_SLUG ); ?></p>

              <!-- start: .fields -->
              <div class="fields">

                <?php
                /*
                 * Widget
                 */
                ?>
                <!-- start: .ipjck-field-row -->
                <div class="ipjck-field-row ipjck-field-x">
                  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
                    <label for="input-general-widget"><?php _e( 'Widget', IPJCK_SLUG ); ?></label>
                  </div>

                  <!-- start: .ipjck-field -->
                  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

                    <select name="general_widget" id="input-general-widget">
                      <option value="0"><?php _e( 'None', IPJCK_SLUG ); ?></option>
                      <?php
                      $current = get_option( '__ipjck_general_widget' );
                      if ( ! empty( $this->widgets ))
                      {
                        foreach( $this->widgets as $widget )
                        {
                          $sltd = '';
                          if ( $widget->ID == $current ) {
                            $sltd = ' selected="selected"';
                          }
                          echo '<option value="' . $widget->ID . '"' . $sltd . '>' . $widget->post_title . '</option>';
                        }
                      }
                      ?>
                    </select>
                  </div>
                  <!-- end: .ipjck-field -->
                </div>
                <!-- end: .ipjck-field-row -->

              </div>
              <!-- end: .fields -->

              <h3 class="ipjck-field-title mb20 py10">
                <?php _e( 'Home Widgets', IPJCK_SLUG ); ?>
              </h3>
              <p><?php _e( 'Set some options in bellow to show widgets in your homepage.', IPJCK_SLUG ); ?></p>

              <!-- start: .fields -->
              <div class="fields">

                <?php
                /*
                 * Widget
                 */
                ?>
                <!-- start: .ipjck-field-row -->
                <div class="ipjck-field-row ipjck-field-x">
                  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
                    <label for="input-home-widget"><?php _e( 'Widget', IPJCK_SLUG ); ?></label>
                  </div>

                  <!-- start: .ipjck-field -->
                  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

                    <select name="home_widget" id="input-home-widget">
                      <option value="0"><?php _e( 'None', IPJCK_SLUG ); ?></option>
                      <?php
                      $current = get_option( '__ipjck_home_widget' );
                      if ( ! empty( $this->widgets ))
                      {
                        foreach( $this->widgets as $widget )
                        {
                          $sltd = '';
                          if ( $widget->ID == $current ) {
                            $sltd = ' selected="selected"';
                          }
                          echo '<option value="' . $widget->ID . '"' . $sltd . '>' . $widget->post_title . '</option>';
                        }
                      }
                      ?>
                    </select>
                  </div>
                  <!-- end: .ipjck-field -->
                </div>
                <!-- end: .ipjck-field-row -->

              </div>
              <!-- end: .fields -->

              <div class="ipjck-form-footer">
                <div class="row">
                  <div class="col-md-6">
                    <div class="ipjck-bottom-submit">
                      <button type="submit" class="ipjck-form-submit ipjck-btn ipjck-btn-secondary ipjck-btn-lg" id="do-save-setting" name="save_setting">
                        <i class="ipjck-fa ipjck-fa-floppy-o"></i>
                        <strong><?php _e( 'Save Change', IPJCK_SLUG ); ?></strong>
                      </button>
                    </div>
                  </div>
                  <div class="col-md-6">
                  </div>
                </div>

              </div>

            </div>
          </form>
        </div>
      </div>

    </div>

  </div>

</div>
