<?php
if ( ! class_exists( 'IPJck_Viewer' ))
{
  /**
   * Viewer class
   *
   * @package wp-viral-click
   * @author InstaProduct
   * @link http://insta-product.com/
   */

  class IPJck_Viewer
  {
    //{{ dashboard

    /**
     * Dashboard viewer
     *
     * @return void
     */
    public function dashboard()
    {
      $this->pageId = IPJCK_PAGENAME;

      //Edit widget
      if ( isset( $_GET['action'] ) && $_GET['action'] == 'edit' )
      {
        if ( empty( $_GET['id'] )) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPJCK_SLUG ) );
        }
        $id = absint( $_GET['id'] );
        if ( ! $widget = get_post( $id ) ) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPJCK_SLUG ) );
        }
        $this->_manageWidget( $widget );
      }
      //Widget dashboard
      else {
        $this->view( 'admin/dashboard' );
      }
    }

    //}}
    //{{ modal

    /**
     * Modal management
     *
     * @return void
     */
    public function modal()
    {
      $this->pageId = IPJCK_PAGENAME . '-modal';

      //Edit modal
      if ( isset( $_GET['action'] ) && $_GET['action'] == 'edit' )
      {
        if ( empty( $_GET['id'] )) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPJCK_SLUG ) );
        }
        $id = absint( $_GET['id'] );
        if ( ! $modal = get_post( $id ) ) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPJCK_SLUG ) );
        }
        $this->_manageModal( $modal );
      }
      //Add modal
      else if ( isset( $_GET['action'] ) && $_GET['action'] == 'create' )
      {
        $this->_manageModal();
      }
      //Modals page
      else {
        $this->view( 'admin/modal/index' );
      }
    }

    //}}
    //{{ _manageModal

    /**
     * Manage modal
     *
     * @param object $modal
     * @return void
     */
    protected function _manageModal( $modal = false )
    {
      //
      //Including script
      wp_enqueue_media();
      wp_enqueue_script('wp-color-picker');
      wp_enqueue_style('wp-color-picker');

      $modalId = 0;
      if ( $modal ) {
        $modalId = $modal->ID;
      }
      $setting    = new IPJck_Setting( $modalId, '__ipjck-widget-setting' );
      $formAction = admin_url( 'admin-ajax.php' ) . '?doajax=1&ipjck=1&action=update_modal';
      if ( $modal )
      {
        $pageTitle   = __( 'Edit Modal', IPJCK_SLUG );
        $submitLabel = __( 'Save Change', IPJCK_SLUG );
        $submitId    = 'ipjck-edit-modal';
        $formId      = 'ipjck-form-modal-update';
        $submitIcon  = 'floppy-o';

      } else
      {
        $pageTitle   = __( 'Add Modal', IPJCK_SLUG );
        $submitLabel = __( 'Add Modal', IPJCK_SLUG );
        $submitId    = 'ipjck-add-modal';
        $formId      = 'ipjck-form-modal-add';
        $submitIcon  = 'plus-circle';
      }
      $this->pageTitle   = $pageTitle;
      $this->submitLabel = $submitLabel;
      $this->submitId    = $submitId;
      $this->formId      = $formId;
      $this->submitIcon  = $submitIcon;
      $this->setting     = $setting;
      $this->modal       = $modal;
      $this->widget      = $modal;
      $this->modalId     = $modalId;
      $this->formAction  = $formAction;
      $this->widgetType  = 'modal';
      $this->template    = $setting->getSetting( 'template', 1 );
      $this->pageDescription = __( 'Basic settings and info of your modal popup', IPJCK_SLUG );


      $tab = 'ipjck-section-general';
      if ( ! empty( $_REQUEST['tab'] )) {
        $tab = $_REQUEST['tab'];
      }
      $this->tab = $tab;

      //Render view
      $this->view( 'admin/modal/manage' );
    }

    //}}
    //{{ bar

    /**
     * Bar management
     *
     * @return void
     */
    public function bar()
    {
      $this->pageId = IPJCK_PAGENAME . '-bar';

      //Edit bar
      if ( isset( $_GET['action'] ) && $_GET['action'] == 'edit' )
      {
        if ( empty( $_GET['id'] )) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPJCK_SLUG ) );
        }
        $id = absint( $_GET['id'] );
        if ( ! $bar = get_post( $id ) ) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPJCK_SLUG ) );
        }
        $this->_manageBar( $bar );
      }
      //Add bar
      else if ( isset( $_GET['action'] ) && $_GET['action'] == 'create' )
      {
        $this->_manageBar();
      }
      //Modals page
      else {
        $this->view( 'admin/bar/index' );
      }
    }

    //}}
    //{{ _manageBar

    /**
     * Manage bar
     *
     * @param object $bar
     * @return void
     */
    protected function _manageBar( $bar = false )
    {
      //
      //Including script
      wp_enqueue_media();
      wp_enqueue_script('wp-color-picker');
      wp_enqueue_style('wp-color-picker');

      $barId = 0;
      if ( $bar ) {
        $barId = $bar->ID;
      }
      $setting    = new IPJck_Setting( $barId, '__ipjck-widget-setting' );
      $formAction = admin_url( 'admin-ajax.php' ) . 
        '?doajax=1&ipjck=1&action=update_bar';
      if ( $bar )
      {
        $pageTitle   = __( 'Edit Info Bar', IPJCK_SLUG );
        $submitLabel = __( 'Save Change', IPJCK_SLUG );
        $submitId    = 'ipjck-edit-bar';
        $formId      = 'ipjck-form-bar-update';
        $submitIcon  = 'floppy-o';

      } else
      {
        $pageTitle   = __( 'Add Info Bar', IPJCK_SLUG );
        $submitLabel = __( 'Add Info Bar', IPJCK_SLUG );
        $submitId    = 'ipjck-add-bar';
        $formId      = 'ipjck-form-bar-add';
        $submitIcon  = 'plus-circle';
      }
      $this->pageTitle   = $pageTitle;
      $this->submitLabel = $submitLabel;
      $this->submitId    = $submitId;
      $this->formId      = $formId;
      $this->submitIcon  = $submitIcon;
      $this->setting     = $setting;
      $this->bar         = $bar;
      $this->widget      = $bar;
      $this->barId       = $barId;
      $this->formAction  = $formAction;
      $this->widgetType  = 'bar';
      $this->template    = $setting->getSetting( 'template', 1 );
      $this->pageDescription = __( 'Basic settings and info of your info bar', IPJCK_SLUG );


      $tab = 'ipjck-section-general';
      if ( ! empty( $_REQUEST['tab'] )) {
        $tab = $_REQUEST['tab'];
      }
      $this->tab = $tab;

      //Render view
      $this->view( 'admin/bar/manage' );
    }

    //}}
    //{{ slide

    /**
     * Slide management
     *
     * @return void
     */
    public function slide()
    {
      $this->pageId = IPJCK_PAGENAME . '-slide';

      //Edit slide
      if ( isset( $_GET['action'] ) && $_GET['action'] == 'edit' )
      {
        if ( empty( $_GET['id'] )) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPJCK_SLUG ) );
        }
        $id = absint( $_GET['id'] );
        if ( ! $slide = get_post( $id ) ) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPJCK_SLUG ) );
        }
        $this->_manageSlide( $slide );
      }
      //Add slide
      else if ( isset( $_GET['action'] ) && $_GET['action'] == 'create' )
      {
        $this->_manageSlide();
      }
      //Modals page
      else {
        $this->view( 'admin/slide/index' );
      }
    }

    //}}
    //{{ _manageSlide

    /**
     * Manage slide
     *
     * @param object $slide
     * @return void
     */
    protected function _manageSlide( $slide = false )
    {
      //
      //Including script
      wp_enqueue_media();
      wp_enqueue_script('wp-color-picker');
      wp_enqueue_style('wp-color-picker');

      $slideId = 0;
      if ( $slide ) {
        $slideId = $slide->ID;
      }
      $setting    = new IPJck_Setting( $slideId, '__ipjck-widget-setting' );
      $formAction = admin_url( 'admin-ajax.php' ) . 
        '?doajax=1&ipjck=1&action=update_slide';
      if ( $slide )
      {
        $pageTitle   = __( 'Edit Slide In', IPJCK_SLUG );
        $submitLabel = __( 'Save Change', IPJCK_SLUG );
        $submitId    = 'ipjck-edit-slide';
        $formId      = 'ipjck-form-slide-update';
        $submitIcon  = 'floppy-o';

      } else
      {
        $pageTitle   = __( 'Add Slide In', IPJCK_SLUG );
        $submitLabel = __( 'Add Slide In', IPJCK_SLUG );
        $submitId    = 'ipjck-add-slide';
        $formId      = 'ipjck-form-slide-add';
        $submitIcon  = 'plus-circle';
      }
      $this->pageTitle   = $pageTitle;
      $this->submitLabel = $submitLabel;
      $this->submitId    = $submitId;
      $this->formId      = $formId;
      $this->submitIcon  = $submitIcon;
      $this->setting     = $setting;
      $this->slide       = $slide;
      $this->widget      = $slide;
      $this->slideId     = $slideId;
      $this->formAction  = $formAction;
      $this->widgetType  = 'slide';
      $this->template    = $setting->getSetting( 'template', 1 );
      $this->pageDescription = __( 'Basic settings and info of your slide in', IPJCK_SLUG );


      $tab = 'ipjck-section-general';
      if ( ! empty( $_REQUEST['tab'] )) {
        $tab = $_REQUEST['tab'];
      }
      $this->tab = $tab;

      //Render view
      $this->view( 'admin/slide/manage' );
    }

    //}}
    //{{ page

    /**
     * Page management
     *
     * @return void
     */
    public function page()
    {
      $this->pageId = IPJCK_PAGENAME . '-page';

      //Edit page
      if ( isset( $_GET['action'] ) && $_GET['action'] == 'edit' )
      {
        if ( empty( $_GET['id'] )) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPJCK_SLUG ) );
        }
        $id = absint( $_GET['id'] );
        if ( ! $page = get_post( $id ) ) {
          wp_die( __('You attempted to edit an item that doesn&#8217;t exist. Perhaps it was deleted?', IPJCK_SLUG ) );
        }
        $this->_managePage( $page );
      }
      //Add page
      else if ( isset( $_GET['action'] ) && $_GET['action'] == 'create' )
      {
        $this->_managePage();
      }
      //Modals page
      else {
        $this->view( 'admin/page/index' );
      }
    }

    //}}
    //{{ _managePage

    /**
     * Manage page
     *
     * @param object $page
     * @return void
     */
    protected function _managePage( $page = false )
    {
      //
      //Including script
      wp_enqueue_media();
      wp_enqueue_script('wp-color-picker');
      wp_enqueue_style('wp-color-picker');

      $pageId = 0;
      if ( $page ) {
        $pageId = $page->ID;
      }
      $setting    = new IPJck_Setting( $pageId, '__ipjck-page-setting' );
      $formAction = admin_url( 'admin-ajax.php' ) . 
        '?doajax=1&ipjck=1&action=update_page';
      if ( $page )
      {
        $pageTitle   = __( 'Edit Page', IPJCK_SLUG );
        $submitLabel = __( 'Save Change', IPJCK_SLUG );
        $submitId    = 'ipjck-edit-page';
        $formId      = 'ipjck-form-page-update';
        $submitIcon  = 'floppy-o';

      } else
      {
        $pageTitle   = __( 'Add Page', IPJCK_SLUG );
        $submitLabel = __( 'Add Page', IPJCK_SLUG );
        $submitId    = 'ipjck-add-page';
        $formId      = 'ipjck-form-page-add';
        $submitIcon  = 'plus-circle';
      }
      $this->setting     = $setting;
      $this->pageTitle   = $pageTitle;
      $this->submitLabel = $submitLabel;
      $this->submitId    = $submitId;
      $this->formId      = $formId;
      $this->submitIcon  = $submitIcon;
      $this->page        = $page;
      $this->widget      = $page;
      $this->itemId      = $pageId;
      $this->pageId      = IPJCK_PAGENAME . '-page';
      $this->formAction  = $formAction;
      $this->modals      = $this->_getModals();
      $this->bars        = $this->_getBars();
      $this->slides      = $this->_getSlides();

      //
      //Permalink root
      $home = get_home_url();
      $path = get_option( '__ipjck_base_path', 'detail' );
      $root = $home . '/' . $path . '/';
      $this->permalink_root = $root;


      $tab = 'ipjck-section-general';
      if ( ! empty( $_REQUEST['tab'] )) {
        $tab = $_REQUEST['tab'];
      }
      $this->tab = $tab;

      //Render view
      $this->view( 'admin/page/manage' );
    }

    //}}
    //{{ setting

    /**
     * Setting page viewer
     *
     * @return void
     */
    public function setting()
    {
      $this->modals  = $this->_getModals();
      $this->bars    = $this->_getBars();
      $this->slides  = $this->_getSlides();
      $this->pageId = IPJCK_PAGENAME . '-setting';
      //Render view
      $this->view( 'admin/setting' );
    }

    //}}
    //{{ view

    /**
     * Get admin view file
     *
     * @param string $filename
     * @return void
     */
    public function view( $filename )
    {
      $path  = IPJCK_VIEW;
      $path .= strtolower( $filename ) . '.php';
      if ( file_exists( $path )) {
        include( $path );
      }
    }

    //}}
    //{{ _getModals

    /**
     * Get modals page
     *
     * @return array
     */
    protected function _getModals()
    {
      $args = array(
        'orderby'        => 'post_title',
        'order'          => 'ASC',
        'post_type'      => 'ipjck_modal',
        'post_status'    => array('publish'),
        'posts_per_page' => -1,
        'paged'          => 1
      );
      $query  = new WP_Query;
      $modals = $query->query( $args );
      return $modals;
    }

    //}}
    //{{ _getBars

    /**
     * Get bars page
     *
     * @return array
     */
    protected function _getBars()
    {
      $args = array(
        'orderby'        => 'post_title',
        'order'          => 'ASC',
        'post_type'      => 'ipjck_bar',
        'post_status'    => array('publish'),
        'posts_per_page' => -1,
        'paged'          => 1
      );
      $query = new WP_Query;
      $bars  = $query->query( $args );
      return $bars;
    }

    //}}
    //{{ _getSlides

    /**
     * Get slides page
     *
     * @return array
     */
    protected function _getSlides()
    {
      $args = array(
        'orderby'        => 'post_title',
        'order'          => 'ASC',
        'post_type'      => 'ipjck_slide',
        'post_status'    => array('publish'),
        'posts_per_page' => -1,
        'paged'          => 1
      );
      $query  = new WP_Query;
      $slides = $query->query( $args );
      return $slides;
    }

    //}}
  }
}
