<?php
/**
 * Class model modal popup
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPJck_Model_Widget_Modal' )) {

  /**
   * Class model modal popup
   */
  class IPJck_Model_Widget_Modal extends IPJck_Model_Widget
  {
    /**
     * Take type widget
     *
     * @var string
     */
    protected $_type = 'modal';

    /**
     * Save general design settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingDesignGeneral( $data )
    {
      $settings = parent::_saveSettingDesignGeneral( $data );

      if ( isset( $data['modal_size'] )) {
        $settings['modal_size'] = apply_filters( 'pre_term_name', $data['modal_size'] );
      }
      if ( isset( $data['modal_width'] )) {
        $settings['modal_width'] = absint( $data['modal_width'] );
      }
      if ( isset( $data['modal_height'] )) {
        $settings['modal_height'] = absint( $data['modal_height'] );
      }

      return $settings;
    }

    /**
     * Save background design settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingDesignBackground( $data )
    {
      $settings = parent::_saveSettingDesignBackground( $data );

      if ( isset( $data['background_overlay_color'] )) {
        $settings['background_overlay_color'] = 
          apply_filters( 'pre_term_name', $data['background_overlay_color'] );
      }
      if ( isset( $data['background_overlay_opacity'] )) {
        $settings['background_overlay_opacity'] = 
          absint( $data['background_overlay_opacity'] );
      }

      return $settings;
    }


  }
}