<?php
/**
 * Class for create list info bar
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPJck_List_Page' ))
{
  class IPJck_List_Page extends IPJck_List
  {
    //{{ _getData

    /**
     * Get data
     *
     * @return void
     */
    protected function _getData()
    {
      $page     = $this->_page;
      $per_page = $this->_perPage;
      $args = array(
          'orderby'        => 'post_date',
          'order'          => 'DESC',
          'post_type'      => 'ipjck_page',
          'post_status'    => array('publish','draft'),
          'posts_per_page' => $per_page,
          'paged'          => $page
      );
      $query = new WP_Query;
      $this->_result = $query->query( $args );
      $this->_query  = $query;
      $this->_total  = $query->found_posts;
      $this->_total_page = $this->_getTotalPage();
      return $this->_result;
    }

    //}}
    //{{ _getItemAction

    /**
     * Get item action
     *
     * @param  object $item
     * @param  int    $index
     * @return string
     */
    protected function _getItemAction( $item, $index )
    {
      $itemId  = $this->_getListItemId( $item );
      $result  =
        '<div class="col-sm-6">' .
          '<div class="ipjck-item-action ipjck-clear text-right">' .
            $this->_getItemStat( $item, $index ) .

            '<div class="ipjck-item-nav ipjck-fademenu">' .
              '<div class="ipjck-fademenu-inner">' .
                '<div class="ipjck-nav-label ipjck-fademenu-button">' .
                  '<a class="ipjck-menu-link" href="#"><i class="ipjck-fa ipjck-fa-bars"></i></a>' .
                '</div>' .
                '<ul class="ipjck-submenu ipjck-fademenu-content">' .
                  '<li>' .
                    '<a href="' . $this->_getLinkEdit( $item ) . '" class="ipjck-btn ipjck-btn-xs ipjck-btn-success">' .
                      '<i class="ipjck-fa ipjck-fa-pencil"></i>' .
                       __( 'Edit Page', IPJCK_SLUG ) .
                    '</a>' .
                  '</li>' .
                  '<li>' .
                    '<a href="' . $this->_getLinkView( $item ) . '" class="ipjck-btn ipjck-btn-xs ipjck-btn-primary">' .
                      '<i class="ipjck-fa ipjck-fa-eye"></i>' .
                       __( 'View Page', IPJCK_SLUG ) .
                    '</a>' .
                  '</li>' .
                  '<li>' .
                    '<a href="#" class="ipjck-btn ipjck-btn-xs ipjck-btn-danger ipjck-item-page-delete" data-id="' . $itemId . '">' .
                      '<i class="ipjck-fa ipjck-fa-trash"></i>' .
                      __( 'Delete Page', IPJCK_SLUG ) .
                    '</a>' .
                  '</li>' .
                '</ul>' .
              '</div>' .
            '</div>' .
          '</div>' .
        '</div>';
      return $result;
    }

    //}}
    //{{ _getLinkEdit

    /**
     * Get link edit
     *
     * @param  object $item
     * @return string
     */
    protected function _getLinkEdit( $item )
    {
      $link = admin_url() . 'admin.php?page=' . IPJCK_PAGENAME . '-page&action=edit&id=' . $item->ID;
      return $link;
    }

    //}}
    //{{ _getLinkView

    /**
     * Get link edit
     *
     * @param  object $item
     * @return string
     */
    protected function _getLinkView( $item )
    {
      $home = get_home_url();
      $path = get_option( '__ipjck_base_path', 'detail' );
      $root = $home . '/' . $path . '/';
      $link = $root . $item->post_name;
      return $link;
    }

    //}}
    //{{ _getPaginationLink

    /**
     * Get pagination link
     *
     * @param  int $page
     * @return string
     */
    protected function _getPaginationLink( $page )
    {
      $link = admin_url() . 'admin.php?page=' . IPJCK_PAGENAME . '-page&paged=' . $page;
      return $link;
    }

    //}}
  }

}
