<?php
/**
 * Class for create list main popup
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPJck_List_Main' )) 
{
  class IPJck_List_Main extends IPJck_List
  {
    //{{ __construct

    /**
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
      $page = 1;
      if ( ! empty( $_GET['list'] ) && $_GET['list'] == 'widget' && ! empty( $_GET['paged'] )) {
        $page = absint( $_GET['paged'] );
      }
      $this->_page     = $page;
      $this->_perPage = 12;
    }

    //}}
    //{{ _getData

    /**
     * Get data
     *
     * @return void
     */
    protected function _getData()
    {
      $page     = $this->_page;
      $per_page = $this->_perPage;
      $args = array(
          'orderby'        => 'post_date',
          'order'          => 'DESC',
          'post_type'      => array(
            'ipjck_modal',
            'ipjck_bar',
            'ipjck_slide'
          ),
          'post_status'    => array('publish'),
          'posts_per_page' => $per_page,
          'paged'          => $page
      );
      $query = new WP_Query;
      $this->_result = $query->query( $args );
      $this->_query  = $query;
      $this->_total  = $query->found_posts;
      $this->_total_page = $this->_getTotalPage();
      return $this->_result;
    }

    //}}
    //{{ _getList

    /**
     * Get list
     *
     * @return string
     */
    protected function _getList()
    {
      $list  = '<table class="ipjck-table-default">' .
                  '<thead>' .
                    '<tr>' .
                      '<th>' . __( 'ID', IPJCK_SLUG ) . '</th>' .
                      '<th>' . __( 'Title', IPJCK_SLUG ) . '</th>' .
                      '<th>' . __( 'Type', IPJCK_SLUG ) . '</th>' .
                      '<th>' . __( 'Views', IPJCK_SLUG ) . '</th>' .
                      '<th>' . __( 'Clicks', IPJCK_SLUG ) . '</th>' .
                      '<th>' . __( 'Submits', IPJCK_SLUG ) . '</th>' .
                      '<th>' . __( 'Conversion Rate', IPJCK_SLUG ) . '</th>' .
                      '<th></th>' .
                    '</tr>' .
                  '</thead>';

      if ( empty( $this->_result )) {
        $list .= $this->_getEmptyList();
      }
      else
      {
        $list .= '<tbody>';

        $index = 1;
        foreach( $this->_result as $item ) 
        {
          $list .= $this->_getListItem( $item, $index );
          $index++;
        }

        $list .= '</tbody>';
      }
      $list .= '</table>';
      return $list;
    }

    //}}
    //{{ _getEmptyList

    /**
     * Get empty list
     *
     * @return string
     */
    protected function _getEmptyList()
    {
      return '<tr class="ipjck-table-empty">' .
                '<td colspan="5"><em>' . __( 'Data not available', IPJCK_SLUG ) . '</em></td>' .
              '</td>';
    }

    //}}
    //{{ _getListItem

    /**
     * Get list item
     *
     * @param  object $item
     * @param  int    $index
     * @return string
     */
    protected function _getListItem( $item, $index )
    {
      $itemId  = $this->_getListItemId( $item );
      $result  = '<tr id="ipjck-item-' . $itemId . '" class="ipjck-list-item">';
      $result .= $this->_getItemMain  ( $item, $index );
      $result .= '</tr>';
      return $result;
    }

    //}}
    //{{ _getItemMain

    /**
     * Get item main
     *
     * @param  object $item
     * @param  int    $index
     * @return string
     */
    protected function _getItemMain( $item, $index )
    {
      $date   = mysql2date( 'F d Y, h:i', $this->_getListItemDate( $item ) );

      $link   = $this->_getLinkEdit( $item );
      $label  = $this->_getItemMainLabel( $item, $index );
      $type   = 'Widget';
      if ( $item->post_type == 'ipjck_modal' ) {
        $type = 'Modal Popup';
      }
      elseif ( $item->post_type == 'ipjck_bar' ) {
        $type = 'Bar Info';
      }
      elseif ( $item->post_type == 'ipjck_slide' ) {
        $type = 'Slide In';
      }

      $model = new IPJck_Model_WidgetStat();
      $stats = $model->getStatByWidget( $item->ID );

      $clicks = $views = $submits = $rate = 0;

      if ( ! empty( $stats ))
      {
        $views   = $stats->stat_view;
        $clicks  = $stats->stat_click;
        $submits = $stats->stat_subscribe;
        if ( ! empty( $stats->stat_view ) && ! empty( $stats->stat_click )) {
          $rate = $stats->stat_click/$stats->stat_view;
          $rate = number_format( $rate, 2, '.', '' );
        }
      }

      $result  = '<td>' . $item->ID . '</td>';
      $result .= '<td><a href="' . $link . '">' . $item->post_title . '</a></td>';
      $result .= '<td>' . $type . '</td>';
      $result .= '<td>' . $views . '</td>';
      $result .= '<td>' . $clicks . '</td>';
      $result .= '<td>' . $submits . '</td>';
      $result .= '<td>' . $rate . '</td>';

      return $result;
    }

    //}}
    //{{ _getLinkEdit

    /**
     * Get link edit
     *
     * @param  object $item
     * @return string
     */
    protected function _getLinkEdit( $item )
    {
      $page = IPJCK_PAGENAME;
      if ( $item->post_type == 'ipjck_modal' ) {
        $page .= '-modal';
      }
      elseif ( $item->post_type == 'ipjck_bar' ) {
        $page .= '-bar';
      }
      elseif ( $item->post_type == 'ipjck_slide' ) {
        $page .= '-slide';
      }
      $link = admin_url() . 'admin.php?page=' . $page . '&action=edit&id=' . $item->ID;
      return $link;
    }

    //}}
    //{{ _getPaginationLink

    /**
     * Get pagination link
     *
     * @param  int $page
     * @return string
     */
    protected function _getPaginationLink( $page )
    {
      $link = admin_url() . 'admin.php?page=' . IPJCK_PAGENAME . '&list=widget&paged=' . $page;
      return $link;
    }

    //}}
  }

}