<?php
if ( ! class_exists( 'IPJck_Factory' ))
{
  /**
   * Widget factory class
   *
   * @package wp-viral-click
   * @author InstaProduct
   * @link http://insta-product.com/
   */

  class IPJck_Factory extends IPJck_Viewer
  {
    //{{ __construct

    /**
     * Class constructor
     *
     * @return void
     */
    public function __construct()
    {
    }

    //}}
    //{{ render

    /**
     * Render page
     *
     * @return string
     */
    public function render()
    {
      global $wp_query, $user_ID;
      if ( ( isset( $wp_query->query['ipjck'] ) && isset( $wp_query->query['detail_name'] ) ) ||
           isset( $wp_query->query['detail_id'] ) )
      {
        $page = $wp_query->post;

        if ( $page->post_status == 'publish' )
        {
          $setting = new IPJck_Setting( $page->ID, '__ipjck-page-setting' );
          //
          //Check restricted
          if ( empty( $user_ID ) && $setting->getSetting( 'restricted', 'true' ) == 'true' )
          {
            $redirect  = $this->pageurl;
            $login_url = wp_login_url( $redirect );
            wp_redirect( $login_url );
            exit;
          }

          $this->query     = $wp_query;
          $this->setting   = $setting;
          $this->page      = $page;
          $this->cssurl    = IPJCK_BASE_URL . 'assets/css/';
          $this->jsurl     = IPJCK_BASE_URL . 'assets/js/';
          $this->imgurl    = IPJCK_BASE_URL . 'assets/img/';
          $this->permalink = $this->_getPermalink( $page );
          $this->pageTitle = $this->_getPageTitle( $page );

          //Get widgets
          $bar = $modal = $slide = false;

          if ( $barId = $setting->getSetting( 'page_bar' ) ) {
            $bar = get_post( $barId );
          }
          if ( $modalId = $setting->getSetting( 'page_modal' ) ) {
            $modal = get_post( $modalId );
          }
          if ( $slideId = $setting->getSetting( 'page_slidein' ) ) {
            $slide = get_post( $slideId );
          }
          $this->bar          = $bar;
          $this->barSetting   = new IPJck_Setting( $barId, '__ipjck-widget-setting' );
          $this->modal        = $modal;
          $this->modalSetting = new IPJck_Setting( $modalId, '__ipjck-widget-setting' );
          $this->slide        = $slide;
          $this->slideSetting = new IPJck_Setting( $slideId, '__ipjck-widget-setting' );

          //Save stat
          $this->_saveStat();

          //Render view
          $this->view( 'front/page/main' );
          exit;
        }
        else
        {
          $query->query_vars['post_type'] = 'ipjck-item-nothing';
        }
      }
    }

    //}}
    //{{ previewWidget

    /**
     * Bar preview viewer
     *
     * @param  array $widget
     * @return void
     */
    public function previewWidget( $widget )
    {
      $output = '';
      if ( $widget )
      {
        $this->widget    = $widget;
        $this->isPreview = true;
        $this->setting   = new IPScri_Setting( $widget->ID, '__ipjck-widget-setting' );
        $this->widgetId   = $widget->ID;

        $type = '';
        if ( $widget->post_type == 'ipjck_modal' ) {
          $type = 'modal';
        }
        elseif ( $widget->post_type == 'ipjck_bar' ) {
          $type = 'bar';
        }
        elseif ( $widget->post_type == 'ipjck_slide' ) {
          $type = 'slide';
        }
        $this->widgetType = $type;
        
        //Render view
        ob_start();
        $this->view( 'front/widget' );
        $output = ob_get_contents();
        ob_end_clean();
      }
      echo $output;
    }

    //}}
    //{{ _saveStat

    /**
     * Save stat
     *
     * @return void
     */
    protected function _saveStat()
    {
      $model = new IPJck_Model_PageStat();
      $model->saveStat( $this->page, 'view' );
    }

    //}}
    //{{ _getPermalink

    /**
     * Get page permalink
     *
     * @param object $page
     * @return void
     */
    protected function _getPermalink( $page )
    {
      if ( get_option( 'permalink_structure' ) )  {
        $base = get_option( '__ipjck_base_path', 'detail' );
        $link = get_home_url() . "/$base/" . $page->post_name;
      } else {
        $link = get_home_url() . '/?detail_id=' . $page->ID;
      }
      return $link;
    }

    //}}
    //{{ _getPageTitle

    /**
     * Get page title
     *
     * @param object $page
     * @return void
     */
    protected function _getPageTitle( $page )
    {
      $title = $this->setting->getSetting( 'seo_meta_title' );
      $title = trim( $title );
      if ( empty( $title )) {
          $title = $this->page->post_title;
      }
      $title = stripslashes( $title );
      return $title;
    }

    //}}
    //{{ getShareLink

    /**
     * Get share link
     *
     * @param  string $type
     * @param  object $post
     * @return string
     */
    public function getShareLink( $type, $post )
    {
      $pagetitle = urlencode( $post->post_title );
      $pageurl   = urlencode( get_post_permalink( $post ) );
      $actions   =  array(
        'facebook'      => 'http://www.facebook.com/share.php?u=' . $pageurl,
        'twitter'       => 'https://twitter.com/share?url=' . $pageurl . '&text=' . $pagetitle,
        'googleplus'    => 'https://plusone.google.com/_/+1/confirm?hl=en&url=' . $pageurl,
        'pinterest'     => 'http://pinterest.com/pin/create/button/?url=' . $pageurl . '&media=&description=' . $pagetitle,
        'linkedin'      => 'http://www.linkedin.com/shareArticle?mini=true&url=' . $pageurl .'&title=' . $pagetitle,
        'tumblr'        => 'http://www.tumblr.com/share?v=3&u=' . $pageurl,
        'stumbleupon'   => 'http://www.stumbleupon.com/submit?url=' . $pageurl . '&title=' . $pagetitle,
        'digg'          => 'http://digg.com/submit?url=' . $pageurl . '&title=' . $pagetitle,
        'email'         => 'mailto:?subject=' . $pagetitle
      );
      $link = '#';
      if ( array_key_exists( $type, $actions )) {
        $link = $actions[$type];
      }
      return $link;
    }

    //}}
  }
}
