<?php
/**
 * Controller to handling save setting
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPJck_Ajax_Setting' ))
{
  class IPJck_Ajax_Setting
  {
    /**
     * Execution save setting
     *
     * @return void
     */
    public function exec()
    {
      $error = false;

      if ( isset( $_POST['general_type'] )) {
        $type = apply_filters( 'pre_term_name', $_POST['general_type'] );
        update_option( '__ipjck_general_type', $type );
      }
      if ( isset( $_POST['general_modal'] )) {
        $widgetId = absint( $_POST['general_modal'] );
        update_option( '__ipjck_general_modal', $widgetId );
      }
      if ( isset( $_POST['general_bar'] )) {
        $widgetId = absint( $_POST['general_bar'] );
        update_option( '__ipjck_general_bar', $widgetId );
      }
      if ( isset( $_POST['general_slide'] )) {
        $widgetId = absint( $_POST['general_slide'] );
        update_option( '__ipjck_general_slide', $widgetId );
      }

      if ( isset( $_POST['home_type'] )) {
        $type = apply_filters( 'pre_term_name', $_POST['home_type'] );
        update_option( '__ipjck_home_type', $type );
      }
      if ( isset( $_POST['home_modal'] )) {
        $widgetId = absint( $_POST['home_modal'] );
        update_option( '__ipjck_home_modal', $widgetId );
      }
      if ( isset( $_POST['home_bar'] )) {
        $widgetId = absint( $_POST['home_bar'] );
        update_option( '__ipjck_home_bar', $widgetId );
      }
      if ( isset( $_POST['home_slide'] )) {
        $widgetId = absint( $_POST['home_slide'] );
        update_option( '__ipjck_home_slide', $widgetId );
      }

      if ( $error ) {
          $status = 0;
          $msg    = __( 'Failed save settings.', IPJCK_SLUG );
      } else {
          $status = 1;
          $msg    = __( 'Successfully updated settings.', IPJCK_SLUG );
      }
      echo json_encode( array(
          'status'    => $status,
          'message'   => $msg
      ) );
      die();
    }
  }
}
