<?php
/**
 * Controller to handling saving statistic data
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPJck_Ajax_Savestatpage' ))
{
  class IPJck_Ajax_Savestatpage
  {
    /**
     * Execution save options process
     *
     * @return void
     */
    public function exec()
    {
      $error = true;
      if ( ! empty( $_POST['page_id'] ) && ! empty( $_POST['type'] ))
      {
        $pageId  = absint( $_POST['page_id'] );
        if ( $page = get_post( $pageId ))
        {
          $type  = apply_filters( 'pre_term_name', $_POST['type'] );
          $model = new IPJck_Model_PageStat();
          $model->saveStat( $page, $type );

          $error = false;
        }
      }
      if ( $error ) {
        $status = 0;
        $msg    = __( 'Failed to save statistic data.', IPJCK_SLUG );
      } else {
        $status = 1;
        $msg    = __( 'Successfully to save statistic data.', IPJCK_SLUG );
      }
      echo json_encode( array(
        'status'    => $status,
        'message'   => $msg
      ) );
      die();
    }
  }
}
