<?php
/**
 * Controller to handling get slug
 *
 * @package wp-surveyer
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPJck_Ajax_Getslug' ))
{
  class IPJck_Ajax_Getslug
  {
    /**
     * Execution get slug process
     *
     * @return void
     */
    public function exec()
    {
      $data   = array_merge( $_POST, $_GET );
      $postId = 0;
      if ( ! empty( $data['pageid'] )) {
        $postId = absint( $data['pageid'] );
      }
      if ( ! empty( $data['title'] )) {
        $slug = sanitize_title( $data['title'] );
        $slug = wp_unique_post_slug( $slug, $postId, 1, 'ipjck_page', 0 );
        echo json_encode( array(
          'status' => 1,
          'slug'   => $slug
        ) );
      } else {
        echo json_encode( array(
          'status' => 0
        ) );
      }
      die();
    }
  }
}
