<?php
/**
 * Main application class
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

//
//Model
require_once( IPJCK_APP . '/models/widgetStat.php' );
require_once( IPJCK_APP . '/models/pageStat.php' );
require_once( IPJCK_APP . '/models/widget.php' );
require_once( IPJCK_APP . '/models/widget/modal.php' );
require_once( IPJCK_APP . '/models/widget/bar.php' );
require_once( IPJCK_APP . '/models/widget/slide.php' );
require_once( IPJCK_APP . '/models/page.php' );

//
//Include all function files
require_once( IPJCK_LIB . '/config.php' );
require_once( IPJCK_LIB . '/setting.php' );
require_once( IPJCK_LIB . '/db.php' );
require_once( IPJCK_LIB . '/list.php' );
require_once( IPJCK_LIB . '/font.php' );
require_once( IPJCK_LIB . '/form.php' );
require_once( IPJCK_LIB . '/faicon.php' );
require_once( IPJCK_LIB . '/effect.php' );
require_once( IPJCK_APP . '/controller.php' );
require_once( IPJCK_APP . '/viewer.php' );
require_once( IPJCK_LIB . '/factory.php' );
//Color library
if ( ! class_exists( 'phpColor' )) {
	require_once( IPJCK_LIB . '/Color.php' );
}
//Simple htmlm dom library
if ( ! function_exists( 'str_get_html' )) {
	require_once( IPJCK_LIB . '/simplehtmldom/simple_html_dom.php' );
}

if ( ! class_exists( 'IPJck_App' ))
{
	class IPJck_App
	{
		//{{ run

		/**
		 * Run all functions
		 *
		 * @return void
		 */
		public static function run()
		{
			$hook = sanitize_title( IPJCK_TITLE );

			//Install Plugin
			register_activation_hook( __FILE__, array( __CLASS__, 'install' ) );

			//Hook for plugin loaded
			add_action( 'plugins_loaded', array( __CLASS__, 'updateDb' ) );

			//
			//Admin init
			add_action( 'admin_init', array( __CLASS__, 'adminInit' ) );

			//
			//Register admin menu
			add_action( 'admin_menu', array( __CLASS__, 'addAdminMenu' ) );

			//
      //Rewrite Handler
      //
      add_action( 'init', array( __CLASS__, 'rewriteFlush' ) );
      add_action( 'pre_get_posts', array( __CLASS__, 'init' ) );

      //Render page
      add_action( 'template_redirect', array( __CLASS__, 'factoryPage' ) );
			
			//
			//Add css
			add_action(
				'admin_print_styles-toplevel_page_' . IPJCK_PAGENAME,
				array( __CLASS__, 'adminStyle' ),
				1100
			);
			add_action(
				'admin_print_styles-'.$hook.'_page_' . IPJCK_PAGENAME . '-page',
				array( __CLASS__, 'adminStyle' ),
				1100
			);
			add_action(
				'admin_print_styles-'.$hook.'_page_' . IPJCK_PAGENAME . '-modal',
				array( __CLASS__, 'adminStyle' ),
				1100
			);
			add_action(
				'admin_print_styles-'.$hook.'_page_' . IPJCK_PAGENAME . '-bar',
				array( __CLASS__, 'adminStyle' ),
				1100
			);
			add_action(
				'admin_print_styles-'.$hook.'_page_' . IPJCK_PAGENAME . '-slide',
				array( __CLASS__, 'adminStyle' ),
				1100
			);
			add_action(
				'admin_print_styles',
				array( __CLASS__, 'adminGlobalStyle' ),
				1000
			);

			//
			//Add javascript
			add_action(
				'admin_print_scripts-toplevel_page_' . IPJCK_PAGENAME,
				array( __CLASS__, 'adminScript' ),
				1100
			);
			add_action(
				'admin_print_scripts-'.$hook.'_page_'.IPJCK_PAGENAME. '-page',
				array( __CLASS__, 'adminScript' ),
				1100
			);
			add_action(
				'admin_print_scripts-'.$hook.'_page_'.IPJCK_PAGENAME. '-modal',
				array( __CLASS__, 'adminScript' ),
				1100
			);
			add_action(
				'admin_print_scripts-'.$hook.'_page_'.IPJCK_PAGENAME. '-bar',
				array( __CLASS__, 'adminScript' ),
				1100
			);
			add_action(
				'admin_print_scripts-'.$hook.'_page_'.IPJCK_PAGENAME. '-slide',
				array( __CLASS__, 'adminScript' ),
				1100
			);
			add_action(
				'admin_print_scripts',
				array( __CLASS__, 'adminGlobalScript' ),
				1000
			);

			//
      //Front style & script
      //add_action('wp_head', array( __CLASS__, 'publicStyle' ) );
			/*
      if ( ! is_admin() ) {
        add_action('wp_enqueue_scripts', array( __CLASS__, 'publicScript' ), 10 );
      }*/
		}

		//}}
		//{{ install

		/**
		 * Install plugin
		 *
		 * @return void
		 */
		public static function install()
		{
			//Install DB
			$db = new IPJck_Db();
			$db->install();
		}

		//}}
		//{{ updateDb

		/**
		 * Update Db
		 *
		 * @return void
		 */
		public static function updateDb()
		{
			$db = new IPJck_Db();
			$db->update();
		}

		//}}
		//{{ adminInit

		/**
		 * Admin init
		 *
		 * @return void
		 */
		public static function adminInit()
		{
			/**
			 * Ajax handler
			 **/
			$controller = new IPJck_Controller();
			$controller->ajax();
		}

		//}}
		//{{ addAdminMenu

		/**
		 * Add admin menu
		 *
		 * @return void
		 */
		public static function addAdminMenu()
		{
			add_menu_page(
				IPJCK_TITLE,
				IPJCK_TITLE,
				'edit_posts',
				IPJCK_PAGENAME,
				array( __CLASS__, 'dashboard' ),
				'dashicons-welcome-widgets-menus'
			);
			add_submenu_page(
				IPJCK_PAGENAME,
				__( 'Dashboard', IPJCK_SLUG ),
				__( 'Dashboard', IPJCK_SLUG ),
				'edit_posts',
				IPJCK_PAGENAME,
				array( __CLASS__, 'dashboard' )
			);
			add_submenu_page(
				IPJCK_PAGENAME,
				__( 'Page', IPJCK_SLUG ),
				__( 'Page', IPJCK_SLUG ),
				'edit_posts',
				IPJCK_PAGENAME . '-page',
				array( __CLASS__, 'page' )
			);
			add_submenu_page(
				IPJCK_PAGENAME,
				__( 'Modal Popup', IPJCK_SLUG ),
				__( 'Modal Popup', IPJCK_SLUG ),
				'edit_posts',
				IPJCK_PAGENAME . '-modal',
				array( __CLASS__, 'modal' )
			);
			add_submenu_page(
				IPJCK_PAGENAME,
				__( 'Info Bar', IPJCK_SLUG ),
				__( 'Info Bar', IPJCK_SLUG ),
				'edit_posts',
				IPJCK_PAGENAME . '-bar',
				array( __CLASS__, 'bar' )
			);
			add_submenu_page(
				IPJCK_PAGENAME,
				__( 'Slide In', IPJCK_SLUG ),
				__( 'Slide In', IPJCK_SLUG ),
				'edit_posts',
				IPJCK_PAGENAME . '-slide',
				array( __CLASS__, 'slide' )
			);
		}

		//}}
		//{{ dashboard

		/**
		 * All widgets page
		 *
		 * @return void
		 */
		public static function dashboard()
		{
			$viewer = new IPJck_Viewer();
			$viewer->dashboard();
		}

		//}}
		//{{ page

		/**
		 * All page
		 *
		 * @return void
		 */
		public static function page()
		{
			$viewer = new IPJck_Viewer();
			$viewer->page();
		}

		//}}
		//{{ modal

		/**
		 * Modal popup management
		 *
		 * @return void
		 */
		public static function modal()
		{
			$viewer = new IPJck_Viewer();
			$viewer->modal();
		}

		//}}
		//{{ bar

		/**
		 * Bar info management
		 *
		 * @return void
		 */
		public static function bar()
		{
			$viewer = new IPJck_Viewer();
			$viewer->bar();
		}

		//}}
		//{{ slide

		/**
		 * Slide in management
		 *
		 * @return void
		 */
		public static function slide()
		{
			$viewer = new IPJck_Viewer();
			$viewer->slide();
		}

    //}}
    //{{ init

    /**
     * Init request
     *
     * @return void
     */
    public static function init( $query )
    {
      $q = $query->query;
      if ( isset( $q['ipjck'] ) && isset( $q['detail_name'] )) {
        $query->query_vars['post_type'] = 'ipjck_page';
        $query->query_vars['name']      = $q['detail_name'];
        $query->query_vars['pagename']  = $q['detail_name'];
        $query->query['pagename']       = $q['detail_name'];

      } elseif( isset( $q['detail_id'] )) {
        $query->query_vars['post_type'] = 'ipjck_page';
        $query->query_vars['p']         = absint( $q['detail_id'] );
      }
    }

    //}}
    //{{ rewriteInit

    /**
     * Init rewrite rule
     *
     * @return void
     */
    public static function rewriteInit()
    {
      $base = get_option( '__ipjck_base_path', 'detail' );
      add_rewrite_rule(
       $base . '/([^/]+)/?$',
       'index.php?ipjck=1&detail_name=$matches[1]',
       'top'
      );
      add_rewrite_rule(
       $base . '/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$',
       'index.php?ipjck=1&detail_name=$matches[1]&feed=$matches[2]',
       'top'
      );
      add_rewrite_rule(
        $base . '/([^/]+)/(feed|rdf|rss|rss2|atom)/?$',
        'index.php?ipjck=1&detail_name=$matches[1]&feed=$matches[2]',
        'top'
      );
      add_rewrite_rule(
        $base . '/([^/]+)/page/?([0-9]{1,})/?$',
        'index.php?ipjck=1&detail_name=$matches[1]&paged=$matches[2]',
        'top'
      );
      add_rewrite_tag( '%detail_name%', '([a-zA-Z0-9\_])');
      add_rewrite_tag( '%detail_id%', '([0-9])');
      add_rewrite_tag( '%ipjck%', '([1])');
    }

    //}}
    //{{ rewriteFlush

    /**
     * Flush rewrite rule
     *
     * @return void
     */
    public static function rewriteFlush()
    {
      $base = get_option( '__ipjck_base_path', 'detail' );
      $old  = get_option( '__ipjck_base_path_old', 'detail' );

      self::rewriteInit();

      if ( $base != $old ) {
         flush_rewrite_rules();
         update_option( '__ipjck_base_path_old', $base );
      }
    }

    //}}
    //{{ factoryPage

    /**
     * Render promo page
     *
     * @return void
     */
    public static function factoryPage()
    {
      //Factory
      $factory = new IPJck_Factory();
      $factory->render();
    }

		//}}
		//{{ adminStyle

		/**
		 * Add Css file
		 *
		 * @return void
		 */
		public static function adminStyle()
		{
			wp_deregister_style( 'ipjck-admin-style' );
			wp_register_style(
				'ipjck-admin-style',
				IPJCK_BASE_URL . 'assets/css/admin.min.css',
				false,
				null
			);
			wp_enqueue_style('ipjck-admin-style');
		}

		//}}
		//{{ adminGlobalStyle

		/**
		 * Add Css file to all pages
		 *
		 * @return void
		 */
		public static function adminGlobalStyle()
		{
			wp_deregister_style( 'ipjck-admin-global-style' );
			wp_register_style(
				'ipjck-admin-global-style',
				IPJCK_BASE_URL . 'assets/css/admin-global.min.css',
				false,
				null
			);
			wp_enqueue_style('ipjck-admin-global-style');
		}

		//}}
		//{{ adminScript

		/**
		 * Add javascript file
		 *
		 * @return void
		 */
		public static function adminScript()
		{
		?>
			<script type="text/javascript">
				var ipjck_img_url = '<?php echo IPJCK_BASE_URL . 'assets/img/'; ?>',
					ui_base_image	= '<?php echo IPJCK_BASE_URL . 'assets/img/'; ?>',
					ui_message		 =
					{
						delete_confirm_title: '<?php _e( 'Delete Confirmation', IPJCK_SLUG ); ?>',
						delete_confirm_info: '<?php _e( 'Are you sure doing this action?', IPJCK_SLUG ); ?>'
					}
			</script>

			<?php
			wp_deregister_script('jquery-ui');
			wp_register_script(
				'jquery-ui',
				"http" . ($_SERVER['SERVER_PORT'] == 443 ? "s" : "") . "://ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/jquery-ui.min.js",
				false,
				null
			);
			wp_enqueue_script('jquery-ui');

      wp_deregister_script('ip-velocity-script');
      wp_enqueue_script(
        'ip-velocity-script',
        IPJCK_BASE_URL . 'assets/js/third_party/velocity.min.js',
        array(),
        1,
        true
      );

      wp_deregister_script('ip-velocity-ui-script');
      wp_enqueue_script(
        'ip-velocity-ui-script',
        IPJCK_BASE_URL . 'assets/js/third_party/velocity.ui.js',
        array(),
        1,
        true
      );

			wp_deregister_script('ipjck-admin-script');
			wp_enqueue_script(
				'ipjck-admin-script',
				IPJCK_BASE_URL . 'assets/js/admin.js',
				array( 'jquery' ),
				1,
				true
			);
		}

		//}}
		//{{ adminGlobalScript

		/**
		 * Add javascript file to all pages
		 *
		 * @return void
		 */
		public static function adminGlobalScript()
		{
			wp_deregister_script('ipjck-admin-global-script');
			wp_enqueue_script(
				'ipjck-admin-global-script',
				IPJCK_BASE_URL . 'assets/js/admin-global.min.js',
				array( 'jquery' ),
				1,
				true
			);
		}

    //}}
    //{{ publicStyle

    /**
     * Print public style
     *
     * @return void
     */
    public static function publicStyle()
    {
    ?>
      <script type="text/javascript">
        var ipjck_ajaxurl  = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
        var ipjck_img_url  = '<?php echo IPJCK_BASE_URL . 'assets/img/'; ?>';
      </script>
      <link media="all" type="text/css" href="<?php echo IPJCK_BASE_URL; ?>assets/css/public.min.css" rel="stylesheet">

    <?php
    }

    //}}
    //{{ publicScript

    /**
     * Print public script
     *
     * @return void
     */
    public static function publicScript()
    {
      wp_enqueue_script('jquery');

      wp_deregister_script('jquery-ui');
      wp_register_script('jquery-ui', "http" . ($_SERVER['SERVER_PORT'] == 443 ? "s" : "") . "://ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/jquery-ui.min.js", false, null);
      wp_enqueue_script('jquery-ui');

      wp_deregister_script('ip-velocity-script');
      wp_enqueue_script(
        'ip-velocity-script',
        IPJCK_BASE_URL . 'assets/js/third_party/velocity.min.js',
        array(),
        1,
        true
      );

      wp_deregister_script('ip-velocity-ui-script');
      wp_enqueue_script(
        'ip-velocity-ui-script',
        IPJCK_BASE_URL . 'assets/js/third_party/velocity.ui.js',
        array(),
        1,
        true
      );

      wp_deregister_script('ipjck-public-script');
      wp_enqueue_script(
        'ipjck-public-script',
        IPJCK_BASE_URL . 'assets/js/public.min.js',
        array( 'jquery' ),
        1,
        true
      );
    }
		//}}
	}
}
