<?php
/**
 * BG main style view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$st = $this->setting;
$classid  = '.ipjck-widget-' . $this->widget->ID;
$bgcolor  = $st->getSetting( 'box_background_color', '#f9f9f9' );
$padding  = $st->getSetting( 'box_padding', '15' );
$bocolor  = $st->getSetting( 'box_border_color', '#dddddd' );
$template = $st->getSetting( 'template', 1 );

//Get general text color
$phpcolor = new phpColor( $bgcolor );
if ( $phpcolor->isDark() ) {
	$color = $phpcolor->lighten( 60 );
} else {
	$color = $phpcolor->darken( 60 );
}

//Background Image
$imgurl = false;
if ( $bgimg = $st->getSetting( 'box_background_image' ))
{
  $data = wp_get_attachment_image_src( $bgimg, 'full' );
  if ( ! empty( $data[0] )) {
    $imgurl = $data[0];
  }
}
$repeat  = $st->getSetting( 'box_background_repeat', 'repeat' );
$opvalue = $st->getSetting( 'box_background_opacity', 0 );
?>
<style>
	<?php echo $classid; ?> .ipjck-widget-content {
		background-color: <?php echo $bgcolor; ?>;
	}
	<?php echo $classid; ?> .ipjck-header {
		padding-top: <?php echo $padding; ?>px;
		padding-left: <?php echo $padding; ?>px;
		padding-right: <?php echo $padding; ?>px;
	}
	<?php echo $classid; ?> .ipjck-title {
		padding-bottom: <?php echo $padding; ?>px;
	}
	<?php echo $classid; ?> .ipjck-content-primary {
		padding: <?php echo $padding; ?>px;
	}
	<?php echo $classid; ?> .ipjck-widget-main {
		color: #<?php echo $color; ?>;
		background-color: <?php echo $bgcolor; ?>;
	}

	<?php
	if ( $template == 2 ) {
		echo $classid . ' .ipjck-title {
			border-bottom-color: ' . $bocolor . '
		}';
	}
	?>

	<?php
	if ( $imgurl ) :
	?>
	<?php echo $classid; ?> .ipjck-widget-main-bg {
		background-image: url('<?php echo $imgurl; ?>');
		background-repeat: <?php echo $repeat; ?>;
		<?php
		if ( ! empty( $opvalue )) 
		{
			$opacity = 1 - ($opvalue/100);
			echo 'opacity:' . $opacity . ';';
		}
		?>
	}
	<?php
	else:
	?>
	<?php echo $classid; ?> .ipjck-widget-main-bg {
		display: none;
	}
	<?php
	endif;
	?>
</style>