<?php
/**
 * Page header view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$st = $this->setting;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title><?php echo $this->pageTitle; ?></title>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="description" content="<?php echo stripslashes( $st->getSetting( 'seo_meta_description', '' )); ?>">
    <meta name="keywords" content="<?php echo stripslashes( $st->getSetting( 'seo_meta_keywords', '' )); ?>">
    <meta property="og:title" content="<?php echo $this->pageTitle; ?>">
    <meta property="og:description" content="<?php echo stripslashes( $st->getSetting( 'seo_meta_description', '' )); ?>">
    <meta property="og:type" content="article">
    <meta property="og:image" content="<?php echo $st->getSetting( 'seo_graph_image', '' ); ?>">
    <meta property="og:url" content="<?php echo $this->permalink; ?>">

    <?php
    $assets = get_post_meta( $this->page->ID, '__ipjck-page-assets', true );
    if ( ! empty( $assets )) {
        echo $assets;
    }
    ?>

    <!-- Icon -->
    <?php
    if ( $iconurl = $st->getSetting( 'seo_favicon' ) ) :
    ?>
        <link rel="shortcut icon" href="<?php echo $iconurl; ?>" type="image/x-icon">
    <?php
    endif;
    ?>

    <!-- Css -->
    <link href="<?php //echo $this->getGoogleFont(); ?>" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="<?php echo $this->cssurl; ?>public.min.css" type="text/css" media="all" />

    <!-- JQuery -->
    <script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jqueryui/1.11.4/jquery-ui.min.js"></script>
    <script>
      var page_id        = '<?php echo $this->page->ID; ?>';
      var ipjck_ajaxurl  = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
      var ipjck_img_url  = '<?php echo IPJCK_BASE_URL . 'assets/img/'; ?>';
    </script>

</head>