<?php
/**
 * Box minimize button options
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting = $this->setting;
?>

<h4 class="ipjck-field-title mb0 py10">
	<?php _e( 'Minimize Button', IPJCK_SLUG ); ?>
</h4>

<?php
/*
 * Minimize Button
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-minimize-button"><?php _e( 'Show Minimize Button', IPJCK_SLUG ); ?></label>
	</div>

	<!-- start: .ipjck-field -->
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
		<div class="ipjck-onoff">
				<?php
				$val = stripslashes( $setting->getSetting( 'minimize_button', 'true' ) );
				if ( $val == 'false' ) {
						$clon  = '';
						$cloff = ' active';
				} else {
						$clon  = ' active';
						$cloff = '';
				}
				?>
				<div class="ipjck-btn-group">
					<button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'Show', IPJCK_SLUG ); ?></button>
					<button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Hide', IPJCK_SLUG ); ?></button>
				</div>
				<input type="hidden" class="ipjck-onoff-value" name="minimize_button" value="<?php echo $val; ?>" />
		</div>

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'Determines whether displaying minimize button.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
	<!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->

<?php
/*
 * Background Color
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-minimize-bgcolor"><?php _e( 'Background Color', IPJCK_SLUG ); ?></label>
	</div>

	<!-- start: .ipjck-field -->
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

		<?php
		$color = stripslashes( $setting->getSetting( 'minimize_bgcolor', '#444444' ) );
		?>
		<input type="text" class="ipjck-color-picker" id="input-minimize-bgcolor" name="minimize_bgcolor" value="<?php echo $color; ?>" />

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'Add background color for the minimize button.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
	<!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->

<?php
/*
 * Border
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-minimize-border-width"><?php _e( 'Border', IPJCK_SLUG ); ?></label>
	</div>

	<!-- start: .ipjck-field -->
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

		<?php
		$color   = stripslashes( $setting->getSetting( 'minimize_border_color', '#111111' ) );
		$bowidth = $setting->getSetting( 'minimize_border_width', 0 );
		?>
		<div class="ipjck-input-group mr5">
			<input type="text" id="input-minimize-border-width" class="ipjck-input ipjck-input-xxs" name="minimize_border_width" value="<?php echo $bowidth; ?>">
			<div class="ipjck-input-addon">px</div>
		</div>
		<input type="text" class="ipjck-color-picker" id="input-minimize-border-color" name="minimize_border_color" value="<?php echo $color; ?>" />

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'Add border for the minimize button.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
	<!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->

<?php
/*
 * Text Color
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-minimize-color"><?php _e( 'Color', IPJCK_SLUG ); ?></label>
	</div>

	<!-- start: .ipjck-field -->
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

		<?php
		$color = stripslashes( $setting->getSetting( 'minimize_color', '#ffffff' ) );
		?>
		<input type="text" class="ipjck-color-picker" id="input-minimize-color" name="minimize_color" value="<?php echo $color; ?>" />

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'Set color for the minimize button.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
	<!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->
