<?php
/**
 * Box close button options
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting = $this->setting;
?>

<h4 class="ipjck-field-title mb0 py10">
	<?php _e( 'Close Button', IPJCK_SLUG ); ?>
</h4>

<?php
/*
 * Close Button
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-close-button"><?php _e( 'Show Close Button', IPJCK_SLUG ); ?></label>
	</div>

	<!-- start: .ipjck-field -->
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
		<div class="ipjck-onoff">
				<?php
				$val = stripslashes( $setting->getSetting( 'close_button', 'true' ) );
				if ( $val == 'false' ) {
						$clon  = '';
						$cloff = ' active';
				} else {
						$clon  = ' active';
						$cloff = '';
				}
				?>
				<div class="ipjck-btn-group">
					<button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'Show', IPJCK_SLUG ); ?></button>
					<button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Hide', IPJCK_SLUG ); ?></button>
				</div>
				<input type="hidden" class="ipjck-onoff-value" name="close_button" value="<?php echo $val; ?>" />
		</div>

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'Determines whether displaying close button.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
	<!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->

<?php
/*
 * Background Color
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-close-bgcolor"><?php _e( 'Background Color', IPJCK_SLUG ); ?></label>
	</div>

	<!-- start: .ipjck-field -->
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

		<?php
		$color = stripslashes( $setting->getSetting( 'close_bgcolor', '#444444' ) );
		?>
		<input type="text" class="ipjck-color-picker" id="input-close-bgcolor" name="close_bgcolor" value="<?php echo $color; ?>" />

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'Add background color for the close button.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
	<!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->

<?php
/*
 * Border
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-close-border-width"><?php _e( 'Border', IPJCK_SLUG ); ?></label>
	</div>

	<!-- start: .ipjck-field -->
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

		<?php
		$color   = stripslashes( $setting->getSetting( 'close_border_color', '#111111' ) );
		$bowidth = $setting->getSetting( 'close_border_width', 0 );
		?>
		<div class="ipjck-input-group mr5">
			<input type="text" id="input-close-border-width" class="ipjck-input ipjck-input-xxs" name="close_border_width" value="<?php echo $bowidth; ?>">
			<div class="ipjck-input-addon">px</div>
		</div>
		<input type="text" class="ipjck-color-picker" id="input-close-border-color" name="close_border_color" value="<?php echo $color; ?>" />

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'Add border for the close button.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
	<!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->

<?php
/*
 * Text Color
 */
?>
<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
	<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
		<label for="input-close-color"><?php _e( 'Color', IPJCK_SLUG ); ?></label>
	</div>

	<!-- start: .ipjck-field -->
	<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

		<?php
		$color = stripslashes( $setting->getSetting( 'close_color', '#ffffff' ) );
		?>
		<input type="text" class="ipjck-color-picker" id="input-close-color" name="close_color" value="<?php echo $color; ?>" />

		<div class="ipjck-help">
			<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
			<div class="ipjck-help-content ipjck-hide">
				<?php _e( 'Set color for the close button.', IPJCK_SLUG ); ?>
			</div>
		</div>
	</div>
	<!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->
