<?php
/**
 * Admin content general view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( isset( $this->pageDescription )) {
  $desc = $this->pageDescription;
} else {
  $desc = __( 'Basic settings and info of your widget', IPJCK_SLUG );
}
?>
<div id="ipjck-section-general" class="ipjck-tab-content">
  <div class="ipjck-tab-inner">

    <div class="ipjck-title-content ipjck-hide">
      <i class="ipjck-fa ipjck-fa-cogs"></i>
      <div class="ipjck-title-text">
        <h3><?php _e( 'General', IPJCK_SLUG ); ?></h3>
        <p><?php echo $desc; ?></p>
      </div>
    </div>

    <!-- start: .ipjck-fields -->
    <div class="ipjck-fields">

      <?php
      /*
       * Name
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-widget-name"><?php _e( 'Name', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $name = '';
          if ( $this->widget ) {
            $name = stripslashes( $this->widget->post_title );
          }
          ?>
          <input type="text" id="input-widget-name" class="ipjck-input ipjck-input-full ipjck-input-v-lg" name="widget_name" value="<?php echo $name; ?>">

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide"><?php _e( 'The name of the widget. This data will not be used directly in creating widget, only to mark the video, so it easier for you to manage it.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Template
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-input-template ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-template"><?php _e( 'Template', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

          <div class="ipjck-input-template-<?php echo $this->widgetType; ?> ipjck-image-option">
            <ul class="_options ipjck-clear">
              <?php
              $root  = IPJCK_BASE_URL . 'assets/img/previews/template-';
              $root .= $this->widgetType . '-';

              if ( $this->widgetType == 'modal' ) {
                $options = range(1,7);
              } else {
                $options = range(1,6);
              }

              foreach( $options as $value )
              {
                $sltd = '';
                if ( $value == $this->template ) {
                  $sltd = ' _selected';
                }
                $src  = $root . $value . '.jpg';
                echo '<li><span class="_item' . $sltd . '" data-value="' . $value . '">';
                echo '<img src="' . $src . '" alt="' . $value . '">';
                echo '<span class="_selected-overlay"><i class="ipchm-fa ipchm-fa-check-circle"></i></span>';
                echo '</span>';
                echo '</li>';
              }
              ?>
              <input type="hidden" class="_value-selected" name="template" value="<?php echo $this->template; ?>">
            </ul>
          </div>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Set the template design of the widget.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Status
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-status"><?php _e( 'Status', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <div class="ipjck-onoff">
            <?php
            $val  = 'true';
            if ( $this->widget && $this->widget->post_status == 'draft' ) {
                $val = 'false';
            }
            if ( $val == 'false' ) {
                $clon  = '';
                $cloff = ' active';
            } else {
                $clon  = ' active';
                $cloff = '';
            }
            ?>
            <div class="ipjck-btn-group">
              <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'Show', IPJCK_SLUG ); ?></button>
              <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Hide', IPJCK_SLUG ); ?></button>
            </div>
            <input type="hidden" class="ipjck-onoff-value" name="status" value="<?php echo $val; ?>" />
          </div>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Determines the status of the widget, whether the widget will be viewable by the public or not.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Restricted user
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-restricted"><?php _e( 'Restricted', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <div class="ipjck-onoff">
              <?php
              $val = $this->setting->getSetting( 'restricted', 'false' );
              if ( $val == 'false' ) {
                  $clon  = '';
                  $cloff = ' active';
              } else {
                  $clon  = ' active';
                  $cloff = '';
              }
              ?>
              <div class="ipjck-btn-group">
                <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
                <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
              </div>
              <input type="hidden" class="ipjck-onoff-value" name="restricted" value="<?php echo $val; ?>" />
          </div>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Deciding whether to tighten the widget where only logged-in user can view the page.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

    </div>
    <!-- end: .ipjck-fields -->

  </div>
</div>
