<?php
/**
 * Manage box content view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipjck-section-content" class="ipjck-tab-content">
  <div class="ipjck-tab-inner">

    <div class="ipjck-title-content ipjck-hide">
      <i class="ipjck-fa ipjck-fa-file-text"></i>
      <div class="ipjck-title-text">
        <h3><?php _e( 'Content', IPJCK_SLUG ); ?></h3>
        <p><?php _e( 'Set the widget content', IPJCK_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipjck-fields -->
    <div class="ipjck-fields">

      <?php
      /*
       * Title
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-widget-title"><?php _e( 'Title', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $title = stripslashes( $this->setting->getSetting( 'widget_title' ) );
          ?>
          <input type="text" id="input-widget-title" class="ipjck-input ipjck-input-full" name="widget_title" value="<?php echo $title; ?>">

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide"><?php _e( 'The title of the widget.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * Info
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-widget-info"><?php _e( 'Main Info', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $info = stripslashes( $this->setting->getSetting( 'widget_info' ) );
          ?>
          <textarea id="input-widget-info" class="ipjck-input ipjck-input-full" name="widget_info" rows="6"><?php echo $info; ?></textarea>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide"><?php _e( 'The info of the widget.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      if ( ! isset( $this->hideFooterInfo )) :

	      /*
	       * Footer Info
	       */
	      ?>
	      <!-- start: .ipjck-field-row -->
	      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
	        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
	          <label for="input-widget-footer-info"><?php _e( 'Footer Info', IPJCK_SLUG ); ?></label>
	        </div>

	        <!-- start: .ipjck-field -->
	        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
	          <?php
	          $info = stripslashes( $this->setting->getSetting( 'widget_footer_info' ) );
	          ?>
	          <textarea id="input-widget-footer-info" class="ipjck-input ipjck-input-full" name="widget_footer_info" rows="6"><?php echo $info; ?></textarea>

	          <div class="ipjck-help">
	            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
	            <div class="ipjck-help-content ipjck-hide"><?php _e( 'The info of the widget footer.', IPJCK_SLUG ); ?>
	            </div>
	          </div>
	        </div>
	        <!-- end: .ipjck-field -->
	      </div>
	      <!-- end: .ipjck-field-row -->

      <?php
      endif;
      ?>

      <?php
      $dspMedia = '';
      if ( isset( $this->hideMedia ) && $this->hideMedia ) {
      	$dspMedia = ' style="display:none"';
      }
      ?>

      <div id="ipjck-field-media"<?php echo $dspMedia; ?>>

      <h4 class="ipjck-field-title mb0 py10">
        <?php _e( 'Media', IPJCK_SLUG ); ?>
      </h4>

      <?php
      /*
       * Media Type
       */
      $current = $this->setting->getSetting( 'media_type', 'none' );
      $border  = '';
      if ( $current == 'none' ) {
      	$border = ' style="border:none;"';
      }
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x"<?php echo $border; ?>>
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-media-type"><?php _e( 'Media Type', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

          <select name="media_type" id="ipjck-input-media-type">
            <?php
            $types = array(
							'none'   => __( 'None', IPJCK_SLUG ),
              'image'  => __( 'Image', IPJCK_SLUG ),
              'video'  => __( 'Video', IPJCK_SLUG )
            );
            foreach( $types as $key => $label )
            {
              $sltd = '';
              if ( $current == $key ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Media types will be added in the widget.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

			<?php
			$dspImage = $dspVideo = ' style="display:none;"';
			if ( $current == 'image' ) {
				$dspImage = '';
			} elseif ( $current == 'video' ) {
				$dspVideo = '';
			}
			?>
			<!-- start: .ipjck-fields-media-image  -->
			<div class="ipjck-fields-media-image"<?php echo $dspImage; ?>>

				<?php
	      /*
	       * Image
	       */
	      ?>
	      <!-- start: .ipjck-field-row -->
	      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
	        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
	          <label for="input-media-image"><?php _e( 'Image', IPJCK_SLUG ); ?></label>
	        </div>

	        <!-- start: .ipjck-field -->
	        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

	          <div class="ipjck-upload-image ipjck-clear">
							<div class="ipjck-upload-preview">
								<?php
								$setimg = false;
								if ( $attach_id = $this->setting->getSetting( 'media_image' ) ) {
									$setimg = true;
									$data   = wp_get_attachment_image_src( $attach_id, 'thumbnail' );
								}
								if ( $setimg ) {
									echo '<div class="image"><img src="' . $data[0] . '" /></div>';
									echo '<div class="none ipjck-hide">' . __( 'No image', IPJCK_SLUG ) . '</div>';
									$reset_dsp = '';
								} else {
									echo '<div class="image"></div>';
									echo '<div class="none">' . __( 'No image', IPJCK_SLUG ) . '</div>';
									$reset_dsp = ' style="display:none;"';
								}
								?>
							</div>

							<div class="ipjck-image-field">
								<div class="ipjck-select-image">
									<p class="mt0"><?php _e( 'Select an image or upload new image using the header below.', IPJCK_SLUG ); ?></p>
									<a class="ipjck-btn ipjck-btn-secondary ipjck-btn-media ipjck-btn-sm" data-choose="<?php esc_attr_e( 'Choose Image', IPJCK_SLUG ); ?>"
										data-update="<?php esc_attr_e( 'Choose image', IPJCK_SLUG ); ?>">
											<i class="ipjck-fa ipjck-fa-image"></i>
											<?php _e( 'Select Image', IPJCK_SLUG ); ?>
									</a>
									<a class="ipjck-btn ipjck-btn-reset ipjck-btn-sm" href="#"<?php echo $reset_dsp; ?>>
											<i class="ipjck-fa ipjck-fa-ban"></i>
											<?php _e( 'Clear Image', IPJCK_SLUG ); ?>
									</a>
								</div>
								<input type="hidden" name="upload_type" class="ipjck-upload-type" value="media_image" />
								<input type="hidden" name="media_image" class="ipjck-image-id" value="<?php echo $attach_id; ?>" />
							</div>
	          </div>

	          <div class="ipjck-help">
	            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
	            <div class="ipjck-help-content ipjck-hide">
	              <?php _e( 'The background image in the main section.', IPJCK_SLUG ); ?>
	            </div>
	          </div>
	        </div>
	        <!-- end: .ipjck-field -->
	      </div>
	      <!-- end: .ipjck-field-row -->

      </div>
      <!-- end: .ipjck-fields-media-image -->

			<!-- start: .ipjck-fields-media-video  -->
			<div class="ipjck-fields-media-video"<?php echo $dspVideo; ?>>

				<?php
				/*
				 * Youtube Video URL
				 */
				?>
				<!-- start: .ipjck-field-row -->
				<div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
					<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
						<label for="input-youtube-url">
							<?php _e( 'Youtube Video URL', IPJCK_SLUG ); ?>
						</label>
					</div>

					<!-- start: .ipjck-field -->
					<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
						<?php
						$url = $this->setting->getSetting( 'youtube_url' );
						?>
						<input type="text" id="input-youtube-url" class="ipjck-input ipjck-input-full" name="youtube_url" value="<?php echo $url; ?>">

						<div class="ipjck-help">
							<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
							<div class="ipjck-help-content ipjck-hide"><?php _e( 'The URL of your youtube video.', IPJCK_SLUG ); ?>
							</div>
						</div>
					</div>
					<!-- end: .ipjck-field -->
				</div>
				<!-- end: .ipjck-field-row -->

				<?php
				//Input Start
				?>
				<!-- start: .ipjck-field-row -->
				<div class="ipjck-field-row ipjck-field-x">
					<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
						<label for="input-youtube-start"><?php _e( 'Start time', IPJCK_SLUG ); ?></label>
					</div>
					<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
						<div class="ipjck-input-group">
							<?php
							$start = $this->setting->getSetting( 'youtube_start' );
							?>
							<input type="text" id="input-youtube-start" class="ipjck-input ipjck-input-xs" name="youtube_start" value="<?php echo $start; ?>">
							<div class="ipjck-input-addon">second</div>
						</div>

						<div class="ipjck-help">
							<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
							<div class="ipjck-help-content ipjck-hide">
								<?php _e( 'Time in second for start time of your video. You set this value when you want to start the video not from the beginning.', IPJCK_SLUG ); ?>
							</div>
						</div>
					</div>
				</div>
				<!-- end: .ipjck-field-row -->

				<?php
				/*
				 * Width
				 */
				?>
				<!-- start: .ipjck-field-row -->
				<div class="ipjck-field-row ipjck-field-x">
					<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
						<label for="input-video-width"><?php _e( 'Video Width', IPJCK_SLUG ); ?></label>
					</div>

					<!-- start: .ipjck-field -->
					<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

						<?php
						$width = $this->setting->getSetting( 'video_width', 450 );
						?>
						<div class="ipjck-input-group mr5">
								<input type="text" id="input-video-width" class="ipjck-input ipjck-input-xs" name="video_width" value="<?php echo $width; ?>">
								<div class="ipjck-input-addon">px</div>
						</div>

						<div class="ipjck-help">
							<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
							<div class="ipjck-help-content ipjck-hide">
								<?php _e( 'Width ( in pixel ) of the video.', IPJCK_SLUG ); ?>
							</div>
						</div>
					</div>
					<!-- end: .ipjck-field -->
				</div>
				<!-- end: .ipjck-field-row -->

				<?php
				/*
				 * Height
				 */
				?>
				<!-- start: .ipjck-field-row -->
				<div class="ipjck-field-row ipjck-field-x">
					<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
						<label for="input-video-height"><?php _e( 'Video Height', IPJCK_SLUG ); ?></label>
					</div>

					<!-- start: .ipjck-field -->
					<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

						<?php
						$height = $this->setting->getSetting( 'video_height', 320 );
						?>
						<div class="ipjck-input-group mr5">
								<input type="text" id="input-video-height" class="ipjck-input ipjck-input-xs" name="video_height" value="<?php echo $height; ?>">
								<div class="ipjck-input-addon">px</div>
						</div>

						<div class="ipjck-help">
							<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
							<div class="ipjck-help-content ipjck-hide">
								<?php _e( 'Height ( in pixel ) of the video.', IPJCK_SLUG ); ?>
							</div>
						</div>
					</div>
					<!-- end: .ipjck-field -->
				</div>
				<!-- end: .ipjck-field-row -->

				<?php
				//Input autoplay
				?>
				<!-- start: .ipjck-field-row -->
				<div class="ipjck-field-row ipjck-field-x">
					<div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
						<label for="input-video-autoplay"><?php _e( 'Autoplay', IPJCK_SLUG ); ?></label>
					</div>
					<div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
						<div class="ipjck-onoff">
								<?php
								$val = $this->setting->getSetting( 'video_autoplay', 'false' );
								if ( $val == 'false' ) {
										$clon  = '';
										$cloff = ' active';
								} else {
										$clon  = ' active';
										$cloff = '';
								}
								?>
								<div class="ipjck-btn-group">
									<button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
									<button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
								</div>
								<input type="hidden" class="ipjck-onoff-value" name="video_autoplay" value="<?php echo $val; ?>" />
						</div>

						<div class="ipjck-help">
							<a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
							<div class="ipjck-help-content ipjck-hide">
								<?php _e( 'Is the video automatically plays when the page is loaded?', IPJCK_SLUG ); ?>
							</div>
						</div>
					</div>
				</div>
				<!-- end: .ipjck-field-row -->

      </div>
      <!-- end: .ipjck-fields-media-video -->

      </div>

    </div>
    <!-- end: .ipjck-fields -->

  </div>
</div>
