<?php
/**
 * Admin behaviour content view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting = $this->setting;
?>

<h4 class="ipjck-field-title mb0 py10">
  <?php _e( 'Repeat Control', IPJCK_SLUG ); ?>
</h4>

<!-- start: .ipjck-content-onoff -->
<div class="ipjck-content-onoff">

	<!-- start: .ipjck-field-row -->
	<div class="ipjck-field-row ipjck-field-x">
	  <div class="ipjck-form-label col-md-3 col-sm-12">
	    <label for="input-enable-cookies">
	      <?php _e( 'Enable Cookies', IPJCK_SLUG ); ?>
	    </label>
	  </div>
	  <div class="ipjck-field col-md-9 col-sm-12">

	    <div class="ipjck-onoff ipjck-onoff-action">
	      <?php
	      $val = $setting->getSetting( 'enable_cookies', 'true' );
	      if ( $val == 'false' ) {
	          $clon  = '';
	          $cloff = ' active';
	      } else {
	          $clon  = ' active';
	          $cloff = '';
	      }
	      ?>
	      <div class="ipjck-btn-group">
	        <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
	        <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
	      </div>
	      <input type="hidden" class="ipjck-onoff-value" name="enable_cookies" value="<?php echo $val; ?>" />
	    </div>

	    <div class="ipjck-help">
	      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
	      <div class="ipjck-help-content ipjck-hide">
	        <?php _e( 'Set to true if you want to enable cookies.', IPJCK_SLUG ); ?>
	      </div>
	    </div>
	  </div>
	</div>
	<!-- end: .ipjck-field-row -->

	<?php
  /*
   * Enable Cookies
   */
  $dspCookie = ' style="display:none;"';
  if ( $val == 'true' ) {
    $dspCookie = '';
  }
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x ipjck-content-onoff-main"<?php echo $dspCookie; ?>>
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-repeat-conversion"><?php _e( 'Do Not Show After Conversion', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

      <?php
      $days = absint( $setting->getSetting( 'repeat_conversion', 7 ) );
      ?>
      <div class="ipjck-input-group mr5">
        <input type="text" id="input-repeat-conversion" class="ipjck-input ipjck-input-xxs" name="repeat_conversion" value="<?php echo $days; ?>">
        <div class="ipjck-input-addon">days</div>
      </div>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Determine the number of days to display the widget back after conversion.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x ipjck-content-onoff-main"<?php echo $dspCookie; ?>>
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-repeat-closing"><?php _e( 'Do Not Show After Closing', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

      <?php
      $days = absint( $setting->getSetting( 'repeat_closing', 7 ) );
      ?>
      <div class="ipjck-input-group mr5">
        <input type="text" id="input-repeat-closing" class="ipjck-input ipjck-input-xxs" name="repeat_closing" value="<?php echo $days; ?>">
        <div class="ipjck-input-addon">days</div>
      </div>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Determine the number of days to display the widget back after closing widget.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

</div>