<?php
/**
 * Admin behaviour content view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting = $this->setting;
?>

<h4 class="ipjck-field-title mb0 py10">
  <?php _e( 'Smart Launch', IPJCK_SLUG ); ?>
</h4>

<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
    <label for="input-first-show-type">
      <?php _e( 'First Launch Type', IPJCK_SLUG ); ?>
    </label>
  </div>

  <!-- start: .ipjck-field -->
  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

    <select name="first_show_type" id="input-first-show-type" class="ipjck-input ipjck-section-select-options">
      <?php
      $current = $setting->getSetting( 'first_show_type', 'visible' );
      $types   = array(
        'visible'  => __( 'Show', IPJCK_SLUG ),
        'hidden'   => __( 'Hidden', IPJCK_SLUG ),
        'after'    => __( 'After few Seconds', IPJCK_SLUG )
      );
      foreach( $types as $key => $label )
      {
        $sltd = '';
        if ( $current == $key ) {
          $sltd = ' selected="selected"';
        }
        echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
      }
      ?>
    </select>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'Regulate how the widget is displayed for the first time.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->

<?php
/*
 * After few seconds
 */
$dspAfter = ' style="display:none;"';
if ( $current == 'after' ) {
  $dspAfter = '';
}
?>
<!-- start: .ipjck-field-row -->
<div id="ipjck-section-after" class="ipjck-field-row ipjck-field-x ipjck-section-select-content"<?php echo $dspAfter; ?>>
  <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
    <label for="input-first-show-delay"><?php _e( 'Delay Time', IPJCK_SLUG ); ?></label>
  </div>

  <!-- start: .ipjck-field -->
  <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

    <?php
    $delay = absint( $setting->getSetting( 'first_show_delay', 5 ) );
    ?>
    <div class="ipjck-input-group mr5">
      <input type="text" id="input-first-show-delay" class="ipjck-input ipjck-input-xxs" name="first_show_delay" value="<?php echo $delay; ?>">
      <div class="ipjck-input-addon">second</div>
    </div>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'Set the delay time.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field -->
</div>
<!-- end: .ipjck-field-row -->

<!-- start: .ipjck-field-row -->
<div class="ipjck-field-row ipjck-field-x">
  <div class="ipjck-form-label col-md-3 col-sm-12">
    <label for="input-show-exit-intent">
      <?php _e( 'Exit Intent/Before User Leave', IPJCK_SLUG ); ?>
    </label>
  </div>
  <div class="ipjck-field col-md-9 col-sm-12">

    <div class="ipjck-onoff">
      <?php
      $val = $this->setting->getSetting( 'show_exit_intent', 'false' );
      if ( $val == 'false' ) {
          $clon  = '';
          $cloff = ' active';
      } else {
          $clon  = ' active';
          $cloff = '';
      }
      ?>
      <div class="ipjck-btn-group">
        <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
        <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
      </div>
      <input type="hidden" class="ipjck-onoff-value" name="show_exit_intent" value="<?php echo $val; ?>" />
    </div>

    <div class="ipjck-help">
      <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
      <div class="ipjck-help-content ipjck-hide">
        <?php _e( 'Set to true if you want to show the widget when the user wants to get out of the page.', IPJCK_SLUG ); ?>
      </div>
    </div>
  </div>
</div>
<!-- end: .ipjck-field-row -->

<!-- start: .ipjck-content-onoff -->
<div class="ipjck-content-onoff">

  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-md-3 col-sm-12">
      <label for="input-show-user-scroll">
        <?php _e( 'After User Scroll', IPJCK_SLUG ); ?>
      </label>
    </div>
    <div class="ipjck-field col-md-9 col-sm-12">

      <div class="ipjck-onoff ipjck-onoff-action">
        <?php
        $val = $this->setting->getSetting( 'show_user_scroll', 'false' );
        if ( $val == 'false' ) {
            $clon  = '';
            $cloff = ' active';
        } else {
            $clon  = ' active';
            $cloff = '';
        }
        ?>
        <div class="ipjck-btn-group">
          <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
          <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
        </div>
        <input type="hidden" class="ipjck-onoff-value" name="show_user_scroll" value="<?php echo $val; ?>" />
      </div>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'After User Scroll should be set to true if you want to show the widget when the user scrolls down the page.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  $dspScroll = ' style="display:none;"';
  if ( $val == 'true' ) {
    $dspScroll = '';
  }
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x ipjck-content-onoff-main ipjck-help-abs"<?php echo $dspScroll; ?>>
    <div class="ipjck-form-label col-md-3 col-sm-12">
      <label for="input-show-user-scroll-id">
        <?php _e( 'HTML ID', IPJCK_SLUG ); ?>
      </label>
    </div>
    <div class="ipjck-field col-md-9 col-sm-12">

      <?php
      $id = stripslashes( $setting->getSetting( 'show_user_scroll_id' ) );
      ?>
      <input type="text" id="input-show-user-scroll-id" class="ipjck-input ipjck-input-full" name="show_user_scroll_id" value="<?php echo $id; ?>">

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Set the HTML attribute ID of the content, wherein when the scroll has reached that content, widgets are displayed.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field-row -->


  <?php
  $dspScroll = ' display:none;';
  if ( $val == 'true' ) {
    $dspScroll = '';
  }
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x ipjck-content-onoff-main" style="border-bottom:1px solid #ddd;<?php echo $dspScroll; ?>">
    <div class="ipjck-form-label col-md-3 col-sm-12">
      <label for="input-show-user-scroll-height">
        <?php _e( 'Scroll Height', IPJCK_SLUG ); ?>
      </label>
    </div>
    <div class="ipjck-field col-md-9 col-sm-12">

      <?php
      $height = stripslashes( $setting->getSetting( 'show_user_scroll_height' ) );
      ?>
      <div class="ipjck-input-group mr5">
        <input type="text" id="input-show-user-scroll-height" class="ipjck-input ipjck-input-xs" name="show_user_scroll_height" value="<?php echo $height; ?>">
        <div class="ipjck-input-addon">px</div>
      </div>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Set the distance of the content, wherein when the scroll has reached that content, widgets are displayed.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field-row -->

</div>
<!-- end: .ipjck-content-onoff -->

<!-- start: .ipjck-content-onoff -->
<div class="ipjck-content-onoff">

  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-md-3 col-sm-12">
      <label for="input-show-user-inactive">
        <?php _e( 'When User Is Inactive', IPJCK_SLUG ); ?>
      </label>
    </div>
    <div class="ipjck-field col-md-9 col-sm-12">

      <div class="ipjck-onoff ipjck-onoff-action">
        <?php
        $val = $this->setting->getSetting( 'show_user_inactive', 'false' );
        if ( $val == 'false' ) {
            $clon  = '';
            $cloff = ' active';
        } else {
            $clon  = ' active';
            $cloff = '';
        }
        ?>
        <div class="ipjck-btn-group">
          <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
          <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
        </div>
        <input type="hidden" class="ipjck-onoff-value" name="show_user_inactive" value="<?php echo $val; ?>" />
      </div>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Set to true if you want to show the widget when the user inactive.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  /*
   * Inactive Time
   */

  $dspInactive = ' style="display:none;"';
  if ( $val == 'true' ) {
    $dspInactive = '';
  }
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x ipjck-content-onoff-main"<?php echo $dspInactive; ?>>
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-show-user-inactive-time"><?php _e( 'Inactive Time', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

      <?php
      $time = absint( $setting->getSetting( 'show_user_inactive_time', 5 ) );
      ?>
      <div class="ipjck-input-group mr5">
        <input type="text" id="input-show-user-inactive-time" class="ipjck-input ipjck-input-xxs" name="first_show_delay" value="<?php echo $time; ?>">
        <div class="ipjck-input-addon">second</div>
      </div>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Set the inactive time.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

</div>
<!-- end: .ipjck-content-onoff -->