<?php
/**
 * Action link view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting    = $this->setting;
$current    = $setting->getSetting( 'action_type', 'form' );
$dspSection = ' style="display:none";';
if ( $current == 'link' ) {
  $dspSection = '';
}
?>

<!-- start: .ipjck-section-select-content -->
<div id="ipjck-section-link" class="ipjck-section-select-content"<?php echo $dspSection; ?>>


	<?php
  /*
   * Link label
   */
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-link-label"><?php _e( 'Link Label', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
      <?php
      $label = stripslashes( $setting->getSetting( 'link_label' ) );
      ?>
      <input type="text" id="input-link-label" class="ipjck-input ipjck-input-full" name="link_label" value="<?php echo $label; ?>">

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide"><?php _e( 'The label of the link.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

	<?php
  /*
   * Link URL
   */
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-link-url"><?php _e( 'Link URL', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
      <?php
      $url = stripslashes( $setting->getSetting( 'link_url' ) );
      ?>
      <input type="text" id="input-link-url" class="ipjck-input ipjck-input-full" name="link_url" value="<?php echo $url; ?>">

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide"><?php _e( 'The url of the link.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

  <h4 class="ipjck-field-title mb0 py10">
    <?php _e( 'Link Design', IPJCK_SLUG ); ?>
  </h4>

  <?php
  /*
   * Link Color
   */
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-link-color"><?php _e( 'Link Color', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

      <?php
      $color = stripslashes( $setting->getSetting( 'link_color', '#333333' ) );
      ?>
      <input type="text" class="ipjck-color-picker" id="input-link-color" name="link_color" value="<?php echo $color; ?>" />

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Set the color of the link.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  /*
   * Hover Color
   */
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-link-hover-color"><?php _e( 'Hover Color', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

      <?php
      $color = stripslashes( $setting->getSetting( 'link_hover_color', '#000000' ) );
      ?>
      <input type="text" class="ipjck-color-picker" id="input-link-hover-color" name="link_hover_color" value="<?php echo $color; ?>" />

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Set the color of the link.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  /*
   * Font Size
   */
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-link-font-size"><?php _e( 'Font Size', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

      <?php
      $size = absint( $setting->getSetting( 'link_font_size', '14' ) );
      ?>
      <div class="ipjck-input-group mr5">
        <input type="text" id="input-link-font-size" class="ipjck-input ipjck-input-xxs" name="link_font_size" value="<?php echo $size; ?>">
        <div class="ipjck-input-addon">px</div>
      </div>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Set the font size of the link.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  //Font Family
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-link-font-family"><?php _e( 'Font Family', IPJCK_SLUG ); ?></label>
    </div>
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">

      <?php
      $current = $setting->getSetting( 'link_font_family', 'roboto' );
      $fonts   = IPJck_Font::getOptions();
      $fname   = IPJck_Font::getFontName( $current );
      ?>
      <span class="ipjck-font-family">
        <div class="ipjck-menu ipjck-fancy-option">
          <div class="ipjck-selected">
            <div class="ipjck-selected-box">
              <span data-select="<?php echo $current; ?>"><?php echo $fname; ?></span>
            </div>
            <span class="toggle"></span>
          </div>
          <div class="ipjck-select" style="display: none;">
            <div class="ipjck-select-content">
              <ul class="clearfix">
                <?php
                foreach( $fonts as $fkey => $label ) :
                ?>
                <li data-select="<?php echo $fkey; ?>">
                  <strong class="ipjck-select-label">
                    <?php echo $label; ?>
                  </strong>
                </li>
                <?php
                endforeach;
                ?>
              </ul>
            </div>
          </div>
          <input type="hidden" name="link_font_family" class="ipjck-input-select" value="<?php echo $current; ?>" />
        </div>
      </span>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'The font family of the link.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
  </div>
  <!-- end: .ipjck-field-row -->

  <?php
  /*
   * Text Decoration
   */
  ?>
  <!-- start: .ipjck-field-row -->
  <div class="ipjck-field-row ipjck-field-x">
    <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
      <label for="input-link-underline"><?php _e( 'Text Underline', IPJCK_SLUG ); ?></label>
    </div>

    <!-- start: .ipjck-field -->
    <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
      <div class="ipjck-onoff">
        <?php
        $val = $setting->getSetting( 'link_underline', 'false' );
        if ( $val == 'false' ) {
            $clon  = '';
            $cloff = ' active';
        } else {
            $clon  = ' active';
            $cloff = '';
        }
        ?>
        <div class="ipjck-btn-group">
          <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
          <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
        </div>
        <input type="hidden" class="ipjck-onoff-value" name="link_underline" value="<?php echo $val; ?>" />
      </div>

      <div class="ipjck-help">
        <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
        <div class="ipjck-help-content ipjck-hide">
          <?php _e( 'Determine whether to add the bottom line on link.', IPJCK_SLUG ); ?>
        </div>
      </div>
    </div>
    <!-- end: .ipjck-field -->
  </div>
  <!-- end: .ipjck-field-row -->

</div>
<!-- end: .ipjck-section-select-content -->