<?php
/**
 * Admin manage content of the page
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */
$setting = $this->setting;
?>
<div id="ipjck-section-content" class="ipjck-tab-content">
  <div class="ipjck-tab-inner">

    <div class="ipjck-title-content ipjck-hide">
      <i class="ipjck-fa ipjck-fa-globe"></i>
      <div class="ipjck-title-text">
        <h3><?php _e( 'Content', IPJCK_SLUG ); ?></h3>
        <p><?php _e( 'Manage page content', IPJCK_SLUG ); ?></p>
      </div>
    </div>
    <!-- start: .ipjck-fields -->
    <div class="ipjck-fields">

      <h4 class="ipjck-field-title mb0 py10">
        <?php _e( 'Link Replacement', IPJCK_SLUG ); ?>
      </h4>

      <p class="mb15"><?php _e( 'You can use the options below to replace the entire URL links inside the content.', IPJCK_SLUG ); ?></p>

      <?php
      /*
       * Status
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-link-replace-active"><?php _e( 'Replace All Links', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <div class="ipjck-onoff">
              <?php
              $val = $this->setting->getSetting( 'link_replace_active', 'false' );
              if ( $val == 'false' ) {
                  $clon  = '';
                  $cloff = ' active';
              } else {
                  $clon  = ' active';
                  $cloff = '';
              }
              ?>
              <div class="ipjck-btn-group">
                <button data-value="true" class="ipjck-btn-onoff<?php echo $clon; ?> ipjck-btn-on" type="button"><?php _e( 'On', IPJCK_SLUG ); ?></button>
                <button data-value="false" class="ipjck-btn-onoff<?php echo $cloff; ?> ipjck-btn-off" type="button"><?php _e( 'Off', IPJCK_SLUG ); ?></button>
              </div>
              <input type="hidden" class="ipjck-onoff-value" name="link_replace_active" value="<?php echo $val; ?>" />
          </div>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'Set On if you want replacing all links in the content.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      /*
       * URL
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-link-replace-url"><?php _e( 'Link URL', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $url = $this->setting->getSetting( 'link_replace_url', '' );
          ?>
          <input type="text" id="input-link-replace-url" class="ipjck-input ipjck-input-full" name="link_replace_url" value="<?php echo $url; ?>">

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide"><?php _e( 'Specify the url replacement of existing links within content.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

      <h4 class="ipjck-field-title mb0 py10">
        <?php _e( 'Widget', IPJCK_SLUG ); ?>
      </h4>

      <?php
      /*
       * Add Widget Bar
       */
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x ipjck-help-abs">
        <div class="ipjck-form-label col-lg-3 col-md-4 col-sm-12">
          <label for="input-page-bar"><?php _e( 'Add Widget Info Bar', IPJCK_SLUG ); ?></label>
        </div>

        <!-- start: .ipjck-field -->
        <div class="ipjck-field col-lg-9 col-md-8 col-sm-12">
          <?php
          $current = $this->setting->getSetting( 'page_bar', 0 );
          ?>
          <select id="input-page-bar" class="ipjck-input" name="page_bar">
            <option value="0">--<?php _e( 'Select Bar', IPJCK_SLUG ); ?>--</option>
            <?php
            if ( ! empty( $this->bars )) :
              foreach( $this->bars as $bar ) :
                $sltd = '';
                if ( $bar->ID == $current ) {
                  $sltd = ' selected="selected"';
                }
                echo '<option value="' . $bar->ID . '"' . $sltd . '>' . $bar->post_title . '</option>';
            ?>

            <?php
              endforeach;
            endif;
            ?>
          </select>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide"><?php _e( 'Specifies the widget bar to be added to the page.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
        <!-- end: .ipjck-field -->
      </div>
      <!-- end: .ipjck-field-row -->

    </div>
    <!-- end: .ipjck-fields -->
  </div>
</div>
