<?php
/**
 * Admin header view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$pageDash    = IPJCK_PAGENAME;
$pagePage    = IPJCK_PAGENAME . '-page';
$pageBar     = IPJCK_PAGENAME . '-bar';
$page        = $this->pageId;
$struct = array(
     $pageDash => array(
         'title'     => __( 'Dashboard', IPJCK_SLUG ),
         'info'      => __( 'Plugin dashboard', IPJCK_SLUG ),
         'icon'      => 'dashboard'
     ),
     $pagePage => array(
         'title'     => __( 'Page', IPJCK_SLUG ),
         'info'      => __( 'Manage viral click pages', IPJCK_SLUG ),
         'icon'      => 'feed'
     ),
     $pageBar => array(
         'title'     => __( 'Info Bar', IPJCK_SLUG ),
         'info'      => __( 'Manage info bar', IPJCK_SLUG ),
         'icon'      => 'list-alt'
     )
 );
?>
<div class="ipjck-top">
    <div class="ipjck-header">
        <div class="ipjck-page-title">
            <h1>
                <i class="dashicons-before dashicons-welcome-widgets-menus"></i>
                <span>
                    <?php
                    $title = IPJCK_TITLE;
                    $words = explode( ' ', $title );
                    $first = array_shift( $words );
                    $title = implode( ' ', $words );
                    ?>
                    <strong><span><?php echo $first; ?></span> <?php echo $title; ?></strong>
                    <em> <?php echo IPJCK_DESC; ?></em>
                </span>
            </h1>
        </div>
    </div>
    <div class="ipjck-nav">
        <ul>
        <?php
        $title = isset( $this->title ) ? $this->title : '';
        $info  = isset( $this->info ) ? $this->info : '';
        $icon  = isset( $this->icon ) ? $this->icon : '';
        if ( array_key_exists( $page, $struct ))
        {
            if ( empty( $title )) {
                $title = $struct[$page]['title'];
            }
            if ( empty( $info )) {
                $info  = $struct[$page]['info'];
            }
            if ( empty( $icon )) {
                $icon  = $struct[$page]['icon'];
            }
        }
        foreach( $struct as $name => $data )
        {
            $active = '';
            if ( $page == $name ) {
                $active = ' class="active"';
            }
            echo '<li' . $active . '>' .
                    '<a href="admin.php?page=' . $name . '">' .
                        '<i class="ipjck-fa ipjck-fa-' . $data['icon'] . '"></i>' .
                        $data['title'] .
                    '</a>' .
                '</li>';
        }
        ?>
        </ul>
    </div>
    <div class="ipjck-page-info">
        <i class="ipjck-fa ipjck-fa-<?php echo $icon; ?>"></i>
        <div class="ipjck-info">
            <h3><?php echo $title; ?></h3>
            <h4><?php echo $info; ?></h4>
        </div>
    </div>
</div>
