<?php
/**
 * Admin dashboard view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */
?>
<div id="ipjck-dashboard" class="wrap ipjck-wrap ipjck-admin">
  <div class="ipjck-inner">

    <?php
    $this->view( 'admin/general/header' );
    ?>

    <div class="ipjck-main ipjck-form">

      <div class="ipjck-wrapper mb20">

        <h4 class="ipjck-field-title mb20 py10"><?php _e( 'All Your Pages', IPJCK_SLUG ); ?></h4>

        <!-- start: .ipjck-statistic -->
        <div class="ipjck-statistic mb20">

          <?php
          $clicks  = 0;
          $views   = 0;
          $submits = 0;
          $rate    = 0;
          $model   = new IPJck_Model_PageStat();
          $stats   = $model->getAllStats();
          if ( ! empty( $stats )) {
            $clicks  = $stats->clicks;
            $views   = $stats->views;
            if ( ! empty( $stats->views ) && ! empty( $stats->clicks )) {
              $rate = $stats->clicks/$stats->views;
              $rate = number_format( $rate, 2, '.', '' );
            }
          }
          ?>

          <div class="ipjck-stat-filter ipjck-clear">
            <div class="ipjck-stat-nav">
              <div class="container container-fluid">
                <ul class="row">
                  <li class="col-sm-4 ipjck-nav-view ipjck-nav-blue active">
                    <a href="#stat-view">
                      <i class="ipjck-fa ipjck-fa-eye"></i>
                      <span class="stat-value">
                        <strong> <?php echo number_format( $views ); ?></strong>
                        <em> <?php _e( 'Views', IPJCK_SLUG ); ?></em>
                      </span>
                    </a>
                  </li>
                  <li class="col-sm-4 ipjck-nav-click ipjck-nav-orange active">
                    <a href="#stat-click">
                      <i class="ipjck-fa ipjck-fa-mouse-pointer"></i>
                      <span class="stat-value">
                        <strong> <?php echo number_format( $clicks ); ?></strong>
                        <em> <?php _e( 'Clicks', IPJCK_SLUG ); ?></em>
                      </span>
                    </a>
                  </li>
                  <li class="col-sm-4 ipjck-nav-rate ipjck-nav-green active">
                    <a href="#stat-rate">
                      <i class="ipjck-fa ipjck-fa-line-chart"></i>
                      <span class="stat-value">
                        <strong> <?php echo $rate; ?></strong>
                        <em> <?php _e( 'Conversion Rate', IPJCK_SLUG ); ?></em>
                      </span>
                    </a>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        <div class="ipjck-statistic-list">
          <?php
          require_once( IPJCK_LIB . 'list/main-page.php' );
          $list = new IPJck_List_MainPage();
          $list->render();
          ?>
        </div>
      </div>

      <div class="ipjck-wrapper">

        <h4 class="ipjck-field-title mb20 py10"><?php _e( 'All Your Widgets', IPJCK_SLUG ); ?></h4>

        <!-- start: .ipjck-statistic -->
        <div class="ipjck-statistic mb20">

          <?php
          $clicks  = 0;
          $views   = 0;
          $submits = 0;
          $rate    = 0;
          $model   = new IPJck_Model_WidgetStat();
          $stats   = $model->getAllStats();
          if ( ! empty( $stats )) {
            $clicks  = $stats->clicks;
            $views   = $stats->views;
            $submits = $stats->submits;
            if ( ! empty( $stats->views ) && ! empty( $stats->clicks )) {
              $rate = $stats->clicks/$stats->views;
              $rate = number_format( $rate, 2, '.', '' );
            }
          }
          ?>

          <div class="ipjck-stat-filter ipjck-clear">
            <div class="ipjck-stat-nav">
              <div class="container container-fluid">
                <ul class="row">
                  <li class="col-sm-3 ipjck-nav-view ipjck-nav-blue active">
                    <a href="#stat-view">
                      <i class="ipjck-fa ipjck-fa-eye"></i>
                      <span class="stat-value">
                        <strong> <?php echo number_format( $views ); ?></strong>
                        <em> <?php _e( 'Views', IPJCK_SLUG ); ?></em>
                      </span>
                    </a>
                  </li>
                  <li class="col-sm-3 ipjck-nav-click ipjck-nav-orange active">
                    <a href="#stat-click">
                      <i class="ipjck-fa ipjck-fa-mouse-pointer"></i>
                      <span class="stat-value">
                        <strong> <?php echo number_format( $clicks ); ?></strong>
                        <em> <?php _e( 'Clicks', IPJCK_SLUG ); ?></em>
                      </span>
                    </a>
                  </li>
                  <li class="col-sm-3 ipjck-nav-submit ipjck-nav-red active">
                    <a href="#stat-submit">
                      <i class="ipjck-fa ipjck-fa-edit"></i>
                      <span class="stat-value">
                        <strong> <?php echo number_format( $submits ); ?></strong>
                        <em> <?php _e( 'Submits', IPJCK_SLUG ); ?></em>
                      </span>
                    </a>
                  </li>
                  <li class="col-sm-3 ipjck-nav-rate ipjck-nav-green active">
                    <a href="#stat-rate">
                      <i class="ipjck-fa ipjck-fa-line-chart"></i>
                      <span class="stat-value">
                        <strong> <?php echo $rate; ?></strong>
                        <em> <?php _e( 'Conversion Rate', IPJCK_SLUG ); ?></em>
                      </span>
                    </a>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        <div class="ipjck-statistic-list">
          <?php
          require_once( IPJCK_LIB . 'list/main.php' );
          $list = new IPJck_List_Main();
          $list->render();
          ?>
        </div>
      </div>

    </div>

  </div>

</div>
