<?php
/**
 * Manage box style view
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

$setting  = $this->setting;
$template = $setting->getSetting( 'template', 1 );
?>
<div id="ipjck-section-design" class="ipjck-tab-content">
  <div class="ipjck-tab-inner">

    <div class="ipjck-title-content ipjck-hide">
      <i class="ipjck-fa ipjck-fa-paint-brush"></i>
      <div class="ipjck-title-text">
        <h3><?php _e( 'Design', IPJCK_SLUG ); ?></h3>
        <p><?php _e( 'Set the style of the widget', IPJCK_SLUG ); ?></p>
      </div>
    </div>

    <!-- start: .ipjck-fields -->
    <div class="ipjck-fields">

      <h4 class="ipjck-field-title mb0 py10">
        <?php _e( 'General', IPJCK_SLUG ); ?>
      </h4>

      <?php
      //Position
      ?>
      <!-- start: .ipjck-field-row -->
      <div class="ipjck-field-row ipjck-field-x">
        <div class="ipjck-form-label col-md-3 col-sm-12">
          <label for="input-bar-position"><?php _e( 'Position', IPJCK_SLUG ); ?></label>
        </div>
        <div class="ipjck-field col-md-9 col-sm-12">

          <select name="bar_position" id="input-bar-position">
            <?php
            $current = $this->setting->getSetting( 'bar_position', 'top' );
            $options = array(
              'top'      => __( 'Top', IPJCK_SLUG ),
              'bottom'   => __( 'Bottom', IPJCK_SLUG )
            );
            foreach( $options as $key => $label )
            {
              $sltd = '';
              if ( $current == $key ) {
                $sltd = ' selected="selected"';
              }
              echo '<option value="' . $key . '"' . $sltd . '>' . $label . '</option>';
            }
            ?>
          </select>

          <div class="ipjck-help">
            <a class="ipjck-btn-help ipjck-btn ipjck-btn-default" href="#"><i class="ipjck-fa ipjck-fa-question"></i></a>
            <div class="ipjck-help-content ipjck-hide">
              <?php _e( 'The position of widget bar.', IPJCK_SLUG ); ?>
            </div>
          </div>
        </div>
      </div>
      <!-- end: .ipjck-field-row -->

      <?php
      //Mobile
      $this->view( 'admin/widget/design/mobile' );
      //
      //Padding
      if ( $template > 4 ) {
        $this->hidePadding = true;
      } else {
        $this->hidePadding2 = true;
      }
      if ( $template == 5 ) {
        $this->topPaddingLabel    = __( 'Left Section Padding', IPJCK_SLUG );
        $this->bottomPaddingLabel = __( 'Right Section Padding', IPJCK_SLUG );
      } 
      elseif ( $template == 6 ) {
        $this->topPaddingLabel    = __( 'Main Section Padding', IPJCK_SLUG );
        $this->bottomPaddingLabel = __( 'Content Section Padding', IPJCK_SLUG );
      } 
      else {
        $this->topPaddingLabel    = __( 'Top Section Padding', IPJCK_SLUG );
        $this->bottomPaddingLabel = __( 'Bottom Section Padding', IPJCK_SLUG );
      }
      $this->view( 'admin/widget/design/padding' );
      $this->view( 'admin/widget/design/padding2' );
      //
      //Background
      if ( $template > 4 ) {
        $this->hideBackground = true;
      } else {
        $this->hideBackground2 = true;
      }
      if ( $template == 5 ) {
        $this->mainBgLabel = __( 'Left Section Background', IPJCK_SLUG );
        $this->secBgLabel  = __( 'Right Section Background', IPJCK_SLUG );
      } 
      elseif ( $template == 6 ) {
        $this->mainBgLabel = __( 'Content Section Background', IPJCK_SLUG );
        $this->secBgLabel  = __( 'Main Section Background', IPJCK_SLUG );
      } 
      else {
        $this->mainBgLabel = __( 'Top Section Background', IPJCK_SLUG );
        $this->secBgLabel  = __( 'Bottom Section Background', IPJCK_SLUG );
      }
      $this->view( 'admin/widget/design/background' );
      $this->view( 'admin/widget/design/background2' );
      //Border
      $this->view( 'admin/widget/design/border' );
      //Text
      $this->view( 'admin/widget/design/text' );
      //Close
      $this->view( 'admin/widget/design/close' );
      ?>

    </div>
    <!-- end: .ipjck-fields -->

  </div>
</div>