<?php
/**
 * Class model slide in
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPJck_Model_Widget_Slide' )) {

  /**
   * Class model slide in
   */
  class IPJck_Model_Widget_Slide extends IPJck_Model_Widget
  {
    /**
     * Take type widget
     *
     * @var string
     */
    protected $_type = 'slide';

    /**
     * Save general design settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingDesignGeneral( $data )
    {
      $settings = parent::_saveSettingDesignGeneral( $data );

      if ( isset( $data['slide_position'] )) {
        $settings['slide_position'] = 
          apply_filters( 'pre_term_name', $data['slide_position'] );
      }
      if ( isset( $data['slide_width'] )) {
        $settings['slide_width'] = absint( $data['slide_width'] );
      }

      if ( isset( $data['minimize_button'] )) {
        $settings['minimize_button'] = 
          apply_filters( 'pre_term_name', $data['minimize_button'] );
      }
      if ( isset( $data['minimize_bgcolor'] )) {
        $settings['minimize_bgcolor'] = 
          apply_filters( 'pre_term_name', $data['minimize_bgcolor'] );
      }
      if ( isset( $data['minimize_color'] )) {
        $settings['minimize_color'] = 
          apply_filters( 'pre_term_name', $data['minimize_color'] );
      }
      if ( isset( $data['minimize_border_color'] )) {
        $settings['minimize_border_color'] = 
          apply_filters( 'pre_term_name', $data['minimize_border_color'] );
      }
      if ( isset( $data['minimize_border_width'] )) {
        $settings['minimize_border_width'] = absint( $data['minimize_border_width'] );
      }

      return $settings;
    }
  }
}