<?php
/**
 * Class model bar popup
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPJck_Model_Widget_Bar' )) {

  /**
   * Class model bar popup
   */
  class IPJck_Model_Widget_Bar extends IPJck_Model_Widget
  {
    /**
     * Take type widget
     *
     * @var string
     */
    protected $_type = 'bar';

    /**
     * Save general design settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingDesignGeneral( $data )
    {
      $settings = parent::_saveSettingDesignGeneral( $data );

      if ( isset( $data['bar_position'] )) {
        $settings['bar_position'] = 
          apply_filters( 'pre_term_name', $data['bar_position'] );
      }

      return $settings;
    }
  }
}