<?php
/**
 * Class model widget
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPJck_Model_Widget' )) {

  /**
   * Class model widget
   */
  abstract class IPJck_Model_Widget
  {
    /**
     * Take type widget
     *
     * @var string
     */
    protected $_type;

    /**
     * Take setting name
     *
     * @var string
     */
    protected $_settingName = '__ipjck-widget-setting';

    /**
     * Save setting
     *
     * @param  int $postId
     * @return void
     */
    public function saveSetting( $postId )
    {
      $postId   = absint( $postId );
      $data     = $this->_getSettingData( $postId );
      $setting  = new IPJck_Setting( $postId, $this->_settingName );
      $result   = $setting->setSettings( $data );
      return $result;
    }

    /**
     * Get setting data
     *
     * @param  int $postId
     * @return array
     */
    protected function _getSettingData( $postId )
    {
      $settings = array();
      $data     = array_merge( $_POST, $_GET );

      //
      //General
      $general  = $this->_saveSettingGeneral( $data );
      $settings = array_merge( $settings, $general );

      //
      //Content
      $content  = $this->_saveSettingContent( $data );
      $settings = array_merge( $settings, $content );

      //
      //Action
      $action   = $this->_saveSettingAction( $data );
      $settings = array_merge( $settings, $action );

      //
      //Submission
      $submission = $this->_saveSettingSubmission( $data );
      $settings   = array_merge( $settings, $submission );

      //
      //Behaviour
      $behaviour = $this->_saveSettingBehaviour( $data );
      $settings  = array_merge( $settings, $behaviour );

      //
      //Design
      $design   = $this->_saveSettingDesign( $data );
      $settings = array_merge( $settings, $design );

      //
      //Effect
      $effect   = $this->_saveSettingEffect( $data );
      $settings = array_merge( $settings, $effect );

      return $settings;
    }

    /**
     * Save general settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingGeneral( $data )
    {
      $settings = array(
        'type' => $this->_type
      );

      if ( isset( $data['status'] )) {
        $settings['status'] = apply_filters( 'pre_term_name', $data['status'] );
      }
      if ( isset( $data['template'] )) {
        $settings['template'] = apply_filters( 'pre_term_name', $data['template'] );
      }
      if ( isset( $data['restricted'] )) {
        $settings['restricted'] = apply_filters( 'pre_term_name', $data['restricted'] );
      }
      return $settings;
    }

    /**
     * Save content settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingContent( $data )
    {
      $settings = array();


      if ( isset( $data['widget_title'] )) {
        $settings['widget_title'] = apply_filters( 
          'single_post_title', $data['widget_title'] 
        );
      }
      if ( isset( $data['widget_info'] )) {
        $settings['widget_info'] = apply_filters( 
          'single_post_title', $data['widget_info'] 
        );
      }
      if ( isset( $data['widget_footer_info'] )) {
        $settings['widget_footer_info'] = apply_filters( 
          'single_post_title', $data['widget_footer_info'] 
        );
      }

      //
      //Media
      $media    = $this->_saveSettingContentMedia( $data );
      $settings = array_merge( $settings, $media );
      
      return $settings;
    }

    /**
     * Save content media settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingContentMedia( $data )
    {
      $settings = array();

      if ( isset( $data['media_type'] )) {
        $settings['media_type'] = apply_filters( 'pre_term_name', $data['media_type'] );
      }
      if ( isset( $data['media_image'] )) {
        $settings['media_image'] = absint( $data['media_image'] );
      }
      if ( isset( $data['youtube_url'] )) {
        $settings['youtube_url'] = apply_filters( 'pre_link_url', $data['youtube_url'] );
      }
      if ( isset( $data['youtube_start'] )) {
        $settings['youtube_start'] = absint( $data['youtube_start'] );
      }
      if ( isset( $data['video_autoplay'] )) {
        $settings['video_autoplay'] = apply_filters( 
          'pre_term_name', $data['video_autoplay'] 
        );
      }
      if ( isset( $data['video_width'] )) {
        $settings['video_width'] = absint( $data['video_width'] );
      }
      if ( isset( $data['video_height'] )) {
        $settings['video_height'] = absint( $data['video_height'] );
      }

      return $settings;
    }

    /**
     * Save action settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingAction( $data )
    {
      $settings = array();

      if ( isset( $data['action_type'] )) {
        $settings['action_type'] = apply_filters( 'pre_term_name', $data['action_type'] );
      }

      //
      //Form
      $form     = $this->_saveSettingActionForm( $data );
      $settings = array_merge( $settings, $form );

      //
      //Button
      $button   = $this->_saveSettingActionButton( $data );
      $settings = array_merge( $settings, $button );

      //
      //Link
      $link     = $this->_saveSettingActionLink( $data );
      $settings = array_merge( $settings, $link );

      //
      //Social
      $social   = $this->_saveSettingActionSocial( $data );
      $settings = array_merge( $settings, $social );

      return $settings;
    }

    /**
     * Save action form settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingActionForm( $data )
    {
      $settings = array();

      
      if ( isset( $data['autoresponder_code'] )) {
        $settings['autoresponder_code'] = $data['autoresponder_code'];
      }
      if ( isset( $data['autoresponder_action'] )) {
        $settings['autoresponder_action'] =
          apply_filters( 'pre_link_url', $data['autoresponder_action'] );
      }
      if ( isset( $data['autoresponder_email'] )) {
        $settings['autoresponder_email'] =
          apply_filters( 'single_post_title', $data['autoresponder_email'] );
      }
      if ( isset( $data['autoresponder_email_label'] )) {
        $settings['autoresponder_email_label'] =
          apply_filters( 'single_post_title', $data['autoresponder_email_label'] );
      }
      if ( isset( $data['autoresponder_name'] )) {
        $settings['autoresponder_name'] = $data['autoresponder_name'];
      }
      if ( isset( $data['autoresponder_name_label'] )) {
        $settings['autoresponder_name_label'] =
          apply_filters( 'single_post_title', $data['autoresponder_name_label'] );
      }
      if ( isset( $data['autoresponder_name_activate'] )) {
        $settings['autoresponder_name_activate'] =
          apply_filters( 'pre_term_name', $data['autoresponder_name_activate'] );
      }
      if ( isset( $data['form_button_label'] )) {
        $settings['form_button_label'] = 
          apply_filters( 'single_post_title', $data['form_button_label'] );
      }

      //
      //Form design
      if ( isset( $data['form_layout'] )) {
        $settings['form_layout'] = apply_filters( 'pre_term_name', $data['form_layout'] );
      }
      if ( isset( $data['form_size'] )) {
        $settings['form_size'] = apply_filters( 'pre_term_name', $data['form_size'] );
      }
      if ( isset( $data['form_width'] )) {
        $settings['form_width'] = absint( $data['form_width'] );
      }
      if ( isset( $data['form_background_color'] )) {
        $settings['form_background_color'] = 
          apply_filters( 'pre_term_name', $data['form_background_color'] );
      }
      if ( isset( $data['form_border_color'] )) {
        $settings['form_border_color'] = 
          apply_filters( 'pre_term_name', $data['form_border_color'] );
      }
      if ( isset( $data['form_border_width'] )) {
        $settings['form_border_width'] = absint( $data['form_border_width'] );
      }
      if ( isset( $data['form_border_radius'] )) {
        $settings['form_border_radius'] = 
          apply_filters( 'pre_term_name', $data['form_border_radius'] );
      }
      if ( isset( $data['form_text_color'] )) {
        $settings['form_text_color'] = 
          apply_filters( 'pre_term_name', $data['form_text_color'] );
      }
      if ( isset( $data['form_font_family'] )) {
        $settings['form_font_family'] = 
          apply_filters( 'pre_term_name', $data['form_font_family'] );
      }
      if ( isset( $data['form_font_size'] )) {
        $settings['form_font_size'] = absint( $data['form_font_size'] );
      }
      if ( isset( $data['form_inner_shadow'] )) {
        $settings['form_inner_shadow'] = 
          apply_filters( 'pre_term_name', $data['form_inner_shadow'] );
      }
      if ( isset( $data['form_outer_shadow'] )) {
        $settings['form_outer_shadow'] = 
          apply_filters( 'pre_term_name', $data['form_outer_shadow'] );
      }

      //
      //Button design
      if ( isset( $data['form_button_template'] )) {
        $settings['form_button_template'] = absint( $data['form_button_template'] );
      }
      if ( isset( $data['form_button_style_color'] )) {
        $settings['form_button_style_color'] = 
          apply_filters( 'pre_term_name', $data['form_button_style_color'] );
      }
      if ( isset( $data['form_button_size'] )) {
        $settings['form_button_size'] = 
          apply_filters( 'pre_term_name', $data['form_button_size'] );
      }
      if ( isset( $data['form_button_full_width'] )) {
        $settings['form_button_full_width'] = 
          apply_filters( 'pre_term_name', $data['form_button_full_width'] );
      }
      if ( isset( $data['form_button_radius'] )) {
        $settings['form_button_radius'] = 
          apply_filters( 'pre_term_name', $data['form_button_radius'] );
      }
      if ( isset( $data['form_button_icon_position'] )) {
        $settings['form_button_icon_position'] = 
          apply_filters( 'pre_term_name', $data['form_button_icon_position'] );
      }
      if ( isset( $data['form_button_icon'] )) {
        $settings['form_button_icon'] = 
          apply_filters( 'pre_term_name', $data['form_button_icon'] );
      }

      return $settings;
    }

    /**
     * Save action button settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingActionButton( $data )
    {
      $settings = array();

      if ( isset( $data['button_url'] )) {
        $settings['button_url'] = apply_filters( 'pre_link_url', $data['button_url'] );
      }
      if ( isset( $data['button_label'] )) {
        $settings['button_label'] = 
          apply_filters( 'single_post_title', $data['button_label'] );
      }
      if ( isset( $data['button_template'] )) {
        $settings['button_template'] = absint( $data['button_template'] );
      }
      if ( isset( $data['button_style_color'] )) {
        $settings['button_style_color'] = 
          apply_filters( 'pre_term_name', $data['button_style_color'] );
      }
      if ( isset( $data['button_size'] )) {
        $settings['button_size'] = apply_filters( 'pre_term_name', $data['button_size'] );
      }
      if ( isset( $data['button_full_width'] )) {
        $settings['button_full_width'] = 
          apply_filters( 'pre_term_name', $data['button_full_width'] );
      }
      if ( isset( $data['button_radius'] )) {
        $settings['button_radius'] = 
          apply_filters( 'pre_term_name', $data['button_radius'] );
      }
      if ( isset( $data['button_icon_position'] )) {
        $settings['button_icon_position'] = 
          apply_filters( 'pre_term_name', $data['button_icon_position'] );
      }
      if ( isset( $data['button_icon'] )) {
        $settings['button_icon'] = 
          apply_filters( 'pre_term_name', $data['button_icon'] );
      }

      return $settings;
    }

    /**
     * Save action link settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingActionLink( $data )
    {
      $settings = array();

      if ( isset( $data['link_url'] )) {
        $settings['link_url'] = apply_filters( 'pre_link_url', $data['link_url'] );
      }
      if ( isset( $data['link_label'] )) {
        $settings['link_label'] = 
          apply_filters( 'single_post_title', $data['link_label'] );
      }
      if ( isset( $data['link_color'] )) {
        $settings['link_color'] = 
          apply_filters( 'single_post_title', $data['link_color'] );
      }
      if ( isset( $data['link_hover_color'] )) {
        $settings['link_hover_color'] = 
          apply_filters( 'single_post_title', $data['link_hover_color'] );
      }
      if ( isset( $data['link_font_family'] )) {
        $settings['link_font_family'] = 
          apply_filters( 'single_post_title', $data['link_font_family'] );
      }
      if ( isset( $data['link_font_size'] )) {
        $settings['link_font_size'] = absint( $data['link_font_size'] );
      }
      if ( isset( $data['link_underline'] )) {
        $settings['link_underline'] = 
          apply_filters( 'pre_term_name', $data['link_underline'] );
      }

      return $settings;
    }

    /**
     * Save action social settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingActionSocial( $data )
    {
      $settings = array();

      if ( isset( $data['social_facebook_url'] )) {
        $settings['social_facebook_url'] = 
          apply_filters( 'pre_link_url', $data['social_facebook_url'] );
      }
      if ( isset( $data['social_twitter_url'] )) {
        $settings['social_twitter_url'] = 
          apply_filters( 'pre_link_url', $data['social_twitter_url'] );
      }
      if ( isset( $data['social_googleplus_url'] )) {
        $settings['social_googleplus_url'] = 
          apply_filters( 'pre_link_url', $data['social_googleplus_url'] );
      }
      if ( isset( $data['social_linkedin_url'] )) {
        $settings['social_linkedin_url'] = 
          apply_filters( 'pre_link_url', $data['social_linkedin_url'] );
      }
      if ( isset( $data['social_youtube_url'] )) {
        $settings['social_youtube_url'] = 
          apply_filters( 'pre_link_url', $data['social_youtube_url'] );
      }
      if ( isset( $data['social_instagram_url'] )) {
        $settings['social_instagram_url'] = 
          apply_filters( 'pre_link_url', $data['social_instagram_url'] );
      }
      if ( isset( $data['social_pinterest_url'] )) {
        $settings['social_pinterest_url'] = 
          apply_filters( 'pre_link_url', $data['social_pinterest_url'] );
      }
      if ( isset( $data['social_tumblr_url'] )) {
        $settings['social_tumblr_url'] = 
          apply_filters( 'pre_link_url', $data['social_tumblr_url'] );
      }
      if ( isset( $data['social_button_style'] )) {
        $settings['social_button_style'] = 
          apply_filters( 'pre_term_name', $data['social_button_style'] );
      }

      return $settings;
    }

    /**
     * Save submission settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingSubmission( $data )
    {
      $settings = array();

      if ( isset( $data['list'] )) {
        $settings['list'] = absint( $data['list'] );
      }
      if ( isset( $data['submission_success'] )) {
        $settings['submission_success'] = 
          apply_filters( 'pre_term_name', $data['submission_success'] );
      }
      if ( isset( $data['submission_success_message'] )) {
        $settings['submission_success_message'] = 
          apply_filters( 'single_post_title', $data['submission_success_message'] );
      }
      if ( isset( $data['submission_success_close'] )) {
        $settings['submission_success_close'] = 
          apply_filters( 'pre_term_name', $data['submission_success_close'] );
      }
      if ( isset( $data['submission_success_redirect'] )) {
        $settings['submission_success_redirect'] = 
          apply_filters( 'pre_link_url', $data['submission_success_redirect'] );
      }
      if ( isset( $data['submission_failed_message'] )) {
        $settings['submission_failed_message'] = 
          apply_filters( 'single_post_title', $data['submission_failed_message'] );
      }

      return $settings;
    }

    /**
     * Save behaviour settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingBehaviour( $data )
    {
      $settings = array();

      //
      //Launch
      $launch   = $this->_saveSettingBehaviourLaunch( $data );
      $settings = array_merge( $settings, $launch );

      //
      //Page
      $page     = $this->_saveSettingBehaviourPage( $data );
      $settings = array_merge( $settings, $page );

      //
      //Repeat
      $repeat   = $this->_saveSettingBehaviourRepeat( $data );
      $settings = array_merge( $settings, $repeat );

      return $settings;
    }

    /**
     * Save behaviour launch settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingBehaviourLaunch( $data )
    {
      $settings = array();

      if ( isset( $data['first_show_type'] )) {
        $settings['first_show_type'] = 
          apply_filters( 'pre_term_name', $data['first_show_type'] );
      }
      if ( isset( $data['first_show_delay'] )) {
        $settings['first_show_delay'] = absint( $data['first_show_delay'] );
      }
      if ( isset( $data['show_exit_intent'] )) {
        $settings['show_exit_intent'] = 
          apply_filters( 'pre_term_name', $data['show_exit_intent'] );
      }
      if ( isset( $data['show_user_scroll'] )) {
        $settings['show_user_scroll'] = 
          apply_filters( 'pre_term_name', $data['show_user_scroll'] );
      }
      if ( isset( $data['show_user_scroll_id'] )) {
        $settings['show_user_scroll_id'] = 
          apply_filters( 'single_post_title', $data['show_user_scroll_id'] );
      }
      if ( isset( $data['show_user_scroll_height'] )) {
        $settings['show_user_scroll_height'] = absint( $data['show_user_scroll_height'] );
      }
      if ( isset( $data['show_user_inactive'] )) {
        $settings['show_user_inactive'] = 
          apply_filters( 'pre_term_name', $data['show_user_inactive'] );
      }
      if ( isset( $data['show_user_inactive_time'] )) {
        $settings['show_user_inactive_time'] = absint( $data['show_user_inactive_time'] );
      }

      return $settings;
    }

    /**
     * Save behaviour page settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingBehaviourPage( $data )
    {
      $settings = array();

      if ( isset( $data['enable_complete_site'] )) {
        $settings['enable_complete_site'] = 
          apply_filters( 'pre_term_name', $data['enable_complete_site'] );
      }
      if ( isset( $data['enable_post_type'] )) {
        $settings['enable_post_type'] = 
          apply_filters( 'pre_term_name', $data['enable_post_type'] );
      }

      return $settings;
    }

    /**
     * Save behaviour repeat settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingBehaviourRepeat( $data )
    {
      $settings = array();

      if ( isset( $data['enable_cookies'] )) {
        $settings['enable_cookies'] = 
          apply_filters( 'pre_term_name', $data['enable_cookies'] );
      }
      if ( isset( $data['repeat_conversion'] )) {
        $settings['repeat_conversion'] = absint( $data['repeat_conversion'] );
      }
      if ( isset( $data['repeat_closing'] )) {
        $settings['repeat_closing'] = absint( $data['repeat_closing'] );
      }

      return $settings;
    }

    /**
     * Save design settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingDesign( $data )
    {
      $settings = array();

      //
      //General
      $general  = $this->_saveSettingDesignGeneral( $data );
      $settings = array_merge( $settings, $general );
      //
      //Background
      $background = $this->_saveSettingDesignBackground( $data );
      $settings   = array_merge( $settings, $background );
      //
      //Background2
      $background = $this->_saveSettingDesignBackground2( $data );
      $settings   = array_merge( $settings, $background );
      //
      //Border
      $border   = $this->_saveSettingDesignBorder( $data );
      $settings = array_merge( $settings, $border );
      //
      //Text
      $text     = $this->_saveSettingDesignText( $data );
      $settings = array_merge( $settings, $text );
      //
      //Close
      $close    = $this->_saveSettingDesignClose( $data );
      $settings = array_merge( $settings, $close );

      return $settings;
    }

    /**
     * Save general design settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingDesignGeneral( $data )
    {
      $settings = array();

      //
      //Widget
      if ( isset( $data['box_padding'] )) {
        $settings['box_padding'] = absint( $data['box_padding'] );
      }
      if ( isset( $data['box_main_padding'] )) {
        $settings['box_main_padding'] = absint( $data['box_main_padding'] );
      }
      if ( isset( $data['box_secondary_padding'] )) {
        $settings['box_secondary_padding'] = absint( $data['box_secondary_padding'] );
      }
      if ( isset( $data['hide_on_mobile'] )) {
        $settings['hide_on_mobile'] = 
          apply_filters( 'pre_term_name', $data['hide_on_mobile'] );
      }

      return $settings;
    }

    /**
     * Save background design settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingDesignBackground( $data )
    {
      $settings = array();

      if ( isset( $data['box_background_color'] )) {
        $settings['box_background_color'] = 
          apply_filters( 'pre_term_name', $data['box_background_color'] );
      }
      if ( isset( $data['box_background_image'] )) {
        $settings['box_background_image'] = absint( $data['box_background_image'] );
      }
      if ( isset( $data['box_background_repeat'] )) {
        $settings['box_background_repeat'] = 
          apply_filters( 'pre_term_name', $data['box_background_repeat'] );
      }
      if ( isset( $data['box_background_opacity'] )) {
        $settings['box_background_opacity'] = absint( $data['box_background_opacity'] );
      }

      return $settings;
    }

    /**
     * Save background design settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingDesignBackground2( $data )
    {
      $settings = array();

      if ( isset( $data['box_main_background_color'] )) {
        $settings['box_main_background_color'] = 
          apply_filters( 'pre_term_name', $data['box_main_background_color'] );
      }
      if ( isset( $data['box_main_background_image'] )) {
        $settings['box_main_background_image'] = absint( $data['box_main_background_image'] );
      }
      if ( isset( $data['box_main_background_repeat'] )) {
        $settings['box_main_background_repeat'] = 
          apply_filters( 'pre_term_name', $data['box_main_background_repeat'] );
      }
      if ( isset( $data['box_main_background_opacity'] )) {
        $settings['box_main_background_opacity'] = absint( $data['box_main_background_opacity'] );
      }

      if ( isset( $data['box_secondary_background_color'] )) {
        $settings['box_secondary_background_color'] = 
          apply_filters( 'pre_term_name', $data['box_secondary_background_color'] );
      }
      if ( isset( $data['box_secondary_background_image'] )) {
        $settings['box_secondary_background_image'] = absint( $data['box_secondary_background_image'] );
      }
      if ( isset( $data['box_secondary_background_repeat'] )) {
        $settings['box_secondary_background_repeat'] = 
          apply_filters( 'pre_term_name', $data['box_secondary_background_repeat'] );
      }
      if ( isset( $data['box_secondary_background_opacity'] )) {
        $settings['box_secondary_background_opacity'] = absint( $data['box_secondary_background_opacity'] );
      }

      return $settings;
    }

    /**
     * Save border design settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingDesignBorder( $data )
    {
      $settings = array();

      if ( isset( $data['box_border_size'] )) {
        $settings['box_border_size'] = absint( $data['box_border_size'] );
      }
      if ( isset( $data['box_border_style'] )) {
        $settings['box_border_style'] = 
          apply_filters( 'pre_term_name', $data['box_border_style'] );
      }
      if ( isset( $data['box_border_color'] )) {
        $settings['box_border_color'] = 
          apply_filters( 'pre_term_name', $data['box_border_color'] );
      }
      if ( isset( $data['box_border_radius'] )) {
        $settings['box_border_radius'] = 
          apply_filters( 'pre_term_name', $data['box_border_radius'] );
      }

      return $settings;
    }

    /**
     * Save text design settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingDesignText( $data )
    {
      $settings = array();

      if ( isset( $data['box_title_color'] )) {
        $settings['box_title_color'] = 
          apply_filters( 'pre_term_name', $data['box_title_color'] );
      }
      if ( isset( $data['box_title_size'] )) {
        $settings['box_title_size'] = absint( $data['box_title_size'] );
      }
      if ( isset( $data['box_title_font'] )) {
        $settings['box_title_font'] = 
          apply_filters( 'pre_term_name', $data['box_title_font'] );
      }
      if ( isset( $data['box_title_shadow'] )) {
        $settings['box_title_shadow'] = 
          apply_filters( 'pre_term_name', $data['box_title_shadow'] );
      }

      if ( isset( $data['box_info_color'] )) {
        $settings['box_info_color'] = 
          apply_filters( 'pre_term_name', $data['box_info_color'] );
      }
      if ( isset( $data['box_info_size'] )) {
        $settings['box_info_size'] = absint( $data['box_info_size'] );
      }
      if ( isset( $data['box_info_font'] )) {
        $settings['box_info_font'] = 
          apply_filters( 'pre_term_name', $data['box_info_font'] );
      }
      if ( isset( $data['box_info_shadow'] )) {
        $settings['box_info_shadow'] = 
          apply_filters( 'pre_term_name', $data['box_info_shadow'] );
      }

      return $settings;
    }

    /**
     * Save close design settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingDesignClose( $data )
    {
      $settings = array();

      if ( isset( $data['close_button'] )) {
        $settings['close_button'] = 
          apply_filters( 'pre_term_name', $data['close_button'] );
      }
      if ( isset( $data['close_bgcolor'] )) {
        $settings['close_bgcolor'] = 
          apply_filters( 'pre_term_name', $data['close_bgcolor'] );
      }
      if ( isset( $data['close_color'] )) {
        $settings['close_color'] = 
          apply_filters( 'pre_term_name', $data['close_color'] );
      }
      if ( isset( $data['close_border_color'] )) {
        $settings['close_border_color'] = 
          apply_filters( 'pre_term_name', $data['close_border_color'] );
      }
      if ( isset( $data['close_border_width'] )) {
        $settings['close_border_width'] = absint( $data['close_border_width'] );
      }

      return $settings;
    }

    /**
     * Save effect settings
     *
     * @param  array $data
     * @return array
     */
    protected function _saveSettingEffect( $data )
    {
      $settings = array();
      if ( isset( $data['show_effect'] )) {
        $settings['show_effect'] = apply_filters( 'pre_term_name', $data['show_effect'] );
      }
      if ( isset( $data['show_effect_speed'] )) {
        $settings['show_effect_speed'] = absint( $data['show_effect_speed'] );
      }
      if ( isset( $data['hide_effect'] )) {
        $settings['hide_effect'] = apply_filters( 'pre_term_name', $data['hide_effect'] );
      }
      if ( isset( $data['hide_effect_speed'] )) {
        $settings['hide_effect_speed'] = absint( $data['hide_effect_speed'] );
      }
      if ( isset( $data['show_audio'] )) {
        $settings['show_audio'] = apply_filters( 'pre_term_name', $data['show_audio'] );
      }
      if ( isset( $data['hide_audio'] )) {
        $settings['hide_audio'] = apply_filters( 'pre_term_name', $data['hide_audio'] );
      }
      if ( isset( $data['disabled_animation_mobile'] )) {
        $settings['disabled_animation_mobile'] = apply_filters( 
          'pre_term_name', $data['disabled_animation_mobile'] 
        );
      }

      return $settings;
    }
  }
}