<?php
/**
 * Controller to handling updating page process
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPJck_Ajax_Update_page' ))
{
	class IPJck_Ajax_Update_page
	{
		/**
		 * Execution save options process
		 *
		 * @return void
		 */
		public function exec()
		{
			$redirect = false;
			$is_add   = false;
			$error    = true;
			if ( ! empty( $_POST['isadd'] )) {
					$is_add = true;
			}
			if ( ! empty( $_POST['page_id'] )) {
					$pageId = absint( $_POST['page_id'] );
					if ( $page = get_post( $pageId ) ) {
							$this->_updatePage( $page );
					} else {
							$pageId = 0;
					}
			} else {
					$pageId = $this->_addPage();
			}
			if ( $pageId )
			{
					$error = false;
					$model = new IPJck_Model_Page();
					$model->saveSetting( $pageId );
			}
			if ( $error ) {
					$status   = 0;
					$pageId  = 0;
					if ( $is_add ) {
							$message = __( 'Failed create page.', IPJCK_SLUG );
					} else {
							$message = __( 'Failed save page.', IPJCK_SLUG );
					}
			} else {
					$status = 1;
					if ( $is_add ) {
							$message  = __( 'Successfully created page.', IPJCK_SLUG );
							$redirect = admin_url() . 'admin.php?page=' . IPJCK_PAGENAME . '-page&action=edit&id=' . $pageId . '&create=1';
					} else {
							$message  = __( 'Successfully saved page.', IPJCK_SLUG );
					}
			}

			$result = array(
					'status'    		=> $status,
					'message'   		=> $message,
					'pageid'  			=> $pageId
			);
			if ( $redirect ) {
					$result['redirect'] = $redirect;
			}
			echo json_encode( $result );
			die();
		}

		/**
		 * Add new page
		 *
		 * @return int
		 */
		protected function _addPage()
		{
			global $user_ID;

			if ( empty( $_POST['title'] )) {
					$title = 'Unknown';
			} else {
					$title = apply_filters( 'single_post_title', $_POST['title'] );
			}

			if ( empty( $_POST['slug'] )) {
					$slug = $title;
			} else {
					$slug = apply_filters( 'single_post_title', $_POST['slug'] );
			}
			$slug = sanitize_title( $slug );
			$slug = wp_unique_post_slug( $slug, 0, 1, 'ipjck_page', 0 );

			$dataPost = array(
				'post_status'  => 'publish',
				'post_type'    => 'ipjck_page',
				'post_author'  => $user_ID,
				'post_title'   => $title,
				'post_name'    => $slug,
				'post_content' => ''
			);
			$result = wp_insert_post( $dataPost );
			return $result;
		}

		/**
		 * Update page
		 *
		 * @param  object $page
		 * @return boolean
		 */
		protected function _updatePage( $page )
		{
			$result   = 0;
			$dataPost = array();
			if ( ! empty( $_POST['title'] ) && $_POST['title'] != $page->post_title ) {
				$dataPost['post_title'] = apply_filters( 'single_post_title', $_POST['title'] );
			}
			if ( ! empty( $_POST['slug'] ) && $_POST['slug'] != $page->post_name ) 
			{
				$slug = apply_filters( 'single_post_title', $_POST['slug'] );
				$slug = sanitize_title( $slug );
				$slug = wp_unique_post_slug( $slug, 0, 1, 'ipjck_page', 0 );
				$dataPost['post_name'] = $slug;
			}
			if ( ! empty( $dataPost )) {
				$dataPost['ID'] = $page->ID;
				$result = wp_update_post( $dataPost );
			}
			return $result;
		}
	}
}
