<?php
/**
 * Controller to handling deleting page process
 *
 * @package wp-viral-click
 * @author InstaProduct
 * @link http://insta-product.com/
 */

if ( ! class_exists( 'IPJck_Ajax_Delete_page' ))
{
  class IPJck_Ajax_Delete_page
  {
    /**
     * Execution save options process
     *
     * @return void
     */
    public function exec()
    {
      $item = false;
      if ( ! empty( $_REQUEST['id'] )) {
        $id   = absint( $_REQUEST['id'] );
        $item = get_post( $id );
      }
      if ( ! $item ) {
        echo json_encode( array(
          'status'   => 0,
          'message'  => __( 'Error system', IPJCK_SLUG )
        ) );
        die();
      }
      $result = wp_delete_post( $item->ID, true );
      if ( $result ) {
        echo json_encode( array(
          'status'   => 1,
          'message'  => __( 'Page successfully deleted', IPJCK_SLUG ),
          'redirect' => admin_url() . 'admin.php?page=' . IPJCK_PAGENAME . '-page&delete=1'
        ) );
      } else {
        echo json_encode( array(
          'status'  => 0,
          'message' => __( 'Failed to remove the page', IPJCK_SLUG )
        ) );
      }
      die();
    }
  }
}
