<?php

add_shortcode( 'pm-vidroll', 'pm_vidrolls_display_vidroll_shortcode' );
add_shortcode( 'pm-vidrolls-yt-vid', 'pm_vidrolls_youtube_video_shortcode' );
add_shortcode( 'pm-vidrolls-btn', 'pm_vidrolls_button_shortcode' );

/*
	* ShortCode
	* pm_vidrolls
	* pm_vidrolls_youtube_video_shortcode
	* Display Youtube link Shortcode
*/

function pm_vidrolls_youtube_video_shortcode( $atts ) {
	global $wpdb;
	$output = '';
	
	$vid = (isset($atts['vid']) ? $atts['vid'] : '');
	$width = (isset($atts['width']) ? $atts['width'] : '480');
	$height = (isset($atts['height']) ? $atts['height'] : '360');
	$autoplay = (isset($atts['autoplay']) ? 1 : 0);
	
	if( !empty($vid) ):
		$output .= "<div class='pm_video_wrapper' data-vid='{$vid}' data-autoplay='{$autoplay}'>";
			$output .= "<div id='pmvidroll_{$vid}' class='videos' data-yid='{$vid}' data-width='{$width}' data-height='{$height}' data-autoplay='{$autoplay}'></div>";
		$output .= "</div>";
	else:
		$output .= "<p>".esc_html(__('VideoID not specified', 'pm-vidrolls'))."</p>";
	endif;
	
	
	return $output;
}

/*
	* ShortCode
	* pm_vidrolls
	* pm_vidrolls_display_vidroll_shortcode
	* Display VideoRoll Shortcode
*/

function pm_vidrolls_display_vidroll_shortcode( $atts ) {
	$options = get_option(PM_VIDROLLS_SETTINGS_OPTION, array());
	$fade_duration = ($options['settings']['fade_duration'] > 0 ? $options['settings']['fade_duration'] * 1000 : 0);
	wp_enqueue_script( 'pm-vidrolls-yt-api', 'http://www.youtube.com/player_api', array('jquery'), PM_VIDROLLS_VERSION, true );
	wp_enqueue_script( 'pm-vidrolls-fe-script', PM_VIDROLLS_DIR.'modules/frontend/js/pm-vidrolls-fe.js', array('jquery'), PM_VIDROLLS_VERSION, true );
	wp_localize_script( 'pm-vidrolls-fe-script', 'pmVidRollData', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ), 'fade_time' => $fade_duration));
	global $wpdb;
	$output = '';
	
	$post_id = (isset($atts['pid']) ? $atts['pid'] : '');
	
	$pre_status = false;
	$pre_key = (isset($atts['pre_key']) ? esc_html($atts['pre_key']) : '');
	$pre_value = (isset($atts['pre_value']) ? esc_html($atts['pre_value']) : '');
	$pre_get_key = false;
	$pre_get_value = false;
	if( !empty($pre_key) && !empty($pre_value)) {
		$pre_get_key = (isset($_GET[$pre_key]) ? true : false );
		
		if( $pre_get_key ) {
			$pre_get_value = ($_GET[$pre_key] == $pre_value ? true : false);
		}
	}
	
	$pre_status = ($pre_get_key && $pre_get_value ? true : false);
	
	
	
	if( !empty($post_id) ):
		
		$content_pre_status = get_post_meta($post_id, '_pm_vidrolls_content_pre_roll_status', true);
		$content_post_status = get_post_meta($post_id, '_pm_vidrolls_content_post_roll_status', true);
		$initial_screen = ($content_pre_status == 1 ? true : false);
		$content_pre_active = ($initial_screen ? 'initial' : '');
		$content_main_active = (!$initial_screen ? 'initial' : '');
		
		
		$content_pre = get_post_meta($post_id, '_pm_vidrolls_content_pre_textarea', true);
		$content_main = get_post_meta($post_id, '_pm_vidrolls_content_main_textarea', true);
		$content_post = get_post_meta($post_id, '_pm_vidrolls_content_post_textarea', true);
		
		$content_pre_visibility = ($pre_status ? 'display: none;' : 'display: block;');
		$content_main_visibility = ($content_pre_status == 1 ? 'display: none;' : 'display: block;');
		$content_main_visibility = ($pre_status ? 'display: block;' : $content_main_visibility);		
		
		$output .= "<div id='pm_vidroll_main_wrapper_{$post_id}' class='pm_vidroll_main_wrapper'>";

			if( $content_pre_status == 1 ) {
				$output .= "<div class='pm_vidroll_wrapper pm_vidroll_wrapper_pre {$content_pre_active}' data-type='pre' style='{$content_pre_visibility}'>";
					$output .= apply_filters('the_content', $content_pre);
				$output .= "</div>";
			}
			$output .= "<div class='pm_vidroll_wrapper pm_vidroll_wrapper_main {$content_main_active}' data-type='main' style='{$content_main_visibility}'>";
				$output .= apply_filters('the_content', $content_main);
			$output .= "</div>";
			
			if( $content_post_status == 1 ) {
				$output .= "<div class='pm_vidroll_wrapper pm_vidroll_wrapper_post' data-type='post' style='display: none;'>";
					$output .= apply_filters('the_content', $content_post);
				$output .= "</div>";
			}
		$output .= "</div>";
	else:
		$output .= "<p>".esc_html(__('Please specify a post-id of vidroll you want to display.', 'pm-vidrolls'))."</p>";
	endif;
	
	
	return $output;
}

/*
	* ShortCode
	* pm_vidrolls
	* pm_vidrolls_button_shortcode
	* Display a Button that triggers to next Video
*/

function pm_vidrolls_button_shortcode( $atts ) {
	global $wpdb;
	$output = '';
	
	$btn_text = (isset($atts['text']) ? $atts['text'] : esc_html(__('Continue', 'pm-vidrolls')));
	$btn_class = (isset($atts['class']) ? $atts['class'] : '');
	
	$output .= "<a class='pm-vidrolls-btn {$btn_class}' href='#next' title='{$btn_text}'>{$btn_text}</a>";	
	
	return $output;
}




