<?php 
/*
	* pm_vidrolls_adminscripts
	* Enq Scripts and StyleSheets
	* FontAwesome: //maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css

*/

function pm_vidrolls_register_settings() {
	add_submenu_page( 'edit.php?post_type=pmvidrolls', esc_html(__( 'Settings', 'pm-vidrolls')), esc_html(__( 'Settings', 'pm-vidrolls' )), 'manage_options', 'pm_vidrolls_settings', 'pm_vidrolls_settings_page');
	add_action( 'admin_init', 'pm_vidrolls_settings_register_callback' );
}
add_action( 'admin_menu', 'pm_vidrolls_register_settings' );

/*
	* pm_vidrolls_settings_register_callback
*/

function pm_vidrolls_settings_register_callback() {
	//register our settings
	register_setting( 'pm-vidrolls-settings-group', PM_VIDROLLS_SETTINGS_OPTION, 'pm_vidrolls_settings_validate');
}

/*
	* pm_vidrolls_settings_validate
*/

function pm_vidrolls_settings_validate($input) {
	$array = array();
	foreach($input as $key => $values) {
		if(is_array($input[$key])) {
			//$input[$key] = array_filter($input[$key]);
			if($input[$key]) {
				//$values = array_filter($values);
				if(is_array($values)){
					foreach($values as $vkey => $value) {
						$array[$key][$vkey] = wp_strip_all_tags($value,true);
					}
				}
			}
			
		}
	}
	return $array;
}

/*
	* pm_vidrolls_settings_page
	* Settings Page for pm_vidrolls_settings_page
*/


function pm_vidrolls_settings_page() {
	$setting_fields = pm_vidrolls_setting_fields();
	wp_enqueue_style( 'pm-font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.6.3/css/font-awesome.min.css', '', PM_VIDROLLS_VERSION, 'all' );
	wp_enqueue_style( 'pm-bootstrap', 'https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css', '', PM_VIDROLLS_VERSION, 'all' );
	$options = get_option(PM_VIDROLLS_SETTINGS_OPTION, array());
	?>
	<div id="content_auditor_settings" class="wrap">
		<form method="post" class="form-horizontal pm_vidrolls_form" action="options.php"> 
			<?php settings_fields( 'pm-vidrolls-settings-group' ); ?>
			<?php do_settings_sections( 'pm-vidrolls-settings-group' ); ?>
			<?php 
			foreach($setting_fields as $skey =>  $fields): 
			?>
			<div>
				<h3><?php print $fields['name']; ?></h3>
				<p class="description"><?php print $fields['general_description']; ?></p>
				<div>
					<?php foreach($fields['fields'] as $fkey => $field): 
					$default_value = $setting_fields[$skey]['fields'][$field['name']]['default'];
					$option = (isset($options[$skey][$fkey]) ? $options[$skey][$fkey] : $default_value);
					$is_checkbox = ($field['type'] == 'checkbox' ? true : false);
					$checked = '';
					if( $is_checkbox && isset($options[$skey][$fkey])) {
						$checked = 'checked';
					}
					?>
					<?php if($is_checkbox): ?>
						<div class="form-group checkbox">
							<div class="col-sm-offset-1 col-sm-10">
							<div class="checkbox">
								<label for="<?php print pm_vidrolls_set_field('id',$skey,$field['name']); ?>"><input <?php print $checked; ?> type="<?php print pm_vidrolls_set_field('type',$skey,$field['name']); ?>" name="<?php print pm_vidrolls_set_field('name',$skey,$field['name']); ?>" id="<?php print pm_vidrolls_set_field('id',$skey,$field['name']); ?>" value="<?php print $option; ?>" class="form-control fb_hcs_setting_field" style="margin-top: 1px;" /> <?php print $field['label']; ?></label>
								<p class="description"><?php print pm_vidrolls_set_field('description',$skey,$field['name']); ?></p>
							</div>
							
							</div>
						</div>
					<?php else: ?>
						<div class="form-group">
							<label class="control-label col-sm-1" for="<?php print pm_vidrolls_set_field('id',$skey,$field['name']); ?>"><?php print $field['label']; ?></label>
							<div class="col-sm-10">
								<input <?php print $checked; ?> type="<?php print pm_vidrolls_set_field('type',$skey,$field['name']); ?>" name="<?php print pm_vidrolls_set_field('name',$skey,$field['name']); ?>" id="<?php print pm_vidrolls_set_field('id',$skey,$field['name']); ?>" maxlength="<?php print pm_vidrolls_set_field('limit',$skey,$field['name']); ?>" value="<?php print $option; ?>" class="form-control fb_hcs_setting_field" />
								<p class="description"><?php print pm_vidrolls_set_field('description',$skey,$field['name']); ?></p>
							</div>
						</div>
					<?php endif; ?>
					<?php endforeach; ?>
				</div>
			</div>
			<?php endforeach; ?>
			<?php submit_button( esc_html(__('Save Settings', 'pm-vidrolls')), 'secondary', 'pm_vidrolls_save', false, array('id' => 'pm_vidrolls_save') ); ?>
		</form>
	</div>
	<?php
}