<?php 
add_action( 'add_meta_boxes', 'pm_vidrolls_add_custom_box' );
function pm_vidrolls_add_custom_box() {
	add_meta_box(
		'pm_vidrolls_mbox',
		__( PM_VIDROLLS_PLUGIN_NAME.' Settings' , 'pm-vidrolls' ),
		'pm_vidrolls_inner_custom_box',
		'pmvidrolls', 'normal' , 'core'
	);
}

function pm_vidrolls_inner_custom_box( $post ) {
	wp_enqueue_style( 'pm-vidrolls-style', PM_VIDROLLS_DIR.'modules/css/pm-vidrolls.css', '', PM_VIDROLLS_VERSION, 'all' );
	wp_nonce_field( plugin_basename( __FILE__ ), 'pm_vidrolls_noncename' );
	
	$editor_settings = array(
		'quicktags' => true,
		'textarea_rows' => 12
	);
	$content_pre_status = get_post_meta($post->ID, '_pm_vidrolls_content_pre_roll_status', true);
	$content_post_status = get_post_meta($post->ID, '_pm_vidrolls_content_post_roll_status', true);
	$content_pre_status_checked = ($content_pre_status == 1 ? 'checked' : '' );
	$content_post_status_checked = ($content_post_status == 1 ? 'checked' : '' );
	
	
	$content_pre = get_post_meta($post->ID, '_pm_vidrolls_content_pre_textarea', true);
	$content_main = get_post_meta($post->ID, '_pm_vidrolls_content_main_textarea', true);
	$content_post = get_post_meta($post->ID, '_pm_vidrolls_content_post_textarea', true);
	
	?>
	<div id="pmvidrolls_post_meta">
		<div class="pm_vidrolls_field editor_wrapper">
			<h3><?php esc_html(_e( 'VidRoll Pre Roll Content' , 'pm-vidrolls' )); ?></h3>
			<div class="checkbox">
				<label class="checkbox">
					<input name="_pm_vidrolls_content_pre_roll_status" type="checkbox" value="1" <?php print $content_pre_status_checked; ?>/>
					<?php esc_html(_e( 'Check to enable pre-roll' , 'pm-vidrolls' )); ?>
				</label>
			</div>
			<div class="vidrollwysiwyg" style="<?php print ($content_pre_status == 1 ? 'display: block; ' : 'display: none; '); ?>">
			<?php wp_editor( $content_pre, '_pm_vidrolls_content_pre_textarea', $editor_settings ); ?>
			</div>
		</div>
		<hr />
		<div class="pm_vidrolls_field editor_wrapper">
			<h3><?php esc_html(_e( 'VidRoll Main Roll Content' , 'pm-vidrolls' )); ?></h3>
			<div class="vidrollwysiwyg">
			<?php wp_editor( $content_main, '_pm_vidrolls_content_main_textarea', $editor_settings ); ?>
			</div>
		</div>	
		<hr />
		<div class="pm_vidrolls_field editor_wrapper">
			<h3><?php esc_html(_e( 'VidRoll Post Roll Content' , 'pm-vidrolls' )); ?></h3>
			<div class="checkbox">
				<label class="checkbox">
					<input name="_pm_vidrolls_content_post_roll_status" type="checkbox" value="1" <?php print $content_post_status_checked; ?> />
					<?php esc_html(_e( 'Check to enable post-roll' , 'pm-vidrolls' )); ?>
				</label>
			</div>
			<div class="vidrollwysiwyg" style="<?php print ($content_post_status == 1 ? 'display: block; ' : 'display: none; '); ?>">
			<?php wp_editor( $content_post, '_pm_vidrolls_content_post_textarea', $editor_settings ); ?>
			</div>	
		</div>	
	</div>
	<script>
	(function($) {
		jQuery('#pmvidrolls_post_meta .checkbox input').click(function() {
			if(jQuery(this).prop("checked") == true){
				jQuery(this).closest('div.pm_vidrolls_field').find('div.vidrollwysiwyg').show();
			}
			else if(jQuery(this).prop("checked") == false){
				jQuery(this).closest('div.pm_vidrolls_field').find('div.vidrollwysiwyg').hide();
			}
		});
	})(jQuery);
	</script>
	
	<?php
}

add_action( 'save_post', 'pm_vidrolls_save_postdata' );
function pm_vidrolls_save_postdata( $post_id ) {

	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
	  return;
	if ( !empty( $_POST['pm_vidrolls_noncename'] ) && !wp_verify_nonce( $_POST['pm_vidrolls_noncename'], plugin_basename( __FILE__ ) ) )
	  return;
	if ( !empty($_POST['post_type']) && 'pmvidrolls' == $_POST['post_type'] ) 
	{
	if ( !current_user_can( 'edit_page', $post_id ) )
		return;
	}
	else
	{
	if ( !current_user_can( 'edit_post', $post_id ) )
		return;
	}
	if(isset($_POST['_pm_vidrolls_content_pre_textarea']) && !empty($_POST['_pm_vidrolls_content_pre_textarea']) ) {
		update_post_meta( $post_id, '_pm_vidrolls_content_pre_textarea', $_POST['_pm_vidrolls_content_pre_textarea']);
	}
	if(isset($_POST['_pm_vidrolls_content_main_textarea']) && !empty($_POST['_pm_vidrolls_content_main_textarea']) ) {
		update_post_meta( $post_id, '_pm_vidrolls_content_main_textarea', $_POST['_pm_vidrolls_content_main_textarea']);
	}
	if(isset($_POST['_pm_vidrolls_content_post_textarea']) && !empty($_POST['_pm_vidrolls_content_post_textarea']) ) {
		update_post_meta( $post_id, '_pm_vidrolls_content_post_textarea', $_POST['_pm_vidrolls_content_post_textarea']);
	}
	
	if(isset($_POST['_pm_vidrolls_content_pre_roll_status']) && !empty($_POST['_pm_vidrolls_content_pre_roll_status']) ) {
		update_post_meta( $post_id, '_pm_vidrolls_content_pre_roll_status', $_POST['_pm_vidrolls_content_pre_roll_status']);
	}  else {
		update_post_meta( $post_id, '_pm_vidrolls_content_pre_roll_status', 0);
	}
	
	if(isset($_POST['_pm_vidrolls_content_post_roll_status']) && !empty($_POST['_pm_vidrolls_content_post_roll_status']) ) {
		update_post_meta( $post_id, '_pm_vidrolls_content_post_roll_status', $_POST['_pm_vidrolls_content_post_roll_status']);
	}  else {
		update_post_meta( $post_id, '_pm_vidrolls_content_post_roll_status', 0);
	}

}

?>