<?php
//pm_vidrolls
/*
	* functions.php
*/
add_action( 'plugins_loaded', 'pm_vidrolls_load_textdomain' );
function pm_vidrolls_load_textdomain() {
    load_plugin_textdomain( 'pm-vidrolls', false, dirname( plugin_basename( __DIR__ ) ) . '/languages' );
}

/**
 * Flush rewrite rules for custom post type archive on single activation
 *
 * @since    0.0.1
 */
function pm_vidrolls_install() {
	pm_vidrolls_post_type_init();
	flush_rewrite_rules();
}

/*
	* pm_vidrolls_deactivate
*/

function pm_vidrolls_deactivate() {

}

/**
 * Register a post type.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_post_type
 */
add_action( 'init', 'pm_vidrolls_post_type_init' );
function pm_vidrolls_post_type_init() {
	$labels_pmvidrolls = array(
		'name'               => _x( 'VidRolls', 'post type general name', 'pm-vidrolls' ),
		'singular_name'      => _x( 'VidRoll', 'post type singular name', 'pm-vidrolls' ),
		'menu_name'          => _x( 'VidRolls', 'admin menu', 'pm-vidrolls' ),
		'name_admin_bar'     => _x( 'VidRoll', 'add new on admin bar', 'pm-vidrolls' ),
		'add_new'            => _x( 'Add VidRoll', 'VidRoll', 'pm-vidrolls' ),
		'add_new_item'       => __( 'Add New VidRoll', 'pm-vidrolls' ),
		'new_item'           => __( 'New VidRoll', 'pm-vidrolls' ),
		'edit_item'          => __( 'Edit VidRoll', 'pm-vidrolls' ),
		'view_item'          => __( 'View VidRoll', 'pm-vidrolls' ),
		'all_items'          => __( 'All VidRolls', 'pm-vidrolls' ),
		'search_items'       => __( 'Search VidRolls', 'pm-vidrolls' ),
		'parent_item_colon'  => __( 'Parent VidRolls:', 'pm-vidrolls' ),
		'not_found'          => __( 'No VidRolls found.', 'pm-vidrolls' ),
		'not_found_in_trash' => __( 'No VidRolls found in Trash.', 'pm-vidrolls' )
	);

	$args_pmvidrolls = array(
		'labels'             => $labels_pmvidrolls,
		'public'             => false,
		'publicly_queryable' => false,
		'exclude_from_search' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => false,
		'menu_icon'	=>	'dashicons-admin-links',
		'capability_type'    => 'post',
		'has_archive'        => false,
		'hierarchical'       => false,
		'menu_position'      => 110,
		'supports'           => array('title'),
		'map_meta_cap' => true
	);

	register_post_type( 'pmvidrolls', $args_pmvidrolls );	
}

/*
	* get current URL
*/
function pm_vidrolls_get_current_url() {
	$curpageURL = 'http';
	if (isset($_SERVER["HTTPS"])) {
		$curpageURL.= "s";
	}
	$curpageURL.= "://";
	if ($_SERVER["SERVER_PORT"] != "80") {
		$curpageURL.= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
	} 
	else {
		$curpageURL.= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
	}
	return $curpageURL;
}

add_filter('the_content', 'remove_empty_p', 20, 1);
function remove_empty_p($content){
    $content = force_balance_tags($content);
    return preg_replace('#<p>\s*+(<br\s*/*>)?\s*</p>#i', '', $content);
}

if( !function_exists('pm_ppp') ) {
	function pm_ppp($var) {
		print '<pre>';
		if(is_array($var)) {
			print_r($var);	
		} else {
			print $var;
		}
		
		print '</pre>';
	}
}

/**
	* Add Table heads for Vidrolls Shortcode
*/

add_filter('manage_pmvidrolls_posts_columns', 'pm_vidrolls_pmvidrolls_table_head');
add_action( 'manage_pmvidrolls_posts_custom_column', 'pm_vidrolls_pmvidrolls_table_content', 10, 2 );

function pm_vidrolls_pmvidrolls_table_head($defaults) {

	$defaults['pm_vidrolls_shortcode'] = __('Shortcode', 'pm-vidrolls');
    return $defaults;
}

function pm_vidrolls_pmvidrolls_table_content( $column_name, $post_id ) {
	
	if ($column_name == 'pm_vidrolls_shortcode') {
		print "[pm-vidroll pid='{$post_id}']";
    }
	
}

/*
	* pm_vidrolls_settings_fields
	* Fields for Settings
*/
function pm_vidrolls_setting_fields(){
	$fields = array(
	'settings' => array(
		'name' => __( 'Settings Page', 'pm-vidrolls' ),
		'general_description' => __( 'Change settings here.', 'pm-vidrolls' ),
		'fields' => array(
			'fade_duration' => array(
				'name' => 'fade_duration',
				'description' => __( 'Enter the Fade Duration between transition in seconds', 'pm-vidrolls' ),
				'field' => 'input',
				'type' => 'text',
				'label' => __( 'Vidroll Transition', 'pm-vidrolls' ),
				'default' => '1.5',
				'limit' => '4',
				'repeatable' => false,
				'show_add' => false,
				'required' => true
			)
		)
	),
	);
	
	return $fields;
}

/*
	* pm_vidrolls_set_field
	* Fields for Settings
*/
function pm_vidrolls_set_field($attr,$type,$opt){
	$output = '';
	$values = pm_vidrolls_setting_fields();
	if($attr == 'name') {
		$output = PM_VIDROLLS_SETTINGS_OPTION . "[{$type}]" . "[{$opt}]";
	} elseif($attr == 'id') {
		$output = PM_VIDROLLS_SETTINGS_OPTION . "_{$type}" . "_{$opt}";
	} else {
		$output = $values[$type]['fields'][$opt][$attr];
	}
	return $output;
}

?>
