Scriptname AtlasPlayerAliasScript extends ReferenceAlias  

FormList Property USKPFixList Auto
FormList Property MineList Auto
GlobalVariable Property ATLASGroupMineGV Auto
int ModPosition = 255
bool USKPFixesIncluded
bool USKPFixesRemoved
AtlasMCMScript property ATLAS_MCMQuest auto


event OnPlayerLoadGame()
	(GetOwningQuest() as SKI_QuestBase).OnGameReload()
	RunModCheck()
	ATLAS_MCMQuest.Maintenance()
endEvent

function RunModCheck()
	ModPosition = Game.GetModByName("Unofficial Skyrim Patch.esp")
	if ModPosition != 255			;USKP is installed
		if !USKPFixesIncluded
			ApplyUSKPPatch(2)
		endif
	else							;USKP is NOT installed
		if !USKPFixesRemoved		
			ApplyUSKPPatch(1)
		endif
	endif	
EndFunction


;if the user does not use the USKP, this fixes the ore names and enables the marker for The Chill.
Function ApplyUSKPPatch(Int MenuChoice) 
	ObjectReference MapMarker0 = USKPFixList.GetAt(0) As ObjectReference ;NW Ebony, patched	
	ObjectReference MapMarker1 = USKPFixList.GetAt(1) As ObjectReference ;RB Iron, patched
	ObjectReference MapMarker2 = USKPFixList.GetAt(2) As ObjectReference ;NW Iron, van default
	ObjectReference MapMarker3 = USKPFixList.GetAt(3) As ObjectReference ;RB Ebony, van default
	ObjectReference MapMarker4 = USKPFixList.GetAt(4) As ObjectReference ;The Chill, default
	If MenuChoice == 1 
		MineList.Revert()
		MineList.AddForm(MapMarker2)
		MineList.AddForm(MapMarker3)		
		MapMarker0.Disable()
		MapMarker1.Disable()
		if ATLASGroupMineGV.GetValue() == 0				;no markers 
			MapMarker2.Disable()
			MapMarker3.Disable()
		ElseIf ATLASGroupMineGV.GetValue() == 1			;add default
			MapMarker2.Enable()
			MapMarker3.Enable()	
		ElseIf ATLASGroupMineGV.GetValue() == 2			;add undiscovered, no fast travel
			MapMarker2.Enable()
			MapMarker3.Enable()	
			MapMarker2.AddToMap(False)	
			MapMarker3.AddToMap(False)			
		ElseIf ATLASGroupMineGV.GetValue() == 3			;add discovered with fast travel enabled
			MapMarker2.Enable()
			MapMarker3.Enable()	
			MapMarker2.AddToMap(True) 						
			MapMarker3.AddToMap(True) 				
		endif
		MapMarker4.Enable()
		USKPFixesIncluded = false
		USKPFixesRemoved = true
		Debug.Notification("USKP fixes removed.")
	ElseIf MenuChoice == 2 								; mod assumes they use the USKP by default
		MineList.Revert()
		MineList.AddForm(MapMarker0)
		MineList.AddForm(MapMarker1)	
		MapMarker2.Disable()
		MapMarker3.Disable()
		if ATLASGroupMineGV.GetValue() == 0				;no markers 
			MapMarker0.Disable()
			MapMarker1.Disable()
		ElseIf ATLASGroupMineGV.GetValue() == 1			;add default
			MapMarker0.Enable()
			MapMarker1.Enable()	
		ElseIf ATLASGroupMineGV.GetValue() == 2			;add undiscovered, no fast travel
			MapMarker0.Enable()
			MapMarker1.Enable()	
			MapMarker0.AddToMap(False)	
			MapMarker1.AddToMap(False)			
		ElseIf ATLASGroupMineGV.GetValue() == 3			;add discovered with fast travel enabled
			MapMarker0.Enable()
			MapMarker1.Enable()	
			MapMarker0.AddToMap(True) 						
			MapMarker1.AddToMap(True) 				
		endif
		MapMarker4.Disable()
		USKPFixesIncluded = true
		USKPFixesRemoved = false
		Debug.Notification("USKP fixes applied.")
	EndIf
EndFunction