Scriptname AtlasMCMScript extends SKI_ConfigBase

FormList Property MasterList Auto
import FISSFactory
int OID_SaveMMPreset		; save Map Marker preset
int OID_LoadMMPreset		; load Map Marker preset
int OID_SaveCTPreset		; save Compass Tweaks preset
int OID_LoadCTPreset		; load Compass Tweaks preset

GlobalVariable Property ATLASGroupPlayerHomeGV Auto
GlobalVariable Property ATLASGroupImportantGV Auto
GlobalVariable Property ATLASGroupFactionGV Auto
GlobalVariable Property ATLASGroupCityInnGV Auto
GlobalVariable Property ATLASGroupCityShopGV Auto
GlobalVariable Property ATLASGroupCityGV Auto
GlobalVariable Property ATLASGroupTempleGV Auto
GlobalVariable Property ATLASGroupHallDeadGV Auto
GlobalVariable Property ATLASGroupCaravanCampGV Auto
GlobalVariable Property ATLASGroupMoreCityGV Auto
GlobalVariable Property ATLASGroupImportantTownGV Auto
GlobalVariable Property ATLASGroupInnGV Auto
GlobalVariable Property ATLASGroupShopGV Auto
GlobalVariable Property ATLASGroupFarmGV Auto
GlobalVariable Property ATLASGroupLumberMillGV Auto
GlobalVariable Property ATLASGroupMineGV Auto
GlobalVariable Property ATLASGroupMoreTownGV Auto
GlobalVariable Property ATLASGroupShrineGV Auto
GlobalVariable Property ATLASGroupShrineStepsGV Auto
GlobalVariable Property ATLASGroupCWCampGV Auto
GlobalVariable Property ATLASGroupCampGV Auto
GlobalVariable Property ATLASGroupAltarGV Auto
GlobalVariable Property ATLASGroupDragonGV Auto
GlobalVariable Property ATLASGroupAnimalDenGV Auto
GlobalVariable Property ATLASGroupWaterGV Auto
GlobalVariable Property ATLASGroupDunExitGV Auto
GlobalVariable Property ATLASGroupSkillBookGV Auto
GlobalVariable Property ATLASGroupTreasureGV Auto
GlobalVariable Property ATLASGroupShipwreckGV Auto
GlobalVariable Property ATLASGroupStructuresGV Auto
GlobalVariable Property ATLASGroupRuinGV Auto
GlobalVariable Property ATLASGroupLandmarkGV Auto
GlobalVariable Property ATLASGroupPOIGV Auto
GlobalVariable Property ATLASGroupBLK1GV Auto
GlobalVariable Property ATLASGroupBLK2GV Auto
GlobalVariable Property ATLASGroupBLK3GV Auto
GlobalVariable Property ATLASGroupDG1GV Auto
GlobalVariable Property ATLASGroupDG2GV Auto
GlobalVariable Property ATLASGroupDG3GV Auto
GlobalVariable Property ATLASGroupDGFV0GV Auto
GlobalVariable Property ATLASGroupDGFV1GV Auto
GlobalVariable Property ATLASGroupDGFV2GV Auto
GlobalVariable Property ATLASGroupDGFV3GV Auto
GlobalVariable Property ATLASGroupDGSC1GV Auto
GlobalVariable Property ATLASGroupDGSC2GV Auto
GlobalVariable Property ATLASGroupDGSC3GV Auto

GlobalVariable Property ATLASGroupDB1GV Auto
GlobalVariable Property ATLASGroupDB2GV Auto
GlobalVariable Property ATLASGroupDB3GV Auto
GlobalVariable Property ATLASGroupDB4GV Auto

int ATLASGroupPlayerHomeOID
int ATLASGroupImportantOID
int ATLASGroupImportantTownOID
int ATLASGroupCityOID
int ATLASGroupShopOID
int ATLASGroupCityShopOID
int ATLASGroupTempleOID
int ATLASGroupHallDeadOID 
int ATLASGroupShrineOID
int ATLASGroupShrineStepsOID
int ATLASGroupInnOID
int ATLASGroupCityInnOID
int ATLASGroupFarmOID
int ATLASGroupLumberMillOID
int ATLASGroupMineOID
int ATLASGroupCaravanCampOID
int ATLASGroupFactionOID
int ATLASGroupMoreCityOID
int ATLASGroupMoreTownOID
int ATLASGroupCWCampOID
int ATLASGroupWaterOID
int ATLASGroupDunExitOID
int ATLASGroupSkillBookOID
int ATLASGroupTreasureOID
int	ATLASGroupCampOID
int ATLASGroupAltarOID
int ATLASGroupDragonOID
int ATLASGroupAnimalDenOID
int ATLASGroupShipwreckOID
int ATLASGroupStructuresOID
int ATLASGroupRuinOID
int ATLASGroupLandmarkOID
int ATLASGroupPOIOID
int ATLASGroupBLK1OID
int ATLASGroupBLK2OID
int ATLASGroupBLK3OID
int ATLASGroupDG1OID
int ATLASGroupDG2OID
int ATLASGroupDG3OID
int ATLASGroupDGFV0OID
int ATLASGroupDGFV1OID
int ATLASGroupDGFV2OID
int ATLASGroupDGFV3OID
int ATLASGroupDGSC1OID
int ATLASGroupDGSC2OID
int ATLASGroupDGSC3OID
int ATLASGroupDB1OID
int ATLASGroupDB2OID
int ATLASGroupDB3OID
int ATLASGroupDB4OID 

int ATLASMainVanillaMarkersOID
int ATLASMainVanillaInt = 0
int ATLASMainVisibilityOID
int ATLASMainVisibilityInt = 0
int ATLASMainDisplayHelpOID
int ATLASMainDisplayHelp0OID
int ATLASMainDisplayHelp1OID
int ATLASMainDisplayHelp2OID
int ATLASMainDisplayHelp3OID
int ATLASMainDisplayWarnOID
int ATLASExtraBook1OID
int ATLASExtraBook2OID
int ATLASExtraBook3OID
int ATLASExtraFlagonExitOID
int ATLASExtraFlagonExitKeyOID

Message Property MsgFactionCamps Auto
Message Property MsgFlagonKeyWarning Auto
Message Property MsgHiddenPeaks Auto
int iMenuChoice = 0
Key property FlagonKey auto
Book property SetupBook1 auto
Book property SetupBook2 auto
Book property SetupBook3 auto
int FlagonExitVal
ObjectReference property FlagonParentMarker Auto

int	OIDCompassFadeStart
int	OIDCompassHUDMaxDist
int	OIDCompassMapMaxSize
int	OIDCompassMapMinSize
int	OIDCompassMapMinFade
int	OIDCompassQuestMaxSize
int	OIDCompassQuestMinSize
int	OIDCompassQuestMinFade

float FadeStartVal = 10000.0
float HUDMaxDistVal = 20000.0
float MapMaxVal = 130.0
float MapMinVal = 90.0
float MapFadeVal = 40.0
float QuestMaxVal = 150.0
float QuestMinVal = 100.0
float QuestFadeVal = 90.0

bool PlayerHome
bool Important
bool ImportantTown
bool City 
bool Shop
bool CityShop
bool Temple
bool HallDead
bool Shrine
bool ShrineSteps
bool Inn
bool CityInn
bool Farm
bool LumberMill
bool Mine
bool CaravanCamp
bool bFaction
bool MoreCity
bool MoreTown
bool CWCamp
bool Water
bool DunExit
bool SkillBook
bool Treasure
bool Camp
bool Altar
bool Dragon
bool AnimalDen
bool Shipwreck
bool Structures
bool Ruin
bool Landmark
bool POI
bool BLK1
bool BLK2
bool BLK3
bool DG1
bool DG2
bool DG3
bool DGFV0
bool DGFV1
bool DGFV2
bool DGFV3
bool DGSC1
bool DGSC2
bool DGSC3
bool DB1
bool DB2
bool DB3
bool DB4 


Int iIndex = 0
FormList UseThisList
String[] DisplayOption
bool OptionChanged
bool RunConfigure

Event OnConfigInit ()
	ModName = "Atlas Map Markers"

	DisplayOption = New String[4]
	DisplayOption[0] = "No Marker"
	DisplayOption[1] = "Default"
	DisplayOption[2] = "<font color='#FF0000'>Undiscovered</font>"
	DisplayOption[3] = "<font color='#FF0000'>Discovered</font>"
EndEvent

Event OnConfigClose()
	ConfigureMapMarkers()
EndEvent


Event OnPageReset (String MenuPage)
If MenuPage == ""
	SetCursorFillMode(TOP_TO_BOTTOM) 
	AddHeaderOption ("<font color='#FF9900'> COMPASS SETTINGS</font>")	
	OIDCompassHUDMaxDist = AddSliderOption("Location Max Distance", HUDMaxDistVal, "{0}")
	OIDCompassMapMaxSize = AddSliderOption("Map Marker: Max Size", MapMaxVal, "{0}%")
	OIDCompassMapMinSize = AddSliderOption("Map Marker: Min Size", MapMinVal, "{0}%")
	OIDCompassMapMinFade = AddSliderOption("Map Marker: Min Fade", MapFadeVal, "{0}%")
	AddEmptyOption()	
	AddHeaderOption ("<font color='#FF9900'> MAP MARKER OPTIONS</font>")
	ATLASMainDisplayHelpOID = AddTextOption("", "<font color='#FFFF00'>General Info</font>") 
;	ATLASMainVanillaMarkersOID = AddToggleOption("Include Vanilla Markers", ATLASMainVanillaInt)
	ATLASMainVisibilityOID = AddToggleOption("Reveal Markers on Map", ATLASMainVisibilityInt)
	if ATLASMainVisibilityInt
		ATLASMainDisplayWarnOID = AddTextOption("", "<font color='#FF0000'>WARNING!</font>")
		;AddEmptyOption()
	endif
	AddEmptyOption()
	
	AddHeaderOption ("<font color='#FFCC66'>  MAJOR CITIES</font>")	
	if ATLASMainVanillaInt == 1
		;city markers
	endif	
	ATLASGroupPlayerHomeOID = AddTextOption("Player Homes", DisplayOption[ATLASGroupPlayerHomeGV.GetValue() as Int])
	ATLASGroupImportantOID = AddTextOption("Notable Places", DisplayOption[ATLASGroupImportantGV.GetValue() as Int])
	ATLASGroupFactionOID = AddTextOption("Faction Related", DisplayOption[ATLASGroupFactionGV.GetValue() as Int])
	ATLASGroupCityInnOID = AddTextOption("Inns", DisplayOption[ATLASGroupCityInnGV.GetValue() as Int])
	ATLASGroupCityShopOID = AddTextOption("Shops", DisplayOption[ATLASGroupCityShopGV.GetValue() as Int])
	ATLASGroupCityOID = AddTextOption("Markets", DisplayOption[ATLASGroupCityGV.GetValue() as Int])
	ATLASGroupTempleOID = AddTextOption("Temples", DisplayOption[ATLASGroupTempleGV.GetValue() as Int])
	ATLASGroupHallDeadOID = AddTextOption("Halls of the Dead", DisplayOption[ATLASGroupHallDeadGV.GetValue() as Int])
	ATLASGroupCaravanCampOID = AddTextOption("Khajiit Caravan Campsites", DisplayOption[ATLASGroupCaravanCampGV.GetValue() as Int])
	ATLASGroupMoreCityOID = AddTextOption("Additional Locations", DisplayOption[ATLASGroupMoreCityGV.GetValue() as Int])
	;docks?
	AddEmptyOption()

	AddHeaderOption ("<font color='#FFCC66'> TOWNS & SETTLEMENTS</font>")	
	if ATLASMainVanillaInt == 1
		;town markers
	endif	
	ATLASGroupImportantTownOID = AddTextOption("Notable Places", DisplayOption[ATLASGroupImportantTownGV.GetValue() as Int])	
	ATLASGroupInnOID = AddTextOption("Inns", DisplayOption[ATLASGroupInnGV.GetValue() as Int])
	ATLASGroupShopOID = AddTextOption("Shops", DisplayOption[ATLASGroupShopGV.GetValue() as Int])
	ATLASGroupFarmOID = AddTextOption("Farms", DisplayOption[ATLASGroupFarmGV.GetValue() as Int])
	ATLASGroupLumberMillOID = AddTextOption("Lumber Mills", DisplayOption[ATLASGroupLumberMillGV.GetValue() as Int])
	ATLASGroupMineOID = AddTextOption("Ore Mines", DisplayOption[ATLASGroupMineGV.GetValue() as Int])
	ATLASGroupMoreTownOID = AddTextOption("Additional Locations", DisplayOption[ATLASGroupMoreTownGV.GetValue() as Int])
	AddEmptyOption()	

	AddHeaderOption ("<font color='#FFCC66'> WILDERNESS</font>")	
	if ATLASMainVisibilityInt == 1
		ATLASGroupCWCampOID = AddTextOption("Civil War Camps", DisplayOption[ATLASGroupCWCampGV.GetValue() as Int])
	endif	
	ATLASGroupCampOID = AddTextOption("Camps", DisplayOption[ATLASGroupCampGV.GetValue() as Int])
	ATLASGroupShrineOID = AddTextOption("Shrines", DisplayOption[ATLASGroupShrineGV.GetValue() as Int])
	ATLASGroupShrineStepsOID = AddTextOption("Wayshrines", DisplayOption[ATLASGroupShrineStepsGV.GetValue() as Int])
	ATLASGroupAltarOID = AddTextOption("Altars", DisplayOption[ATLASGroupAltarGV.GetValue() as Int])
	ATLASGroupDragonOID = AddTextOption("Dragon Mounds", DisplayOption[ATLASGroupDragonGV.GetValue() as Int])
	ATLASGroupAnimalDenOID = AddTextOption("Animal Dens", DisplayOption[ATLASGroupAnimalDenGV.GetValue() as Int])
	ATLASGroupWaterOID = AddTextOption("Bodies of Water", DisplayOption[ATLASGroupWaterGV.GetValue() as Int])
	ATLASGroupDunExitOID = AddTextOption("Dungeon Exits", DisplayOption[ATLASGroupDunExitGV.GetValue() as Int])
	ATLASGroupSkillBookOID = AddTextOption("Lost Skill Books", DisplayOption[ATLASGroupSkillBookGV.GetValue() as Int])
;	ATLASGroupTreasureOID = AddTextOption("Treasure Map Loot", DisplayOption[ATLASGroupTreasureGV.GetValue() as Int])
	ATLASGroupShipwreckOID = AddTextOption("Shipwrecks", DisplayOption[ATLASGroupShipwreckGV.GetValue() as Int])
	ATLASGroupStructuresOID = AddTextOption("Structures", DisplayOption[ATLASGroupStructuresGV.GetValue() as Int])
	ATLASGroupRuinOID = AddTextOption("Ruins", DisplayOption[ATLASGroupRuinGV.GetValue() as Int])
	ATLASGroupLandmarkOID = AddTextOption("Natural Landmarks", DisplayOption[ATLASGroupLandmarkGV.GetValue() as Int])
	ATLASGroupPOIOID = AddTextOption("Points of Interest", DisplayOption[ATLASGroupPOIGV.GetValue() as Int])
			
SetCursorPosition(1) ; Move cursor to top right position
	AddHeaderOption("")
	OIDCompassFadeStart = AddSliderOption("Fade Start Distance", FadeStartVal, "{0}")
	OIDCompassQuestMaxSize = AddSliderOption("Quest Marker: Max Size", QuestMaxVal, "{0}%")
	OIDCompassQuestMinSize = AddSliderOption("Quest Marker: Min Size", QuestMinVal, "{0}%")
	OIDCompassQuestMinFade = AddSliderOption("Quest Marker: Min Fade", QuestFadeVal, "{0}%")
	AddEmptyOption()
	AddHeaderOption("")
	ATLASMainDisplayHelp0OID = AddTextOption("", "<font color='#FFFF66'>No Markers</font>")
	ATLASMainDisplayHelp1OID = AddTextOption("", "<font color='#FFFF66'>Default</font>")
	if ATLASMainVisibilityInt
		ATLASMainDisplayHelp2OID = AddTextOption("", "<font color='#FFFF66'>Undiscovered</font>")
		ATLASMainDisplayHelp3OID = AddTextOption("", "<font color='#FFFF66'>Discovered</font>")
	else
		AddEmptyOption()
	endif	
	
	AddHeaderOption ("<font color='#FFCC66'> SOLSTHEIM</font>")	
	ATLASGroupDB1OID = AddTextOption("The Northern Maiden", DisplayOption[ATLASGroupDB1GV.GetValue() as Int])
	ATLASGroupDB2OID = AddTextOption("Points of Interest", DisplayOption[ATLASGroupDB2GV.GetValue() as Int])
	ATLASGroupDB3OID = AddTextOption("Gem Geodes", DisplayOption[ATLASGroupDB3GV.GetValue() as Int])
	ATLASGroupDB4OID = AddTextOption("Hidden Peaks", DisplayOption[ATLASGroupDB4GV.GetValue() as Int])
	AddEmptyOption()
	AddHeaderOption ("<font color='#FFCC66'> BLACKREACH</font>")	
	ATLASGroupBLK1OID = AddTextOption("Primary Locations", DisplayOption[ATLASGroupBLK1GV.GetValue() as Int])
	ATLASGroupBLK2OID = AddTextOption("Secondary Locations", DisplayOption[ATLASGroupBLK2GV.GetValue() as Int])
	ATLASGroupBLK3OID = AddTextOption("Points of Interest", DisplayOption[ATLASGroupBLK3GV.GetValue() as Int])
	AddEmptyOption()
	AddHeaderOption ("<font color='#FFCC66'> FORGOTTEN VALE</font>")	
;	ATLASGroupDGFV0OID = AddTextOption("To/From Skyrim", DisplayOption[ATLASGroupDGFV0GV.GetValue() as Int])
	ATLASGroupDGFV1OID = AddTextOption("Primary Locations", DisplayOption[ATLASGroupDGFV1GV.GetValue() as Int])
	ATLASGroupDGFV2OID = AddTextOption("Secondary Locations", DisplayOption[ATLASGroupDGFV2GV.GetValue() as Int])
	ATLASGroupDGFV3OID = AddTextOption("Points of Interest", DisplayOption[ATLASGroupDGFV3GV.GetValue() as Int])
	AddEmptyOption()
	AddHeaderOption ("<font color='#FFCC66'> SOUL CAIRN</font>")	
	ATLASGroupDGSC1OID = AddTextOption("Primary Locations", DisplayOption[ATLASGroupDGSC1GV.GetValue() as Int])
	ATLASGroupDGSC2OID = AddTextOption("Secondary Locations", DisplayOption[ATLASGroupDGSC2GV.GetValue() as Int])
	ATLASGroupDGSC3OID = AddTextOption("Points of Interest", DisplayOption[ATLASGroupDGSC3GV.GetValue() as Int])
	AddEmptyOption()
	AddHeaderOption ("<font color='#FFCC66'> DAWNGUARD</font>")	
	ATLASGroupDG1OID = AddTextOption("Extra Locations", DisplayOption[ATLASGroupDG1GV.GetValue() as Int])
	ATLASGroupDG2OID = AddTextOption("Ferrymen", DisplayOption[ATLASGroupDG2GV.GetValue() as Int])
;	ATLASGroupDG3OID = AddTextOption("Wilderness Caches", DisplayOption[ATLASGroupDG3GV.GetValue() as Int])
	AddEmptyOption()

	AddHeaderOption ("<font color='#FF9900'> EXTRA OPTIONS</font>")	
	ATLASExtraBook1OID = AddTextOption("Setup Guide: Main", "")
	ATLASExtraBook2OID = AddTextOption("Setup Guide: Dawnguard", "")
	ATLASExtraBook3OID = AddTextOption("Setup Guide: Dragonborn", "")
	if FlagonExitVal == 1
		ATLASExtraFlagonExitOID = AddTextOption("Ragged Flagon Shortcut", "Enabled")
		ATLASExtraFlagonExitKeyOID = AddTextOption("Add Shortcut Key", "")
	else
		ATLASExtraFlagonExitOID = AddTextOption("Ragged Flagon Shortcut", "Disabled")
	endif
	AddEmptyOption()	
	int hasFiss = game.getModByName("FISS.esp")
	If (0 < hasFiss && hasFiss < 255)
		AddHeaderOption ("<font color='#FF9900'> PRESETS</font>")	
		OID_LoadMMPreset = AddTextOption("Load Map Marker Preset","")
		OID_SaveMMPreset = AddTextOption("Save Map Marker Settings","")
		OID_LoadCTPreset = AddTextOption("Load Compass Tweaks Preset","")
		OID_SaveCTPreset = AddTextOption("Save Current Compass Settings","")
		AddEmptyOption()	
	EndIf
	
endif
EndEvent

;-------------------------------------------------------------------------------------------------------
	
Event OnOptionSelect(Int Option)
	If Option == ATLASMainVisibilityOID
		if ATLASMainVisibilityInt == 0
			ATLASMainVisibilityInt = 1
			Debug.MessageBox("WARNING!\nSetting an option to 'Discovered' or 'Undiscovered' will apply the markers to the map.  You can't change a location back to 'Default' once it is shown on the map.  Once shown, they can be removed from the map only by changing the setting to 'No Markers'.")
			Debug.MessageBox("WARNING!\nSetting certain locations to 'Discovered' before discovering them on your own may cause problems with some quests. By doing this you will be able to go places that you normally could not. Use at your own risk.")
			ForcePageReset()
		else
			ATLASMainVisibilityInt = 0
			ForcePageReset()
		endif
	elseif Option == ATLASMainDisplayWarnOID
		Debug.MessageBox("WARNING!\nSetting an option to 'Discovered' or 'Undiscovered' will apply the markers to the map.  You can't change a location back to 'Default' once it is shown on the map.  Once shown, they can be removed from the map only by changing the setting to 'No Markers'.")
		Debug.MessageBox("WARNING!\nSetting certain locations to 'Discovered' before discovering them on your own may cause problems with some quests. By doing this you will be able to go places that you normally could not. Use at your own risk.")
	elseif Option == ATLASMainDisplayHelpOID
		Debug.MessageBox("This menu will allow you to customize which markers appear on your map.  Your selections won't be finalized until you exit this MCM.")
		Debug.MessageBox("Once you exit this MCM, the map will be updated to reflect your changes.  Depending on how many markers need to be altered, this could take several minutes.  Please be patient and wait for the map to finish updating.  Do not open the MCM until after the map has finished updating.")
		Debug.MessageBox("The categories below have been created for your convenience and to provide greater flexibility in customizing the map.  It is best to treat the group headers as generalizations and not strict groupings.  There are a few categories which contain markers located in both cities and towns, or towns and wilderness.")
		Debug.MessageBox("The categories in the left column will also affect any relevant markers on Solstheim.") 
	elseif Option == ATLASMainDisplayHelp1OID
		ShowMessage("DEFAULT\nMarkers are enabled but hiddened until you discover them")
	elseif Option == ATLASMainDisplayHelp2OID
		ShowMessage("UNDISCOVERED\nMarkers are enabled and shown on the map")		
	elseif Option == ATLASMainDisplayHelp3OID
		ShowMessage("DISCOVERED\nMarkers are enabled and available for fast travel")
	elseif Option == ATLASMainDisplayHelp0OID
		ShowMessage("NO MARKERS\nMarkers are disabled and removed from the map")
	elseif Option == ATLASGroupPlayerHomeOID
		SetOptionType(ATLASGroupPlayerHomeGV, ATLASGroupPlayerHomeOID)
		PlayerHome = true
	elseif Option == ATLASGroupImportantOID
		SetOptionType(ATLASGroupImportantGV, ATLASGroupImportantOID)	
		Important = true
	elseif Option == ATLASGroupFactionOID
		SetOptionType(ATLASGroupFactionGV, ATLASGroupFactionOID)
		bFaction = true
	elseif Option == ATLASGroupCityInnOID
		SetOptionType(ATLASGroupCityInnGV, ATLASGroupCityInnOID)
		CityInn = true
	elseif Option == ATLASGroupCityShopOID
		SetOptionType(ATLASGroupCityShopGV, ATLASGroupCityShopOID)	
		CityShop = true
	elseif Option == ATLASGroupCityOID
		SetOptionType(ATLASGroupCityGV, ATLASGroupCityOID)
		City = true		
	elseif Option == ATLASGroupTempleOID
		SetOptionType(ATLASGroupTempleGV, ATLASGroupTempleOID)
		Temple = true
	elseif Option == ATLASGroupHallDeadOID
		SetOptionType(ATLASGroupHallDeadGV, ATLASGroupHallDeadOID)
		HallDead = true
	elseif Option == ATLASGroupCaravanCampOID
		SetOptionType(ATLASGroupCaravanCampGV, ATLASGroupCaravanCampOID)
		CaravanCamp = true
	elseif Option == ATLASGroupMoreCityOID
		SetOptionType(ATLASGroupMoreCityGV, ATLASGroupMoreCityOID)
		MoreCity = true		
	elseif Option == ATLASGroupImportantTownOID
		SetOptionType(ATLASGroupImportantTownGV, ATLASGroupImportantTownOID)
		ImportantTown = true
	elseif Option == ATLASGroupInnOID
		SetOptionType(ATLASGroupInnGV, ATLASGroupInnOID)
		Inn = true
	elseif Option == ATLASGroupShopOID
		SetOptionType(ATLASGroupShopGV, ATLASGroupShopOID)
		Shop = true
	elseif Option == ATLASGroupFarmOID
		SetOptionType(ATLASGroupFarmGV, ATLASGroupFarmOID)
		Farm = true
	elseif Option == ATLASGroupLumberMillOID
		SetOptionType(ATLASGroupLumberMillGV, ATLASGroupLumberMillOID)
		LumberMill = true
	elseif Option == ATLASGroupMineOID
		SetOptionType(ATLASGroupMineGV, ATLASGroupMineOID)
		Mine = true
	elseif Option == ATLASGroupMoreTownOID
		SetOptionType(ATLASGroupMoreTownGV, ATLASGroupMoreTownOID)
		MoreTown = true	
	elseif Option == ATLASGroupCWCampOID
		if ShowMessage("This will make all of the active Imperial and Stormcloak base camps show on the map as <b>Undiscovered</b> places, making them easier to find as they change while the civil war rages on. There are 16 camps and only the active ones will be visible.\n\nWARNING!\nThis action cannot be undone.", true, "Show the Camps", "Cancel")
			SetSpecialOptionType(ATLASGroupCWCampGV, ATLASGroupCWCampOID)
			CWCamp = true	
		endif
	elseif Option == ATLASGroupCampOID
		SetOptionType(ATLASGroupCampGV, ATLASGroupCampOID)
		Camp = true		
	elseif Option == ATLASGroupShrineOID
		SetOptionType(ATLASGroupShrineGV, ATLASGroupShrineOID)
		Shrine = true
	elseif Option == ATLASGroupShrineStepsOID
		SetOptionType(ATLASGroupShrineStepsGV, ATLASGroupShrineStepsOID)
		ShrineSteps = true
	elseif Option == ATLASGroupAltarOID
		SetOptionType(ATLASGroupAltarGV, ATLASGroupAltarOID)
		Altar = true		
	elseif Option == ATLASGroupDragonOID
		SetOptionType(ATLASGroupDragonGV, ATLASGroupDragonOID)
		Dragon = true		
	elseif Option == ATLASGroupAnimalDenOID
		SetOptionType(ATLASGroupAnimalDenGV, ATLASGroupAnimalDenOID)
		AnimalDen = true		
	elseif Option == ATLASGroupWaterOID
		SetOptionType(ATLASGroupWaterGV, ATLASGroupWaterOID)
		Water = true
	elseif Option == ATLASGroupDunExitOID
		SetOptionType(ATLASGroupDunExitGV, ATLASGroupDunExitOID)
		DunExit = true
	elseif Option == ATLASGroupSkillBookOID
		SetOptionType(ATLASGroupSkillBookGV, ATLASGroupSkillBookOID)
		SkillBook = true
;	elseif Option == ATLASGroupTreasureOID
;		iMenuChoice = MsgTreasureWarning.Show()			
;		SetOptionType(ATLASGroupTreasureGV, ATLASGroupTreasureOID)
;		Treasure = true
	elseif Option == ATLASGroupShipwreckOID
		SetOptionType(ATLASGroupShipwreckGV, ATLASGroupShipwreckOID)
		Shipwreck = true		
	elseif Option == ATLASGroupStructuresOID
		SetOptionType(ATLASGroupStructuresGV, ATLASGroupStructuresOID)
		Structures = true		
	elseif Option == ATLASGroupRuinOID
		SetOptionType(ATLASGroupRuinGV, ATLASGroupRuinOID)
		Ruin = true		
	elseif Option == ATLASGroupLandmarkOID
		SetOptionType(ATLASGroupLandmarkGV, ATLASGroupLandmarkOID)
		Landmark = true		
	elseif Option == ATLASGroupPOIOID
		SetOptionType(ATLASGroupPOIGV, ATLASGroupPOIOID)
		POI = true
	elseif Option == ATLASGroupBLK1OID
		SetOptionType(ATLASGroupBLK1GV, ATLASGroupBLK1OID)
		BLK1 = true
	elseif Option == ATLASGroupBLK2OID
		SetOptionType(ATLASGroupBLK2GV, ATLASGroupBLK2OID)
		BLK2 = true
	elseif Option == ATLASGroupBLK3OID
		SetOptionType(ATLASGroupBLK3GV, ATLASGroupBLK3OID)
		BLK3 = true
	elseif Option == ATLASGroupDG1OID
		SetOptionType(ATLASGroupDG1GV, ATLASGroupDG1OID)
		DG1 = true	
	elseif Option == ATLASGroupDG2OID
		SetOptionType(ATLASGroupDG2GV, ATLASGroupDG2OID)	
		DG2 = true			
;	elseif Option == ATLASGroupDG3OID
;		SetOptionType(ATLASGroupDG3GV, ATLASGroupDG3OID)
;		DG3 = true	
;	elseif Option == ATLASGroupDGFV0OID
;		SetOptionType(ATLASGroupDGFV0GV, ATLASGroupDGFV0OID)
;		DGFV0 = true	
	elseif Option == ATLASGroupDGFV1OID
		SetOptionType(ATLASGroupDGFV1GV, ATLASGroupDGFV1OID)
		DGFV1 = true
	elseif Option == ATLASGroupDGFV2OID
		SetOptionType(ATLASGroupDGFV2GV, ATLASGroupDGFV2OID)
		DGFV2 = true
	elseif Option == ATLASGroupDGFV3OID
		SetOptionType(ATLASGroupDGFV3GV, ATLASGroupDGFV3OID)
		DGFV3 = true	
	elseif Option == ATLASGroupDGSC1OID
		SetOptionType(ATLASGroupDGSC1GV, ATLASGroupDGSC1OID)
		DGSC1 = true
	elseif Option == ATLASGroupDGSC2OID
		SetOptionType(ATLASGroupDGSC2GV, ATLASGroupDGSC2OID)
		DGSC2 = true
	elseif Option == ATLASGroupDGSC3OID
		SetOptionType(ATLASGroupDGSC3GV, ATLASGroupDGSC3OID)
		DGSC3 = true			
	elseif Option == ATLASGroupDB1OID
		SetOptionType(ATLASGroupDB1GV, ATLASGroupDB1OID)
		DB1 = true
	elseif Option == ATLASGroupDB2OID
		SetOptionType(ATLASGroupDB2GV, ATLASGroupDB2OID)
		DB2 = true
	elseif Option == ATLASGroupDB3OID
		SetOptionType(ATLASGroupDB3GV, ATLASGroupDB3OID)
		DB3 = true		
	elseif Option == ATLASGroupDB4OID
		if ShowMessage("The Dragonborn DLC has 4 very hard to reach Hidden Peak map markers on the map. They are normally disabled until you find each peak. These markers can be enabled to allow you to find them easier, like a normal location.\n\nDo you want to change these locations?", true, "Change them", "Cancel")
			SetOptionType(ATLASGroupDB4GV, ATLASGroupDB4OID)
			DB4 = true
		endif	
	elseif Option == ATLASExtraBook1OID
		Game.GetPlayer().AddItem(SetupBook1)
	elseif Option == ATLASExtraBook2OID
		Game.GetPlayer().AddItem(SetupBook2)
	elseif Option == ATLASExtraBook3OID
		Game.GetPlayer().AddItem(SetupBook3)
	elseif Option == ATLASExtraFlagonExitKeyOID
		if ShowMessage("This key will open the Abandoned Sewer, a faster way in to the Ragged Flagon. It is normally found inside of the Ragged Flagon. This key will allow you access to the area before you normally would. This may break some quests and should only be used AFTER you have been to the Ragged Flagon.\n\nWould you like the key?", true, "Give me the key", "Cancel")
			Game.GetPlayer().AddItem(FlagonKey, 1) 		
		EndIf
	elseif Option == ATLASExtraFlagonExitOID
		If FlagonExitVal == 1
			FlagonParentMarker.Disable()
			FlagonExitVal = 0
			ForcePageReset()
		else
			FlagonParentMarker.Enable()
			FlagonExitVal = 1
			ForcePageReset()		
		endif
	ElseIf (option == OID_LoadMMPreset)
		BeginLoadMMPreset()
	ElseIf (option == OID_SaveMMPreset)	
		BeginSaveMMPreset()	
	ElseIf (option == OID_LoadCTPreset)
		BeginLoadCTPreset()
	ElseIf (option == OID_SaveCTPreset)	
		BeginSaveCTPreset()		
 	endif
EndEvent

event OnOptionSliderOpen(int option)
	if (option == OIDCompassFadeStart)
		SetSliderDialogStartValue(FadeStartVal)
		SetSliderDialogDefaultValue(10000)
		SetSliderDialogRange(500, 15000)
		SetSliderDialogInterval(500)
	elseIf (option == OIDCompassHUDMaxDist)
		SetSliderDialogStartValue(HUDMaxDistVal)
		SetSliderDialogDefaultValue(20000)
		SetSliderDialogRange(0, 30000)
		SetSliderDialogInterval(500)
	elseIf (option == OIDCompassMapMaxSize)
		SetSliderDialogStartValue(MapMaxVal)
		SetSliderDialogDefaultValue(130)
		SetSliderDialogRange(0, 200)
		SetSliderDialogInterval(5)	
	elseIf (option == OIDCompassMapMinSize)
		SetSliderDialogStartValue(MapMinVal)
		SetSliderDialogDefaultValue(90)
		SetSliderDialogRange(0, 200)
		SetSliderDialogInterval(5)		
	elseIf (option == OIDCompassMapMinFade)
		SetSliderDialogStartValue(MapFadeVal)
		SetSliderDialogDefaultValue(40)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(5)	
	elseIf (option == OIDCompassQuestMaxSize)
		SetSliderDialogStartValue(QuestMaxVal)
		SetSliderDialogDefaultValue(150)
		SetSliderDialogRange(0, 200)
		SetSliderDialogInterval(5)	
	elseIf (option == OIDCompassQuestMinSize)
		SetSliderDialogStartValue(QuestMinVal)
		SetSliderDialogDefaultValue(100)
		SetSliderDialogRange(0, 200)
		SetSliderDialogInterval(5)		
	elseIf (option == OIDCompassQuestMinFade)
		SetSliderDialogStartValue(QuestFadeVal)
		SetSliderDialogDefaultValue(90)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(5)			
	endif
endevent

Event OnOptionSliderAccept(int option, float value)
	if (option == OIDCompassFadeStart)
		FadeStartVal = value
		Game.SetGameSettingInt("iMapMarkerFadeStartDistance", (FadeStartVal as int))
		SetSliderOptionValue(OIDCompassFadeStart, FadeStartVal, "{0}")
	elseIf (option == OIDCompassHUDMaxDist)
		HUDMaxDistVal = value
		Game.SetGameSettingFloat("fHUDCompassLocationMaxDist", HUDMaxDistVal)
		SetSliderOptionValue(OIDCompassHUDMaxDist, HUDMaxDistVal, "{0}")	
	elseIf (option == OIDCompassMapMaxSize)
		MapMaxVal = value
		Game.SetGameSettingFloat("fMapMarkerMaxPercentSize", MapMaxVal)
		SetSliderOptionValue(OIDCompassMapMaxSize, MapMaxVal, "{0}%")	
	elseIf (option == OIDCompassMapMinSize)
		MapMinVal = value
		Game.SetGameSettingFloat("fMapMarkerMinPercentSize", MapMinVal)
		SetSliderOptionValue(OIDCompassMapMinSize, MapMinVal, "{0}%")			
	elseIf (option == OIDCompassMapMinFade)
		MapFadeVal = value
		Game.SetGameSettingFloat("fMapMarkerMinFadeAlpha", MapFadeVal)
		SetSliderOptionValue(OIDCompassMapMinFade, MapFadeVal, "{0}%")			
	elseIf (option == OIDCompassQuestMaxSize)
		QuestMaxVal = value
		Game.SetGameSettingFloat("fMapQuestMarkerMaxPercentSize", QuestMaxVal)
		SetSliderOptionValue(OIDCompassQuestMaxSize, QuestMaxVal, "{0}%")	
	elseIf (option == OIDCompassQuestMinSize)
		QuestMinVal = value
		Game.SetGameSettingFloat("fMapQuestMarkerMinPercentSize", QuestMinVal)
		SetSliderOptionValue(OIDCompassQuestMinSize, QuestMinVal, "{0}%")			
	elseIf (option == OIDCompassQuestMinFade)
		QuestFadeVal = value
		Game.SetGameSettingFloat("fMapQuestMarkerMinFadeAlpha", QuestFadeVal)
		SetSliderOptionValue(OIDCompassQuestMinFade, QuestFadeVal, "{0}%")				
	endif
EndEvent

Event OnOptionDefault(int option)
	if (option == OIDCompassFadeStart)
		FadeStartVal = 10000.0
		SetSliderOptionValue(OIDCompassFadeStart, FadeStartVal, "{0}")
		Game.SetGameSettingInt("iMapMarkerFadeStartDistance", (FadeStartVal as int))
	elseIf (option == OIDCompassHUDMaxDist)
		HUDMaxDistVal = 20000.0
		Game.SetGameSettingFloat("fHUDCompassLocationMaxDist", HUDMaxDistVal)
		SetSliderOptionValue(OIDCompassHUDMaxDist, HUDMaxDistVal, "{0}")		
	elseIf (option == OIDCompassMapMaxSize)
		MapMaxVal = 130.0
		Game.SetGameSettingFloat("fMapMarkerMaxPercentSize", MapMaxVal)
		SetSliderOptionValue(OIDCompassMapMaxSize, MapMaxVal, "{0}%")	
	elseIf (option == OIDCompassMapMinSize)
		MapMinVal = 90.0
		Game.SetGameSettingFloat("fMapMarkerMinPercentSize", MapMinVal)
		SetSliderOptionValue(OIDCompassMapMinSize, MapMinVal, "{0}%")			
	elseIf (option == OIDCompassMapMinFade)
		MapFadeVal = 40.0
		Game.SetGameSettingFloat("fMapMarkerMinFadeAlpha", MapFadeVal)
		SetSliderOptionValue(OIDCompassMapMinFade, MapFadeVal, "{0}%")	
	elseIf (option == OIDCompassQuestMaxSize)
		QuestMaxVal = 150.0
		Game.SetGameSettingFloat("fMapQuestMarkerMaxPercentSize", QuestMaxVal)
		SetSliderOptionValue(OIDCompassQuestMaxSize, QuestMaxVal, "{0}%")	
	elseIf (option == OIDCompassQuestMinSize)
		QuestMinVal = 100.0
		Game.SetGameSettingFloat("fMapQuestMarkerMinPercentSize", QuestMinVal)
		SetSliderOptionValue(OIDCompassQuestMinSize, QuestMinVal, "{0}%")			
	elseIf (option == OIDCompassQuestMinFade)
		QuestFadeVal = 90.0
		Game.SetGameSettingFloat("fMapQuestMarkerMinFadeAlpha", QuestFadeVal)
		SetSliderOptionValue(OIDCompassQuestMinFade, QuestFadeVal, "{0}%")			
	endif
EndEvent


Event OnOptionHighlight(int option)
	if (option == ATLASMainDisplayHelp1OID)
		SetInfoText("Default: Markers are enabled but hiddened until you discover them, just like normal vanilla markers.")
	elseif (option == ATLASMainDisplayHelp2OID)
		SetInfoText("Undiscovered: Markers are enabled and shown on the map.\nWARNING - Once a location has been shown on the map, it cannot be changed back to 'Default' settings.")		
	elseif (option == ATLASMainDisplayHelp3OID)
		SetInfoText("Discovered: Markers are enabled and available for fast travel.\nWARNING - Once a location has been shown on the map, it cannot be changed back to 'Default' settings.")
	elseif (option == ATLASMainDisplayHelp0OID)
		SetInfoText("No Markers: Markers are disabled and removed from the map.")
	elseif (option == ATLASMainDisplayHelpOID)		
;		SetInfoText(Total markers: <font color='#99FFFF'>Atlas Skyrim</font> <font color='#99CCFF'>Vanilla Skyrim</font> <font color='#FFCC99'>Atlas Solstheim</font> <font color='#FFCCFF'>Vanilla Solstheim</font>")
	elseif (option == ATLASGroupPlayerHomeOID)
		SetInfoText("Player homes - 6 markers.")
	elseif (option == ATLASGroupImportantOID)
		SetInfoText("Places of note - Castle Dour, the Skyforge, and the Bards College - 3 markers.")
	elseif (option == ATLASGroupFactionOID)
		SetInfoText("Faction related locations - 6 markers.")		
	elseif (option == ATLASGroupCityInnOID)
		SetInfoText("Inns located within major cities - 6 markers.")		
	elseif (option == ATLASGroupCityShopOID)
		SetInfoText("Shops located within major cities - 18 markers.")
	elseif (option == ATLASGroupCityOID)
		SetInfoText("City market districts - 4 markers.")
	elseif (option == ATLASGroupTempleOID)
		SetInfoText("Temples of the Gods - 6 markers.")		
	elseif (option == ATLASGroupHallDeadOID)
		SetInfoText("Halls of the Dead - 6 markers.")		
	elseif (option == ATLASGroupCaravanCampOID)
		SetInfoText("Khajiit caravan campsites - 6 markers.")		
	elseif (option == ATLASGroupMoreCityOID)
		SetInfoText("Additional misc locations in the major cities - Thalmor Headquarters, Honorhall Orphanage, New Gnisis Cornerclub, the Great Porch, Calixto's, Markarth Treasury, and Plankside in Riften  - 7 markers.")	
	elseif (option == ATLASGroupImportantTownOID)
		SetInfoText("Places of note - Northstar Port, Dawnstar Lighthouse, the Penitus Oculatus Outpost, and the Telvanni Tower - 4 markers.")
	elseif (option == ATLASGroupInnOID)
		SetInfoText("Inns located outside the major cities - 10 markers.")	
	elseif (option == ATLASGroupShopOID)
		SetInfoText("Shops located outside the major cities - 14 markers.")		
	elseif (option == ATLASGroupFarmOID)
		SetInfoText("Farms - 13 markers.")		
	elseif (option == ATLASGroupLumberMillOID)
		SetInfoText("Lumber mills - 5 markers.")		
	elseif (option == ATLASGroupMineOID)
		SetInfoText("Underground ore mines - 13 markers.")			
	elseif (option == ATLASGroupMoreTownOID)
		SetInfoText("Additional misc locations in the smaller cities and towns - Jarls' Longhouses, Seven Thousand Steps, Morthal Cemetery, Silus Vesuius's House, Goldenglow Estate Sewer - 12 markers.")		
	elseif (option == ATLASGroupCWCampOID)
		SetInfoText("Active Imperial and Stormcloak base camps.  There are 16 camps, but only the active ones will be visible.")
	elseif (option == ATLASGroupCampOID)
		SetInfoText("Wilderness campsites - hunters, bandits, etc - 47 markers.")	
	elseif (option == ATLASGroupShrineOID)
		SetInfoText("Shrines - 29 markers.")		
	elseif (option == ATLASGroupShrineStepsOID)
		SetInfoText("Wayshrines located along the 7000 steps - 10 markers.")		
	elseif (option == ATLASGroupAltarOID)
		SetInfoText("Wilderness altars - 12 markers.")		
	elseif (option == ATLASGroupDragonOID)
		SetInfoText("Dragon Mounds - 25 markers.")		
	elseif (option == ATLASGroupAnimalDenOID)
		SetInfoText("Animal dens - 19 markers.")		
	elseif (option == ATLASGroupWaterOID)
		SetInfoText("Waterways and bodies of water - 15 markers.")	
	elseif (option == ATLASGroupDunExitOID)
		SetInfoText("Dungeon exits - 41 markers.")		
	elseif (option == ATLASGroupSkillBookOID)
		SetInfoText("Hard to find skill books - 20 markers.")		
;	elseif (option == ATLASGroupTreasureOID)
;		SetInfoText("Treasure Map Loot markers should only used if you cannot find the location on your own. This option will only enable markers for which you already have the map. If you find additional maps, you will need to reset this option.")		
	elseif (option == ATLASGroupShipwreckOID)
		SetInfoText("Shipwrecks - 10 markers.")		
	elseif (option == ATLASGroupStructuresOID)
		SetInfoText("Forts, towers, shacks, etc - 9 markers.")		
	elseif (option == ATLASGroupRuinOID)
		SetInfoText("Ruins, rubble, and burial mounds - 26 markers.")		
	elseif (option == ATLASGroupLandmarkOID)
		SetInfoText("Topographical landmarks such as peaks, passes, and cliffs - 14 markers.")		
	elseif (option == ATLASGroupPOIOID)
		SetInfoText("Hidden chests, corpses and other small details encountered in the wilderness - 72 markers.")
	elseif (option == ATLASGroupBLK1OID)
		SetInfoText("Great Lifts and primary access points - 7 markers.")
	elseif (option == ATLASGroupBLK2OID)
		SetInfoText("Important buildings and structures within Blackreach - 10 markers.")
	elseif (option == ATLASGroupBLK3OID)
		SetInfoText("Points of Interest within Blackreach - 9 markers.")
	elseif (option == ATLASGroupDG1OID)
		SetInfoText("Additional locations related to the primary Dawnguard factions - 5 markers.")
	elseif (option == ATLASGroupDG2OID)
		SetInfoText("Ferrymen - 2 markers.")
;	elseif (option == ATLASGroupDG3OID)
;		SetInfoText("Dawnguard Supply Caches - 9 markers.")
;	elseif (option == ATLASGroupDGFV0OID)
;		SetInfoText("Enables Forgotten Vale/Skyrim map markers - 2 markers.")		
	elseif (option == ATLASGroupDGFV1OID)
		SetInfoText("Primary locations and Wayshrines in the Forgotten Vale - 7 markers.")
	elseif (option == ATLASGroupDGFV2OID)
		SetInfoText("Important portals, caves, passages and landmarks within the Forgotten Vale - 11 markers.")
	elseif (option == ATLASGroupDGFV3OID)
		SetInfoText("Animal dens, creatures, corpses, pathways, hidden chests and other points of interest encountered in the Forgotten Vale - 47 markers.")
	elseif (option == ATLASGroupDGSC1OID)
		SetInfoText("Boneyard, Keeper locations, and portal to Castle Volkihar - 5 markers.")
	elseif (option == ATLASGroupDGSC2OID)
		SetInfoText("Other significant locations in the Soul Cairn - Ideal Masters, Reaper's Lair, etc - 13 markers.")
	elseif (option == ATLASGroupDGSC3OID)
		SetInfoText("Skeletons, NPCs, smaller structures, pathways, and other points of interest in the Soul Cairn - 37 markers.")
	elseif (option == ATLASGroupDB1OID)
		SetInfoText("The Northern Maiden - Windhelm and Solstheim - 2 markers.")
	elseif (option == ATLASGroupDB2OID)
		SetInfoText("Creatures, corpses, hidden chests and other points of interest on Solstheim - 28 markers.")	
	elseif (option == ATLASGroupDB3OID)
		SetInfoText("Gem Geodes on Solstheim - 7 markers.")	
	elseif (option == ATLASGroupDB4OID)
		SetInfoText("Four mountain peaks on Solstheim - 4 markers.")		
	elseif (option == ATLASExtraBook1OID)
		SetInfoText("This will give you a copy of the original setup book and allow you to individually configure certain map markers.")
	elseif (option == ATLASExtraBook2OID)
		SetInfoText("This will give you a copy of the original setup book and allow you to individually configure certain map markers.")
	elseif (option == ATLASExtraBook3OID)
		SetInfoText("This will give you a copy of the original setup book and allow you to individually configure certain map markers.")
	elseif (option == ATLASExtraFlagonExitKeyOID)
		SetInfoText("This will give you a copy of the Abandoned Sewer Key and allow you to gain entrance to the Ragged Flagon shortcut prior to joining the Thieves Guild.")	
	elseif (option == ATLASExtraFlagonExitOID)
		SetInfoText("This will enable a newly added shortcut into the Ragged Flagon that bypasses one load screen.  When enabled, a key to open this new entrance can be found inside of the Ragged Flagon.")
	elseif (option == OIDCompassFadeStart)
		SetInfoText("The distance at which the solid markers begin to fade and become smaller.")	
	elseif (option == OIDCompassHUDMaxDist)
		SetInfoText("The distance at which the markers come into detection range and appear on your compass.  Setting this value to 0 will completely remove all map markers from the compass.  NOTE: You may need to fast travel after changing this setting in order to get the new value to take affect.")	
	elseif (option == OIDCompassMapMaxSize)
		SetInfoText("The maximum size that Map markers will appear on your compass.")	
	elseif (option == OIDCompassMapMinSize)
		SetInfoText("The minimum size that Map markers will appear on your compass.")	
	elseif (option == OIDCompassMapMinFade)
		SetInfoText("The minimum alpha fade that Map markers will appear on your compass.")	
	elseif (option == OIDCompassQuestMaxSize)
		SetInfoText("The maximum size that Quest markers will appear on your compass.")	
	elseif (option == OIDCompassQuestMinSize)
		SetInfoText("The minimum size that Quest markers will appear on your compass.")	
	elseif (option == OIDCompassQuestMinFade)	
		SetInfoText("The minimum alpha fade that Quest markers will appear on your compass.")
	endif
EndEvent


function SetOptionType(globalvariable MarkerOption, int MarkerOID)
	If MarkerOption.GetValue() == 3
		MarkerOption.SetValue(0)
	Elseif MarkerOption.GetValue() == 1 && ATLASMainVisibilityInt == 0
		MarkerOption.SetValue(0)
	Else
		MarkerOption.SetValue(MarkerOption.GetValue() + 1)
	EndIf
	RunConfigure = true
	SetTextOptionValue(MarkerOID, DisplayOption[MarkerOption.GetValue() as Int])	
	ForcePageReset()
endfunction


function SetSpecialOptionType(globalvariable MarkerOption, int MarkerOID)
	If MarkerOption.GetValue() == 2
		MarkerOption.SetValue(3)
	Else
		MarkerOption.SetValue(2)
	EndIf
	RunConfigure = true
	SetTextOptionValue(MarkerOID, DisplayOption[MarkerOption.GetValue() as Int])	
	ForcePageReset()
endfunction

;===============================================================
;Configure Map Markers
;===============================================================

function SetGroupMarkers(int ListNumber, globalvariable MarkerOption) 
	UseThisList = MasterList.GetAt(ListNumber) As FormList
	iIndex = UseThisList.GetSize()
	While iIndex > 0
	   	iIndex -= 1
		ObjectReference MapMarker = UseThisList.GetAt(iIndex) As ObjectReference
		If MarkerOption.GetValue() == 0					;no markers 
			MapMarker.Disable()
		ElseIf MarkerOption.GetValue() == 1				;add default
			MapMarker.Enable() 		
		ElseIf MarkerOption.GetValue() == 2				;add undiscovered
			MapMarker.Enable()
			MapMarker.AddToMap(False)						;false = no fast travel
		ElseIf MarkerOption.GetValue() == 3				;add discovered with fast travel enabled
			MapMarker.Enable()
			MapMarker.AddToMap(True) 						;with fast travel
		EndIf
	EndWhile
endfunction

function SetSpecialMarkers(int ListNumber, globalvariable MarkerOption) 
	UseThisList = MasterList.GetAt(ListNumber) As FormList
	iIndex = UseThisList.GetSize()
	While iIndex > 0
	   	iIndex -= 1
		ObjectReference MapMarker = UseThisList.GetAt(iIndex) As ObjectReference
		If MarkerOption.GetValue() == 2				;add undiscovered with no fast travel
			MapMarker.AddToMap(False)					
		ElseIf MarkerOption.GetValue() == 3			;add discovered with fast travel enabled
			MapMarker.AddToMap(True) 						
		EndIf
	EndWhile
endfunction


Function ConfigureMapMarkers()
If RunConfigure
	debug.notification("Configuring map markers.")
	debug.notification("Please be patient; this may take a moment.")
	If PlayerHome
		debug.notification("Configuring Player Home map markers.")
		SetGroupMarkers(0, ATLASGroupPlayerHomeGV)
		PlayerHome = false
	endif
	If Important == true
		debug.notification("Configuring Notable Places map markers.")
		SetGroupMarkers(1, ATLASGroupImportantGV)
		Important = false
	endif
	If bFaction == true
		debug.notification("Configuring Faction Related map markers.")
		SetGroupMarkers(2, ATLASGroupFactionGV)
		bFaction = false
	endif
	If CityInn == true
		debug.notification("Configuring City Inns map markers.")
		SetGroupMarkers(3, ATLASGroupCityInnGV)
		CityInn = false
	endif
	If CityShop == true
		debug.notification("Configuring City Shops map markers.")
		SetGroupMarkers(4, ATLASGroupCityShopGV)
		CityShop = false
	endif
	If City == true
		debug.notification("Configuring City Markets map markers.")
		SetGroupMarkers(5, ATLASGroupCityGV)
		City = false
	endif
	If Temple == true
		debug.notification("Configuring Temple map markers.")
		SetGroupMarkers(6, ATLASGroupTempleGV)
		Temple = false
	endif
	If HallDead == true
		debug.notification("Configuring Hall of the Dead map markers.")
		SetGroupMarkers(7, ATLASGroupHallDeadGV)
		HallDead = false
	endif 
	If CaravanCamp == true
		debug.notification("Configuring Khajiit Caravan Campsite map markers.")
		SetGroupMarkers(8, ATLASGroupCaravanCampGV)
		CaravanCamp = false
	endif
	If MoreCity == true
		debug.notification("Configuring Additional City Location map markers.")
		SetGroupMarkers(9, ATLASGroupMoreCityGV)
		MoreCity = false
	endif
	If ImportantTown == true
		debug.notification("Configuring Notable Places map markers.")
		SetGroupMarkers(10, ATLASGroupImportantTownGV)
		ImportantTown = false
	endif
	If Inn == true
		debug.notification("Configuring Rural Inn map markers.")
		SetGroupMarkers(11, ATLASGroupInnGV)
		Inn = false
	endif
	If Shop == true
		debug.notification("Configuring Rural Shop map markers.")
		SetGroupMarkers(12, ATLASGroupShopGV)
		Shop = false
	endif
	If Farm == true
		debug.notification("Configuring Farm map markers.")
		SetGroupMarkers(13, ATLASGroupFarmGV)
		Farm = false
	endif
	If LumberMill == true
		debug.notification("Configuring Lumber Mill map markers.")
		SetGroupMarkers(14, ATLASGroupLumberMillGV)
		LumberMill = false
	endif
	If Mine == true
		debug.notification("Configuring Ore Mine map markers.")
		SetGroupMarkers(15, ATLASGroupMineGV)
		Mine = false
	endif
	If MoreTown == true
		debug.notification("Configuring Additional Town Location map markers.")
		SetGroupMarkers(16, ATLASGroupMoreTownGV)
		MoreTown = false
	endif
	If CWCamp == true
		debug.notification("Configuring Civil War Camp map markers.")
		SetSpecialMarkers(17, ATLASGroupCWCampGV)
		CWCamp = false
	endif
	If Camp == true
		debug.notification("Configuring Wilderness Camp map markers.")
		SetGroupMarkers(18, ATLASGroupCampGV)
		Camp = false
	endif
	If Shrine == true
		debug.notification("Configuring Shrine map markers.")
		SetGroupMarkers(19, ATLASGroupShrineGV)		
		SetGroupMarkers(20, ATLASGroupShrineGV)
		Shrine = false	
	endif
	If ShrineSteps == true
		debug.notification("Configuring Wayshrine map markers.")
		SetGroupMarkers(21, ATLASGroupShrineStepsGV)
		ShrineSteps = false	
	endif
	If Altar == true
		debug.notification("Configuring Altar map markers.")
		SetGroupMarkers(22, ATLASGroupAltarGV)
		Altar = false
	endif
	If Dragon == true
		debug.notification("Configuring Dragon Mound map markers.")
		SetGroupMarkers(23, ATLASGroupDragonGV)
		Dragon = false
	endif
	If AnimalDen == true
		debug.notification("Configuring Animal Den map markers.")
		SetGroupMarkers(24, ATLASGroupAnimalDenGV)
		AnimalDen = false
	endif
	If Water == true
		debug.notification("Configuring Bodies of Water map markers.")
		SetGroupMarkers(25, ATLASGroupWaterGV)
		Water = false
	endif
	If DunExit == true
		debug.notification("Configuring Dungeon Exit map markers.")
		SetGroupMarkers(26, ATLASGroupDunExitGV)
		DunExit = false
	endif
	If SkillBook == true
		debug.notification("Configuring Lost Skill Book map markers.")
		SetGroupMarkers(27, ATLASGroupSkillBookGV)
		SkillBook = false
	endif
;	If Treasure == true
;		debug.notification("Configuring Treasure Map Loot map markers.")
;		SetGroupMarkers(28, ATLASGroupTreasureGV)
;		Treasure = false
;	endif
	If Shipwreck == true
		debug.notification("Configuring Shipwreck map markers.")
		SetGroupMarkers(29, ATLASGroupShipwreckGV)
		Shipwreck = false
	endif
	If Structures == true
		debug.notification("Configuring Structure map markers.")
		SetGroupMarkers(30, ATLASGroupStructuresGV)
		Structures = false
	endif
	If Ruin == true
		debug.notification("Configuring Ruins map markers.")
		SetGroupMarkers(31, ATLASGroupRuinGV)
		Ruin = false
	endif
	If Landmark == true
		debug.notification("Configuring Natural Landmarks map markers.")
		SetGroupMarkers(32, ATLASGroupLandmarkGV)
		Landmark = false
	endif
	If POI == true
		debug.notification("Configuring Points of Interest map markers.")
		SetGroupMarkers(33, ATLASGroupPOIGV)
		POI = false
	endif
	If BLK1
		debug.notification("Configuring Blackreach Primary Location map markers.")
		SetGroupMarkers(34, ATLASGroupBLK1GV)
		BLK1 = false
	endif
	If BLK2
		debug.notification("Configuring Blackreach Secondary Location map markers.")	
		SetGroupMarkers(35, ATLASGroupBLK2GV)
		BLK2 = false
	endif
	If BLK3
		debug.notification("Configuring Blackreach Point of Interest map markers.")	
		SetGroupMarkers(36, ATLASGroupBLK3GV)
		BLK3 = false
	endif
	If DG1
		debug.notification("Configuring Dawnguard Faction map markers.")		
		SetGroupMarkers(37, ATLASGroupDG1GV)
		DG1 = false
	endif
	If DG2
		debug.notification("Configuring Dawnguard Ferrymen map markers.")		
		SetGroupMarkers(38, ATLASGroupDG2GV)
		DG2 = false
	endif
;	If DG3
;		debug.notification("Configuring Dawnguard Cache map markers.")		
;		SetGroupMarkers(39, ATLASGroupDG3GV)
;		DG3 = false
;	endif	
;	If DGFV0
;		debug.notification("Configuring Forgotten Vale map markers.")
;		SetGroupMarkers(40, ATLASGroupDGFV0GV)
;		DGFV0 = false
;	endif
	If DGFV1
		debug.notification("Configuring Forgotten Vale Primary Location map markers.")
		SetGroupMarkers(41, ATLASGroupDGFV1GV)
		DGFV1 = false
	endif
	If DGFV2
		debug.notification("Configuring Forgotten Vale Secondary Location map markers.")	
		SetGroupMarkers(42, ATLASGroupDGFV2GV)
		DGFV2 = false
	endif
	If DGFV3
		debug.notification("Configuring Forgotten Vale Point of Interest map markers.")	
		SetGroupMarkers(43, ATLASGroupDGFV3GV)
		DGFV3 = false
	endif
	If DGSC1
		debug.notification("Configuring Soul Cairn Primary Location map markers.")
		SetGroupMarkers(44, ATLASGroupDGSC1GV)
		DGSC1 = false
	endif
	If DGSC2
		debug.notification("Configuring Soul Cairn Secondary Location map markers.")	
		SetGroupMarkers(45, ATLASGroupDGSC2GV)
		DGSC2 = false
	endif
	If DGSC3
		debug.notification("Configuring Soul Cairn Point of Interest map markers.")	
		SetGroupMarkers(46, ATLASGroupDGSC3GV)
		DGSC3 = false
	endif	
	If DB1
		debug.notification("Configuring Northern Maiden map markers.")	
		SetGroupMarkers(47, ATLASGroupDB1GV)
		DB1 = false
	endif
	If DB2
		debug.notification("Configuring Solstheim Point of Interest map markers.")	
		SetGroupMarkers(48, ATLASGroupDB2GV)
		DB2 = false
	endif
	If DB3
		debug.notification("Configuring Solstheim Gem Geode map markers.")	
		SetGroupMarkers(49, ATLASGroupDB3GV)
		DB3 = false
	endif
	If DB4
		debug.notification("Configuring Solstheim Mountain Peak map markers.")	
		SetGroupMarkers(50, ATLASGroupDB4GV)
		DB4 = false
	endif
	debug.notification("Map marker configuration finished.")
	debug.notification("Map has been updated.")
	RunConfigure = false
endif	
EndFunction


Function Maintenance()
	Game.SetGameSettingInt("iMapMarkerFadeStartDistance", (FadeStartVal as int))
	Game.SetGameSettingFloat("fHUDCompassLocationMaxDist", HUDMaxDistVal)
	Game.SetGameSettingFloat("fMapMarkerMaxPercentSize", MapMaxVal)
	Game.SetGameSettingFloat("fMapMarkerMinPercentSize", MapMinVal)
	Game.SetGameSettingFloat("fMapMarkerMinFadeAlpha", MapFadeVal)
	Game.SetGameSettingFloat("fMapQuestMarkerMaxPercentSize", QuestMaxVal)
	Game.SetGameSettingFloat("fMapQuestMarkerMinPercentSize", QuestMinVal)
	Game.SetGameSettingFloat("fMapQuestMarkerMinFadeAlpha", QuestFadeVal)
EndFunction

;===============================================================
;FISS Preset Functions
;===============================================================

Function BeginLoadMMPreset()
	if !ShowMessage("Are you sure? Loading this preset will overwrite the current settings.", true, "Load", "Cancel")
		return
	endif
	If !ShowMessage("Please do not leave the MCM menu until a new messagebox shows the load is complete.", true, "Begin Load", "Cancel")
		Return
	EndIf
	FISSInterface fiss = FISSFactory.getFISS()
	If (!fiss)
		Debug.MessageBox("FISS not installed. Loading disabled.")
		return
	EndIf
	fiss.beginLoad("AtlasMapMarkerPreset.xml")
	if ATLASGroupPlayerHomeGV.GetValue() != fiss.loadFloat("PlayerHome")
		ATLASGroupPlayerHomeGV.SetValue(fiss.loadFloat("PlayerHome"))
		PlayerHome = true
	endif
	if ATLASGroupImportantGV.GetValue() != fiss.loadFloat("Important")
		ATLASGroupImportantGV.SetValue(fiss.loadFloat("Important"))
		Important = true
	endif	
	if ATLASGroupFactionGV.GetValue() != fiss.loadFloat("Faction")
		ATLASGroupFactionGV.SetValue(fiss.loadFloat("Faction"))
		bFaction = true
	endif	
	if ATLASGroupCityInnGV.GetValue() != fiss.loadFloat("CityInn")
		ATLASGroupCityInnGV.SetValue(fiss.loadFloat("CityInn"))
		CityInn = true
	endif		
	if ATLASGroupCityShopGV.GetValue() != fiss.loadFloat("CityShop")
		ATLASGroupCityShopGV.SetValue(fiss.loadFloat("CityShop"))
		CityShop = true
	endif
	if ATLASGroupCityGV.GetValue() != fiss.loadFloat("City")
		ATLASGroupCityGV.SetValue(fiss.loadFloat("City"))
		City = true
	endif
	if ATLASGroupTempleGV.GetValue() != fiss.loadFloat("Temples")
		ATLASGroupTempleGV.SetValue(fiss.loadFloat("Temples"))
		Temple = true
	endif
	if ATLASGroupHallDeadGV.GetValue() != fiss.loadFloat("HallDead")
		ATLASGroupHallDeadGV.SetValue(fiss.loadFloat("HallDead"))
		HallDead = true
	endif	
	if ATLASGroupCaravanCampGV.GetValue() != fiss.loadFloat("CaravanCamp")
		ATLASGroupCaravanCampGV.SetValue(fiss.loadFloat("CaravanCamp"))
		CaravanCamp = true
	endif	
	if ATLASGroupMoreCityGV.GetValue() != fiss.loadFloat("MoreCity")
		ATLASGroupMoreCityGV.SetValue(fiss.loadFloat("MoreCity"))
		MoreCity = true
	endif	
	if ATLASGroupImportantTownGV.GetValue() != fiss.loadFloat("ImportantTown")
		ATLASGroupImportantTownGV.SetValue(fiss.loadFloat("ImportantTown"))
		ImportantTown = true
	endif	
	if ATLASGroupInnGV.GetValue() != fiss.loadFloat("Inn")
		ATLASGroupInnGV.SetValue(fiss.loadFloat("Inn"))
		Inn = true
	endif	
	if ATLASGroupShopGV.GetValue() != fiss.loadFloat("Shop")
		ATLASGroupShopGV.SetValue(fiss.loadFloat("Shop"))
		Shop = true
	endif		
	if ATLASGroupFarmGV.GetValue() != fiss.loadFloat("Farm")
		ATLASGroupFarmGV.SetValue(fiss.loadFloat("Farm"))
		Farm = true
	endif	
	if ATLASGroupLumberMillGV.GetValue() != fiss.loadFloat("LumberMill")
		ATLASGroupLumberMillGV.SetValue(fiss.loadFloat("LumberMill"))
		LumberMill = true
	endif
	if ATLASGroupMineGV.GetValue() != fiss.loadFloat("Mine")
		ATLASGroupMineGV.SetValue(fiss.loadFloat("Mine"))
		Mine = true
	endif
	if ATLASGroupMoreTownGV.GetValue() != fiss.loadFloat("MoreTown")
		ATLASGroupMoreTownGV.SetValue(fiss.loadFloat("MoreTown"))
		MoreTown = true
	endif	
	if ATLASGroupCWCampGV.GetValue() != fiss.loadFloat("CWCamp")
		ATLASGroupCWCampGV.SetValue(fiss.loadFloat("CWCamp"))
		CWCamp = true
	endif	
	if ATLASGroupCampGV.GetValue() != fiss.loadFloat("Camp")
		ATLASGroupCampGV.SetValue(fiss.loadFloat("Camp"))
		Camp = true
	endif	
	if ATLASGroupShrineGV.GetValue() != fiss.loadFloat("Shrine")
		ATLASGroupShrineGV.SetValue(fiss.loadFloat("Shrine"))
		Shrine = true
	endif	
	if ATLASGroupShrineStepsGV.GetValue() != fiss.loadFloat("ShrineSteps")
		ATLASGroupShrineStepsGV.SetValue(fiss.loadFloat("ShrineSteps"))
		ShrineSteps = true
	endif	
	if ATLASGroupAltarGV.GetValue() != fiss.loadFloat("Altar")
		ATLASGroupAltarGV.SetValue(fiss.loadFloat("Altar"))
		Altar = true
	endif	
	if ATLASGroupDragonGV.GetValue() != fiss.loadFloat("Dragon")
		ATLASGroupDragonGV.SetValue(fiss.loadFloat("Dragon"))
		Dragon = true
	endif		
	if ATLASGroupAnimalDenGV.GetValue() != fiss.loadFloat("AnimalDen")
		ATLASGroupAnimalDenGV.SetValue(fiss.loadFloat("AnimalDen"))
		AnimalDen = true
	endif	
	if ATLASGroupWaterGV.GetValue() != fiss.loadFloat("Water")
		ATLASGroupWaterGV.SetValue(fiss.loadFloat("Water"))
		Water = true
	endif	
	if ATLASGroupDunExitGV.GetValue() != fiss.loadFloat("DunExit")
		ATLASGroupDunExitGV.SetValue(fiss.loadFloat("DunExit"))
		DunExit = true
	endif	
	if ATLASGroupShipwreckGV.GetValue() != fiss.loadFloat("Shipwreck")
		ATLASGroupShipwreckGV.SetValue(fiss.loadFloat("Shipwreck"))
		Shipwreck = true
	endif	
	if ATLASGroupStructuresGV.GetValue() != fiss.loadFloat("Structures")
		ATLASGroupStructuresGV.SetValue(fiss.loadFloat("Structures"))
		Structures = true
	endif	
	if ATLASGroupRuinGV.GetValue() != fiss.loadFloat("Ruin")
		ATLASGroupRuinGV.SetValue(fiss.loadFloat("Ruin"))
		Ruin = true
	endif	
	if ATLASGroupLandmarkGV.GetValue() != fiss.loadFloat("Landmark")
		ATLASGroupLandmarkGV.SetValue(fiss.loadFloat("Landmark"))
		Landmark = true
	endif	
	if ATLASGroupPOIGV.GetValue() != fiss.loadFloat("POI")
		ATLASGroupPOIGV.SetValue(fiss.loadFloat("POI"))
		POI = true
	endif		
	if ATLASGroupBLK1GV.GetValue() != fiss.loadFloat("BLK1")
		ATLASGroupBLK1GV.SetValue(fiss.loadFloat("BLK1"))
		BLK1 = true
	endif	
	if ATLASGroupBLK2GV.GetValue() != fiss.loadFloat("BLK2")
		ATLASGroupBLK2GV.SetValue(fiss.loadFloat("BLK2"))
		BLK2 = true
	endif
	if ATLASGroupBLK3GV.GetValue() != fiss.loadFloat("BLK3")
		ATLASGroupBLK3GV.SetValue(fiss.loadFloat("BLK3"))
		BLK3 = true
	endif	
	if ATLASGroupDGFV1GV.GetValue() != fiss.loadFloat("DGFV1")
		ATLASGroupDGFV1GV.SetValue(fiss.loadFloat("DGFV1"))
		DGFV1 = true
	endif	
	if ATLASGroupDGFV2GV.GetValue() != fiss.loadFloat("DGFV2")
		ATLASGroupDGFV2GV.SetValue(fiss.loadFloat("DGFV2"))
		DGFV2 = true
	endif
	if ATLASGroupDGFV3GV.GetValue() != fiss.loadFloat("DGFV3")
		ATLASGroupDGFV3GV.SetValue(fiss.loadFloat("DGFV3"))
		DGFV3 = true
	endif	
	if ATLASGroupDGSC1GV.GetValue() != fiss.loadFloat("DGSC1")
		ATLASGroupDGSC1GV.SetValue(fiss.loadFloat("DGSC1"))
		DGSC1 = true
	endif	
	if ATLASGroupDGSC2GV.GetValue() != fiss.loadFloat("DGSC2")
		ATLASGroupDGSC2GV.SetValue(fiss.loadFloat("DGSC2"))
		DGSC2 = true
	endif
	if ATLASGroupDGSC3GV.GetValue() != fiss.loadFloat("DGSC3")
		ATLASGroupDGSC3GV.SetValue(fiss.loadFloat("DGSC3"))
		DGSC3 = true
	endif	
	if ATLASGroupDB1GV.GetValue() != fiss.loadFloat("DB1")
		ATLASGroupDB1GV.SetValue(fiss.loadFloat("DB1"))
		DB1 = true
	endif	
	if ATLASGroupDB2GV.GetValue() != fiss.loadFloat("DB2")
		ATLASGroupDB2GV.SetValue(fiss.loadFloat("DB2"))
		DB2 = true
	endif
	if ATLASGroupDB3GV.GetValue() != fiss.loadFloat("DB3")
		ATLASGroupDB3GV.SetValue(fiss.loadFloat("DB3"))
		DB3 = true
	endif	
	if ATLASGroupDB4GV.GetValue() != fiss.loadFloat("DB4")
		ATLASGroupDB4GV.SetValue(fiss.loadFloat("DB4"))
		DB4 = true
	endif
	if ATLASGroupDG1GV.GetValue() != fiss.loadFloat("DG1")
		ATLASGroupDG1GV.SetValue(fiss.loadFloat("DG1"))
		DG1 = true
	endif	
	if ATLASGroupDG2GV.GetValue() != fiss.loadFloat("DG2")
		ATLASGroupDG2GV.SetValue(fiss.loadFloat("DG2"))
		DG2 = true
	endif	
	FlagonExitVal = fiss.loadInt("FlagonExit")
	If FlagonExitVal == 0
		FlagonParentMarker.Disable()
	else
		FlagonParentMarker.Enable()
	endif
	RunConfigure = true	
	ForcePageReset()	
	string loadResult = fiss.endLoad()	; check the result
	If (loadResult != "")
		ShowMessage("Error reading preset file.")
	Else
		ShowMessage("Preset has been loaded successfully!", false, "Okay")
	EndIf
EndFunction

Function BeginSaveMMPreset()
	if !ShowMessage("Are you sure? This will overwrite the existing preset with your current settings.", true, "Save", "Cancel")
		return
	endif
	if !ShowMessage("Please do not leave the MCM menu until a new messagebox shows the save is complete.", true, "Begin Save", "Cancel")
		return
	endif
	FISSInterface fiss = FISSFactory.getFISS()
	If (!fiss)
		Debug.MessageBox("FISS not installed. Saving disabled.")
		return
	EndIf
	fiss.beginSave("AtlasMapMarkerPreset.xml", "Atlas Legendary")	
	fiss.saveFloat("PlayerHome", ATLASGroupPlayerHomeGV.GetValue())	
	fiss.saveFloat("Important", ATLASGroupImportantGV.GetValue())		
	fiss.saveFloat("Faction", ATLASGroupFactionGV.GetValue())	
	fiss.saveFloat("CityInn", ATLASGroupCityInnGV.GetValue())	
	fiss.saveFloat("CityShop", ATLASGroupCityShopGV.GetValue())		
	fiss.saveFloat("City", ATLASGroupCityGV.GetValue())		
	fiss.saveFloat("Temples", ATLASGroupTempleGV.GetValue())		
	fiss.saveFloat("HallDead", ATLASGroupHallDeadGV.GetValue())		
	fiss.saveFloat("CaravanCamp", ATLASGroupCaravanCampGV.GetValue())		
	fiss.saveFloat("MoreCity", ATLASGroupMoreCityGV.GetValue())		
	fiss.saveFloat("ImportantTown", ATLASGroupImportantTownGV.GetValue())		
	fiss.saveFloat("Inn", ATLASGroupInnGV.GetValue())		
	fiss.saveFloat("Shop", ATLASGroupShopGV.GetValue())		
	fiss.saveFloat("Farm", ATLASGroupFarmGV.GetValue())		
	fiss.saveFloat("LumberMill", ATLASGroupLumberMillGV.GetValue())		
	fiss.saveFloat("Mine", ATLASGroupMineGV.GetValue())			
	fiss.saveFloat("MoreTown", ATLASGroupMoreTownGV.GetValue())	
	fiss.saveFloat("CWCamp", ATLASGroupCWCampGV.GetValue())		
	fiss.saveFloat("Camp", ATLASGroupCampGV.GetValue())		
	fiss.saveFloat("Shrine", ATLASGroupShrineGV.GetValue())		
	fiss.saveFloat("ShrineSteps", ATLASGroupShrineStepsGV.GetValue())		
	fiss.saveFloat("Altar", ATLASGroupAltarGV.GetValue())		
	fiss.saveFloat("Dragon", ATLASGroupDragonGV.GetValue())		
	fiss.saveFloat("AnimalDen", ATLASGroupAnimalDenGV.GetValue())		
	fiss.saveFloat("Water", ATLASGroupWaterGV.GetValue())		
	fiss.saveFloat("DunExit", ATLASGroupDunExitGV.GetValue())		
	fiss.saveFloat("Shipwreck", ATLASGroupShipwreckGV.GetValue())		
	fiss.saveFloat("Structures", ATLASGroupStructuresGV.GetValue())			
	fiss.saveFloat("Ruin", ATLASGroupRuinGV.GetValue())	
	fiss.saveFloat("Landmark", ATLASGroupLandmarkGV.GetValue())
	fiss.saveFloat("POI", ATLASGroupPOIGV.GetValue())
	fiss.saveFloat("BLK1", ATLASGroupBLK1GV.GetValue())
	fiss.saveFloat("BLK2", ATLASGroupBLK2GV.GetValue())
	fiss.saveFloat("BLK3", ATLASGroupBLK3GV.GetValue())	
	fiss.saveFloat("DGFV1", ATLASGroupDGFV1GV.GetValue())
	fiss.saveFloat("DGFV2", ATLASGroupDGFV2GV.GetValue())
	fiss.saveFloat("DGFV3", ATLASGroupDGFV3GV.GetValue())	
	fiss.saveFloat("DGSC1", ATLASGroupDGSC1GV.GetValue())
	fiss.saveFloat("DGSC2", ATLASGroupDGSC2GV.GetValue())
	fiss.saveFloat("DGSC3", ATLASGroupDGSC3GV.GetValue())		
	fiss.saveFloat("DB1", ATLASGroupDB1GV.GetValue())
	fiss.saveFloat("DB2", ATLASGroupDB2GV.GetValue())
	fiss.saveFloat("DB3", ATLASGroupDB3GV.GetValue())	
	fiss.saveFloat("DB4", ATLASGroupDB4GV.GetValue())		
	fiss.saveFloat("DG1", ATLASGroupDG1GV.GetValue())
	fiss.saveFloat("DG2", ATLASGroupDG2GV.GetValue())	
	fiss.saveInt("FlagonExit", FlagonExitVal) 
	string saveResult = fiss.endSave()	
	If (saveResult != "")
		ShowMessage("Error saving preset file.")
	Else
		ShowMessage("Your settings has been successfully saved!", false, "Okay")
	EndIf
EndFunction	

Function BeginLoadCTPreset()
	if !ShowMessage("Are you sure? Loading this preset will overwrite the current compass settings.", true, "Load", "Cancel")
		return
	endif
	If !ShowMessage("Please do not leave the MCM menu until a new messagebox shows the load is complete.", true, "Begin Load", "Cancel")
		Return
	EndIf
	FISSInterface fiss = FISSFactory.getFISS()
	If (!fiss)
		Debug.MessageBox("FISS not installed. Loading disabled.")
		return
	EndIf
	fiss.beginLoad("AtlasMapMarkerCompassPreset.xml")
		OnOptionSliderAccept(OIDCompassFadeStart, fiss.loadFloat("FadeStart"))
		OnOptionSliderAccept(OIDCompassHUDMaxDist, fiss.loadFloat("HUDMaxDist"))
		OnOptionSliderAccept(OIDCompassMapMaxSize, fiss.loadFloat("MapMax"))
		OnOptionSliderAccept(OIDCompassMapMinSize, fiss.loadFloat("MapMin"))	
		OnOptionSliderAccept(OIDCompassMapMinFade, fiss.loadFloat("MapFade"))	
		OnOptionSliderAccept(OIDCompassQuestMaxSize, fiss.loadFloat("QuestMax"))
		OnOptionSliderAccept(OIDCompassQuestMinSize, fiss.loadFloat("QuestMin"))	
		OnOptionSliderAccept(OIDCompassQuestMinFade, fiss.loadFloat("QuestFade"))		
	string loadResult = fiss.endLoad()	; check the result
	If (loadResult != "")
		ShowMessage("Error reading preset file.")
	Else
		ShowMessage("Preset has been loaded successfully!", false, "Okay")
	EndIf
EndFunction

Function BeginSaveCTPreset()
	if !ShowMessage("Are you sure? This will overwrite the existing preset with your current settings.", true, "Save", "Cancel")
		return
	endif
	if !ShowMessage("Please do not leave the MCM menu until a new messagebox shows the save is complete.", true, "Begin Save", "Cancel")
		return
	endif
	FISSInterface fiss = FISSFactory.getFISS()
	If (!fiss)
		Debug.MessageBox("FISS not installed. Saving disabled.")
		return
	EndIf
	fiss.beginSave("AtlasMapMarkerCompassPreset.xml", "Atlas Legendary")
	fiss.saveFloat("FadeStart", FadeStartVal)
	fiss.saveFloat("HUDMaxDist", HUDMaxDistVal)
	fiss.saveFloat("MapMax", MapMaxVal)	
	fiss.saveFloat("MapMin", MapMinVal)	
	fiss.saveFloat("MapFade", MapFadeVal)	
	fiss.saveFloat("QuestMax", QuestMaxVal)	
	fiss.saveFloat("QuestMin", QuestMinVal)	
	fiss.saveFloat("QuestFade", QuestFadeVal)		
	string saveResult = fiss.endSave()	
	If (saveResult != "")
		ShowMessage("Error saving preset file.")
	Else
		ShowMessage("Your settings has been successfully saved!", false, "Okay")
	EndIf
EndFunction