#!/usr/bin/env python
#
# thg - front-end script for TortoiseHg dialogs
#
# Copyright (C) 2008-2011 Steve Borho <steve@borho.org>
# Copyright (C) 2008 TK Soh <teekaysoh@gmail.com>
#
# This software may be used and distributed according to the terms of the
# GNU General Public License version 2, incorporated herein by reference.

import os
import sys

argv = sys.argv[1:]
if 'THG_OSX_APP' in os.environ:
    # Remove the -psn argument supplied by launchd
    if argv[0].startswith('-psn'):
        argv = argv[1:]
    # sys.path as created by py2app doesn't work quite right with demandimport
    # Add the explicit path where PyQt4 and other libs are
    bundlepath = os.path.dirname(os.path.realpath(__file__))
    sys.path.insert(0, os.path.join(bundlepath, 'lib/python2.6/lib-dynload'))

if hasattr(sys, "frozen"):
    if sys.frozen == 'windows_exe':
        # sys.stdin is invalid, should be None.  Fixes svn, git subrepos
        sys.stdin = None
        if 'THGDEBUG' in os.environ:
            import win32traceutil
            print 'starting'
    # os.Popen() needs this, and Mercurial still uses os.Popen
    if 'COMSPEC' not in os.environ:
        comspec = os.path.join(os.environ.get('SystemRoot', r'C:\Windows'),
                               'system32', 'cmd.exe')
        os.environ['COMSPEC'] = comspec
else:
    thgpath = os.path.dirname(os.path.realpath(__file__))
    testpath = os.path.join(thgpath, 'tortoisehg')
    if os.path.isdir(testpath) and thgpath not in sys.path:
        sys.path.insert(0, thgpath)

    # compile .ui and .qrc for in-place use
    fpath = os.path.realpath(__file__)
    if os.path.exists(os.path.join(os.path.dirname(fpath), 'setup.py')):
        from distutils.dist import Distribution
        from setup import build_qt
        build_qt(Distribution()).run()

    if 'HGPATH' in os.environ:
        hgpath = os.environ['HGPATH']
        testpath = os.path.join(hgpath, 'mercurial')
        if os.path.isdir(testpath) and hgpath not in sys.path:
            sys.path.insert(0, hgpath)

# Make sure to load threading by main thread; otherwise, _MainThread instance
# may have wrong thread id and results KeyError at exit.
import threading

from mercurial import demandimport
demandimport.ignore.append('win32com.shell')
demandimport.ignore.append('tortoisehg.util.config')
demandimport.ignore.append('icons_rc')
demandimport.ignore.append('translations_rc')
demandimport.enable()

# Verify we can reach TortoiseHg sources first
try:
    import tortoisehg.hgqt.run
except ImportError, e:
    sys.stderr.write(str(e)+'\n')
    sys.stderr.write("abort: couldn't find tortoisehg libraries in [%s]\n" %
                     os.pathsep.join(sys.path))
    sys.stderr.write("(check your install and PYTHONPATH)\n")
    sys.exit(-1)

# Verify we have an acceptable version of Mercurial
from tortoisehg.util.hgversion import hgversion, checkhgversion
errmsg = checkhgversion(hgversion)
if errmsg:
    from mercurial import ui
    from tortoisehg.hgqt.bugreport import run
    from tortoisehg.hgqt.run import qtrun
    opts = {}
    opts['cmd'] = ' '.join(argv)
    opts['error'] = '\n' + errmsg + '\n'
    opts['nofork'] = True
    qtrun(run, ui.ui(), **opts)
    sys.exit(1)

if 'THGDEBUG' in os.environ or '--profile' in sys.argv:
    sys.exit(tortoisehg.hgqt.run.dispatch(argv))
else:
    import cStringIO
    mystderr = cStringIO.StringIO()
    origstderr = sys.stderr
    sys.stderr = mystderr
    sys.__stdout__ = sys.stdout
    sys.__stderr__ = sys.stderr
    ret = 0
    try:
        ret = tortoisehg.hgqt.run.dispatch(argv)
        sys.stderr = origstderr
        stderrout = mystderr.getvalue()
        errors = ('Traceback', 'TypeError', 'NameError', 'AttributeError',
                  'NotImplementedError')
        for l in stderrout.splitlines():
            if l.startswith(errors):
                from mercurial import ui
                from tortoisehg.hgqt.bugreport import run
                from tortoisehg.hgqt.run import qtrun
                opts = {}
                opts['cmd'] = ' '.join(argv)
                opts['error'] = 'Recoverable error (stderr):\n' + stderrout
                opts['nofork'] = True
                qtrun(run, ui.ui(), **opts)
                break
        sys.exit(ret)
    except KeyboardInterrupt:
        sys.exit(-1)
    except SystemExit:
        raise
    except:
        sys.__stderr__ = sys.stderr = origstderr
        raise
