# qdelete.py - QDelete dialog for TortoiseHg
#
# Copyright 2010 Steve Borho <steve@borho.org>
#
# This software may be used and distributed according to the terms of the
# GNU General Public License version 2, incorporated herein by reference.

from PyQt4.QtCore import *
from PyQt4.QtGui import *

from tortoisehg.util import hglib
from tortoisehg.hgqt import qtlib
from tortoisehg.hgqt.i18n import _

class QDeleteDialog(QDialog):
    makeLogVisible = pyqtSignal(bool)

    def __init__(self, repoagent, patches, parent):
        super(QDeleteDialog, self).__init__(parent)
        repo = repoagent.rawRepo()
        self.setWindowTitle(_('Patch remove - %s') % repo.displayname)
        self.setWindowIcon(qtlib.geticon('hg-qdelete'))
        f = self.windowFlags()
        self.setWindowFlags(f & ~Qt.WindowContextHelpButtonHint)
        self._repoagent = repoagent
        self.patches = patches

        self.setLayout(QVBoxLayout())

        msg = _('Remove patches from queue?')
        patchesu = u'<li>'.join(self.patches)
        lbl = QLabel(u'<b>%s<ul><li>%s</ul></b>' % (msg, patchesu))
        self.layout().addWidget(lbl)

        self.keepchk = QCheckBox(_('Keep patch files'))
        self.keepchk.setChecked(True)
        self.layout().addWidget(self.keepchk)

        BB = QDialogButtonBox
        bbox = QDialogButtonBox(BB.Ok|BB.Cancel)
        bbox.accepted.connect(self.accept)
        bbox.rejected.connect(self.reject)
        self.layout().addWidget(bbox)
        self.bbox = bbox

    def accept(self):
        cmdline = hglib.buildcmdargs('qdelete', *self.patches,
                                     keep=self.keepchk.isChecked())
        sess = self._repoagent.runCommand(cmdline, self)
        sess.commandFinished.connect(self._finishOff)

    @pyqtSlot(int)
    def _finishOff(self, ret):
        if ret != 0:
            self.makeLogVisible.emit(True)
        self.done(int(ret == 0))
