# Copyright (C) 2011 Fog Creek Software
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os

location = '/usr/local/bin'
hgname = location + '/hg'
thgname = location + '/thg'
certname = '/etc/hg-dummy-cert.pem'

def check_and_create_symlink(real, fake):
    if not os.path.exists(fake):
        if os.path.lexists(fake):
            # Symlink exists, but is broken. Remove it.
            os.unlink(fake)
        os.symlink(real, fake)

if not os.path.exists(location):
    os.makedirs(location)

thgdir = os.path.dirname(os.path.realpath(__file__))
check_and_create_symlink(os.path.join(thgdir, 'hg'), hgname)
check_and_create_symlink(os.path.join(thgdir, 'thg'), thgname)
check_and_create_symlink(os.path.join(thgdir, 'hg-dummy-cert.pem'), certname)
