/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.ide;

import com.google.common.io.Files;
import com.kms.katalon.selenium.ide.model.TestCase;
import com.kms.katalon.selenium.ide.model.TestSuite;
import com.kms.katalon.selenium.ide.util.FileUtils;
import com.kms.katalon.selenium.ide.util.HtmlParser;
import com.kms.katalon.selenium.ide.util.TestObjectParser;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public final class SeleniumIdeParser {
    private static final SeleniumIdeParser INSTANCE = new SeleniumIdeParser();

    public static SeleniumIdeParser getInstance() {
        return INSTANCE;
    }

    public boolean isTestSuiteFile(File file) {
        String extension = Files.getFileExtension((String)file.getName());
        return StringUtils.isBlank((CharSequence)extension) || HtmlParser.hasSuiteTable(file) || !HtmlParser.hasBaseUrl(file);
    }

    public boolean isTestCaseFile(File file) {
        String extension = Files.getFileExtension((String)file.getName());
        return "html".equalsIgnoreCase(extension) && HtmlParser.hasBaseUrl(file);
    }

    public TestSuite parseTestSuite(File file) {
        if (!this.isTestSuiteFile(file)) {
            return null;
        }
        return HtmlParser.parseTestSuite(file);
    }

    public TestCase parseTestCase(File file) {
        if (!this.isTestCaseFile(file)) {
            return null;
        }
        return HtmlParser.parseTestCaseFromFile(file.getAbsolutePath());
    }

    public String parseTestObjectName(String target) {
        return FileUtils.encode(target);
    }

    public String parseLocator(String target) {
        return TestObjectParser.parse(target);
    }
}

