/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.ide;

import com.kms.katalon.selenium.ide.format.DefaultFormatter;
import com.kms.katalon.selenium.ide.format.EchoFormatter;
import com.kms.katalon.selenium.ide.format.Formatter;
import com.kms.katalon.selenium.ide.format.PauseFormatter;
import com.kms.katalon.selenium.ide.format.StoreFormatter;
import com.kms.katalon.selenium.ide.format.VerifyAndAssertFormatter;
import com.kms.katalon.selenium.ide.format.WaitForFormatter;
import com.kms.katalon.selenium.ide.model.Command;
import com.kms.katalon.selenium.ide.model.TestCase;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public final class SeleniumIdeFormatter {
    private static final String DATE_FORMAT = "dd-MMM-yyyy hh:mm:ss a";
    private String email;
    private static final SeleniumIdeFormatter INSTANCE = new SeleniumIdeFormatter();
    private final Map<String, Formatter> formatters = new LinkedHashMap<String, Formatter>();

    public SeleniumIdeFormatter() {
        this.formatters.put("assert", new VerifyAndAssertFormatter("assert"));
        this.formatters.put("verify", new VerifyAndAssertFormatter("verify"));
        this.formatters.put("store", new StoreFormatter());
        this.formatters.put("sendKeys", new DefaultFormatter());
        this.formatters.put("chooseCancelOnNextPrompt", new DefaultFormatter());
        this.formatters.put("waitForPageToLoad", new DefaultFormatter());
        this.formatters.put("waitForCondition", new DefaultFormatter());
        this.formatters.put("waitForFrameToLoad", new DefaultFormatter());
        this.formatters.put("waitForPopUp", new DefaultFormatter());
        this.formatters.put("waitFor", new WaitForFormatter());
        this.formatters.put("echo", new EchoFormatter());
        this.formatters.put("pause", new PauseFormatter());
        this.formatters.put("default", new DefaultFormatter());
    }

    public static SeleniumIdeFormatter getInstance() {
        return INSTANCE;
    }

    public String format(TestCase testCase) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getHeader(testCase));
        List<String> commands = this.formatCommands(testCase.getCommands());
        commands.forEach(c -> {
            StringBuilder stringBuilder2 = builder.append((String)c);
        });
        builder.append(this.getFooter(testCase));
        return builder.toString();
    }

    public List<String> formatCommands(List<Command> commands) {
        ArrayList<String> formattedCommands = new ArrayList<String>();
        commands.forEach(command -> {
            String formatted = this.formatCommand((Command)command);
            formattedCommands.add(formatted);
        });
        return formattedCommands;
    }

    public String formatCommand(Command command) {
        Formatter formatter = this.getFormatter(command.getCommand());
        if (formatter == null) {
            return String.format("Method %s is not found", command.getCommand());
        }
        String comment = String.format("\n\"%s | %s | %s\"\n", this.encodeString(command.getCommand()), this.encodeString(this.replaceBraces(command.getTarget())), this.encodeString(this.replaceBraces(command.getValue())));
        String formatted = formatter.format(command);
        if (StringUtils.isBlank((CharSequence)formatted)) {
            return String.format("Method %s is not found\n", command.getCommand());
        }
        return String.valueOf(comment) + formatted;
    }

    public String getHeader(TestCase testCase) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("import static com.kms.katalon.core.checkpoint.CheckpointFactory.findCheckpoint\nimport static com.kms.katalon.core.testcase.TestCaseFactory.findTestCase\nimport static com.kms.katalon.core.testdata.TestDataFactory.findTestData\nimport static com.kms.katalon.core.testobject.ObjectRepository.findTestObject\nimport com.kms.katalon.core.checkpoint.Checkpoint as Checkpoint\nimport com.kms.katalon.core.checkpoint.CheckpointFactory as CheckpointFactory\nimport com.kms.katalon.core.mobile.keyword.MobileBuiltInKeywords as MobileBuiltInKeywords\nimport com.kms.katalon.core.mobile.keyword.MobileBuiltInKeywords as Mobile\nimport com.kms.katalon.core.model.FailureHandling as FailureHandling\nimport com.kms.katalon.core.testcase.TestCase as TestCase\nimport com.kms.katalon.core.testcase.TestCaseFactory as TestCaseFactory\nimport com.kms.katalon.core.testdata.TestData as TestData\nimport com.kms.katalon.core.testdata.TestDataFactory as TestDataFactory\nimport com.kms.katalon.core.testobject.ObjectRepository as ObjectRepository\nimport com.kms.katalon.core.testobject.TestObject as TestObject\nimport com.kms.katalon.core.webservice.keyword.WSBuiltInKeywords as WSBuiltInKeywords\nimport com.kms.katalon.core.webservice.keyword.WSBuiltInKeywords as WS\nimport com.kms.katalon.core.webui.keyword.WebUiBuiltInKeywords as WebUiBuiltInKeywords\nimport com.kms.katalon.core.webui.keyword.WebUiBuiltInKeywords as WebUI\nimport internal.GlobalVariable as GlobalVariable\n");
        buffer.append("import com.kms.katalon.core.webui.driver.DriverFactory as DriverFactory\nimport com.kms.katalon.core.webui.driver.KatalonWebDriverBackedSelenium\nimport static com.kms.katalon.core.webui.driver.KatalonWebDriverBackedSelenium.*\n\nimport com.thoughtworks.selenium.Selenium\nimport org.openqa.selenium.Keys\nimport org.openqa.selenium.firefox.FirefoxDriver\nimport org.openqa.selenium.WebDriver\nimport static org.junit.Assert.*\nimport java.util.concurrent.Callable\nimport java.util.regex.Pattern\nimport static org.apache.commons.lang3.StringUtils.join\n\n");
        buffer.append("'----------------------------------------------------'\n");
        buffer.append("'This test case script is generated by Katalon Studio'\n");
        buffer.append(String.format("'Generated date: %s'\n", this.getCurrentDateTime()));
        buffer.append(String.format("'File path: %s'\n", this.encodeString(testCase.getFilePath())));
        buffer.append(String.format("'Generated by: %s'\n", this.email));
        buffer.append("'----------------------------------------------------'\n\n");
        buffer.append("String baseUrl = \"" + testCase.getBaseUrl() + "\"\n\n");
        buffer.append("WebUI.openBrowser(baseUrl)\n\n");
        buffer.append("selenium = new KatalonWebDriverBackedSelenium(baseUrl)\n");
        return buffer.toString();
    }

    public String getFooter(TestCase testCase) {
        return "\nWebUI.closeBrowser()";
    }

    private String encodeString(String filePath) {
        return filePath.replace("\\", Matcher.quoteReplacement(File.separator));
    }

    private String getCurrentDateTime() {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        return formatter.format(Calendar.getInstance().getTime());
    }

    private Formatter getFormatter(String command) {
        if (StringUtils.isBlank((CharSequence)command)) {
            return null;
        }
        for (Map.Entry<String, Formatter> entry : this.formatters.entrySet()) {
            String key = entry.getKey();
            Formatter formatter = entry.getValue();
            if (!command.contains(key)) continue;
            return formatter;
        }
        return this.formatters.get("default");
    }

    private String replaceBraces(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        if (value.contains("${")) {
            value = value.replace("${", "");
            value = value.replace("}", "");
        }
        value = value.replace("\"", "");
        return value;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }
}

