/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.part.provider;

import com.kms.katalon.composer.components.impl.control.HotkeyActiveListener;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.collection.collector.TestExecutionGroupCollector;
import com.kms.katalon.composer.explorer.providers.EntityLabelProvider;
import com.kms.katalon.composer.explorer.providers.EntityProvider;
import com.kms.katalon.composer.testsuite.collection.constant.StringConstants;
import com.kms.katalon.composer.testsuite.collection.dialog.TestSuiteSelectionDialog;
import com.kms.katalon.composer.testsuite.collection.part.provider.TableViewerProvider;
import com.kms.katalon.composer.testsuite.collection.part.provider.TestSuiteViewerFilter;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolItem;

public class ToolbarItemListener
extends SelectionAdapter
implements HotkeyActiveListener {
    private TableViewerProvider provider;

    public ToolbarItemListener(TableViewerProvider provider) {
        this.provider = provider;
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (!(source instanceof ToolItem)) {
            return;
        }
        String actionId = StringUtils.defaultString((String)((ToolItem)source).getText());
        this.executeAction(actionId);
    }

    public void executeAction(String actionId) {
        switch (ActionId.parse(actionId)) {
            case ADD: {
                this.addTestSuiteRunConfigs();
                return;
            }
            case REMOVE: {
                this.deleteSelectedTestSuiteRunConfigs();
                return;
            }
            case UP: {
                this.moveUpSelectedTestSuiteRunConfigs();
                return;
            }
            case DOWN: {
                this.moveDownSelectedTestSuiteRunConfigs();
                return;
            }
            case EXECUTE: {
                this.executeTestRun();
                return;
            }
        }
    }

    private TableViewer getTableViewer() {
        return this.provider.getTableViewer();
    }

    private List<TestSuiteRunConfiguration> getTableItems() {
        return this.provider.getTableItems();
    }

    private void executeTestRun() {
        this.provider.executeTestRun();
    }

    private void addTestSuiteRunConfigs() {
        try {
            List<TestSuiteEntity> chosenTestSuites = this.getSelectedTestSuitesOnDialog();
            if (chosenTestSuites.isEmpty()) {
                return;
            }
            ArrayList<TestSuiteRunConfiguration> newItems = new ArrayList<TestSuiteRunConfiguration>();
            for (TestSuiteEntity selectedTestSuite : chosenTestSuites) {
                if (this.provider.containsTestSuite(selectedTestSuite)) continue;
                TestSuiteRunConfiguration newTestSuiteRunConfig = TestSuiteRunConfiguration.newInstance((TestSuiteEntity)selectedTestSuite, (RunConfigurationDescription)TestExecutionGroupCollector.getInstance().getDefaultConfiguration(ProjectController.getInstance().getCurrentProject()));
                this.getTableItems().add(newTestSuiteRunConfig);
                newItems.add(newTestSuiteRunConfig);
            }
            if (newItems.isEmpty()) {
                return;
            }
            this.getTableViewer().refresh();
            this.getTableViewer().getTable().setFocus();
            this.getTableViewer().setSelection((ISelection)new StructuredSelection(newItems));
            this.updateRunColumnAndMarkDirty();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.LS_MSG_UNABLE_TO_ADD_TEST_SUITE, (String)e.getMessage());
        }
    }

    private List<TestSuiteEntity> getSelectedTestSuitesOnDialog() throws Exception {
        EntityProvider entityProvider = new EntityProvider();
        TestSuiteSelectionDialog dialog = new TestSuiteSelectionDialog(Display.getCurrent().getActiveShell(), (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new TestSuiteViewerFilter(entityProvider));
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        dialog.setInput(TreeEntityUtil.getChildren(null, (FolderEntity)FolderController.getInstance().getTestSuiteRoot(currentProject)));
        if (dialog.open() != 0) {
            return Collections.emptyList();
        }
        return this.flattenDialogResult(dialog.getResult());
    }

    private List<TestSuiteEntity> flattenDialogResult(Object[] dialogResult) throws Exception {
        if (dialogResult == null) {
            return Collections.emptyList();
        }
        ArrayList<TestSuiteEntity> selectedTestSuites = new ArrayList<TestSuiteEntity>();
        Object[] objectArray = dialogResult;
        int n = dialogResult.length;
        int n2 = 0;
        while (n2 < n) {
            Object eachResult = objectArray[n2];
            if (eachResult instanceof TestSuiteTreeEntity) {
                selectedTestSuites.add(((TestSuiteTreeEntity)eachResult).getObject());
            }
            if (eachResult instanceof FolderTreeEntity) {
                selectedTestSuites.addAll(this.flattenDialogResult(((FolderTreeEntity)eachResult).getChildren()));
            }
            ++n2;
        }
        return selectedTestSuites;
    }

    private void deleteSelectedTestSuiteRunConfigs() {
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        if (selection.isEmpty()) {
            return;
        }
        this.getTableItems().removeAll(selection.toList());
        this.getTableViewer().refresh();
        this.updateRunColumnAndMarkDirty();
    }

    private void updateRunColumnAndMarkDirty() {
        this.provider.updateRunColumn();
        this.provider.markDirty();
    }

    private void moveDownSelectedTestSuiteRunConfigs() {
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        if (selection.isEmpty()) {
            return;
        }
        new ItemSwapper(this, this.getTableItems(), selection.toList()){

            @Override
            protected boolean isIndexNotValid(int selectedIndex) {
                return selectedIndex == this.tableItems.size() - 1;
            }

            @Override
            protected int order(int firstIndex, int secondIndex) {
                return secondIndex - firstIndex;
            }

            @Override
            protected int indexToSwap(int selectedIndex) {
                return selectedIndex + 1;
            }
        }.swap();
    }

    private void moveUpSelectedTestSuiteRunConfigs() {
        IStructuredSelection selection = (IStructuredSelection)this.getTableViewer().getSelection();
        if (selection.isEmpty()) {
            return;
        }
        new ItemSwapper(this, this.getTableItems(), selection.toList()){

            @Override
            protected boolean isIndexNotValid(int selectedIndex) {
                return selectedIndex == 0;
            }

            @Override
            protected int order(int firstIndex, int secondIndex) {
                return firstIndex - secondIndex;
            }

            @Override
            protected int indexToSwap(int selectedIndex) {
                return selectedIndex - 1;
            }
        }.swap();
    }

    public static enum ActionId {
        ADD(StringConstants.ADD),
        REMOVE(StringConstants.REMOVE),
        UP(StringConstants.UP),
        DOWN(StringConstants.DOWN),
        EXECUTE(StringConstants.PA_ACTION_EXECUTE_TEST_SUITE_COLLECTION);

        private final String id;

        private ActionId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static ActionId parse(String id) {
            if (id == null) {
                return null;
            }
            ActionId[] actionIdArray = ActionId.values();
            int n = actionIdArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionId actionId = actionIdArray[n2];
                if (actionId.getId().equals(id)) {
                    return actionId;
                }
                ++n2;
            }
            return null;
        }
    }

    private abstract class ItemSwapper {
        protected final List<TestSuiteRunConfiguration> tableItems;
        private final List<?> selectedObjects;

        public ItemSwapper(List<TestSuiteRunConfiguration> tableItems, List<?> selectedObjects) {
            this.tableItems = tableItems;
            this.selectedObjects = selectedObjects;
        }

        protected abstract boolean isIndexNotValid(int var1);

        protected abstract int order(int var1, int var2);

        protected abstract int indexToSwap(int var1);

        public final void swap() {
            Collections.sort(this.selectedObjects, new Comparator<Object>(){

                @Override
                public int compare(Object first, Object second) {
                    return ItemSwapper.this.order(ItemSwapper.this.tableItems.indexOf(first), ItemSwapper.this.tableItems.indexOf(second));
                }
            });
            boolean reallySwap = false;
            for (Object selectedObject : this.selectedObjects) {
                int indexToSwap;
                int selectedIndex = this.tableItems.indexOf(selectedObject);
                if (this.isIndexNotValid(selectedIndex) || this.selectedObjects.contains(this.tableItems.get(indexToSwap = this.indexToSwap(selectedIndex)))) continue;
                Collections.swap(this.tableItems, selectedIndex, indexToSwap);
                reallySwap = true;
            }
            if (reallySwap) {
                ToolbarItemListener.this.getTableViewer().refresh();
                ToolbarItemListener.this.provider.markDirty();
            }
        }
    }
}

