/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.part.provider;

import com.kms.katalon.composer.components.impl.providers.TypeCheckStyleCellTableLabelProvider;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ImageUtil;
import com.kms.katalon.composer.execution.collection.collector.TestExecutionGroupCollector;
import com.kms.katalon.composer.execution.collection.provider.TestExecutionConfigurationProvider;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testsuite.collection.constant.ComposerTestsuiteCollectionMessageConstants;
import com.kms.katalon.composer.testsuite.collection.constant.ImageConstants;
import com.kms.katalon.composer.testsuite.collection.part.provider.TableViewerProvider;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Image;

public class TestSuiteRunConfigLabelProvider
extends TypeCheckStyleCellTableLabelProvider<TestSuiteRunConfiguration> {
    public static final int NO_COLUMN_IDX = 0;
    public static final int ID_COLUMN_IDX = 1;
    public static final int RUN_WITH_COLUMN_IDX = 2;
    public static final int RUN_WITH_DATA_COLUMN_IDX = 3;
    public static final int PROFILE_COLUMN_IDX = 4;
    public static final int RUN_COLUMN_IDX = 5;
    private static final Image IMG_16_WARN_TABLE_ITEM = ImageManager.getImage((String)"warning_16.png");
    private TableViewerProvider provider;

    public TestSuiteRunConfigLabelProvider(TableViewerProvider provider, int columnIndex) {
        super(columnIndex);
        this.provider = provider;
    }

    protected Class<TestSuiteRunConfiguration> getElementType() {
        return TestSuiteRunConfiguration.class;
    }

    protected Image getImage(TestSuiteRunConfiguration element) {
        switch (this.columnIndex) {
            case 5: {
                return element.isRunEnabled() ? ImageConstants.IMG_16_CHECKED : ImageConstants.IMG_16_UNCHECKED;
            }
            case 2: {
                return this.getImageForRunConfigurationColumn(element);
            }
            case 4: {
                return ImageConstants.IMG_16_PROFILE;
            }
        }
        return null;
    }

    private TestExecutionConfigurationProvider getOriginalConfigProvider(TestSuiteRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            return null;
        }
        return TestExecutionGroupCollector.getInstance().getExecutionProvider(runConfiguration.getConfiguration());
    }

    private Image getImageForRunConfigurationColumn(TestSuiteRunConfiguration element) {
        TestExecutionConfigurationProvider executionProvider = this.getOriginalConfigProvider(element);
        try {
            String imageUrlAsString = executionProvider.getImageUrlAsString();
            if (StringUtils.isNotEmpty((CharSequence)imageUrlAsString)) {
                return executionProvider != null ? ImageUtil.loadImage((String)imageUrlAsString) : IMG_16_WARN_TABLE_ITEM;
            }
        }
        catch (MalformedURLException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return null;
    }

    protected String getText(TestSuiteRunConfiguration element) {
        RunConfigurationDescription runConfiguration = element.getConfiguration();
        if (runConfiguration == null) {
            return "";
        }
        switch (this.columnIndex) {
            case 0: {
                return Integer.toString(this.provider.getTableItems().indexOf(element) + 1);
            }
            case 1: {
                return element.getTestSuiteEntity() != null ? element.getTestSuiteEntity().getIdForDisplay() : "";
            }
            case 3: {
                Map configurationData = runConfiguration.getRunConfigurationData();
                return configurationData != null ? this.getOriginalConfigProvider(element).displayRunConfigurationData(configurationData) : "";
            }
            case 2: {
                RunConfigurationDescription configuration = runConfiguration;
                return configuration != null ? configuration.getRunConfigurationId() : "";
            }
            case 4: {
                return runConfiguration.getProfileName();
            }
        }
        return "";
    }

    protected String getElementToolTipText(TestSuiteRunConfiguration element) {
        TestExecutionConfigurationProvider executionProvider = this.getOriginalConfigProvider(element);
        return executionProvider != null ? (String)StringUtils.defaultIfEmpty((CharSequence)this.getText(element), null) : ComposerTestsuiteCollectionMessageConstants.ERR_TOOLTIP_UNABLE_TO_LOCATE_RUN_CONFIG;
    }
}

