/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.part.job;

import com.kms.katalon.composer.components.impl.dialogs.MissingMobileDriverWarningDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.execution.util.WebDriverInstallationUtil;
import com.kms.katalon.composer.testsuite.collection.constant.StringConstants;
import com.kms.katalon.composer.testsuite.collection.part.launcher.IDETestSuiteCollectionLauncher;
import com.kms.katalon.composer.testsuite.collection.part.launcher.SubIDELauncher;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportItemDescription;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteCollectionExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.mobile.exception.MobileSetupException;
import com.kms.katalon.tracking.service.Trackings;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TestSuiteCollectionBuilderJob
extends Job {
    private TestSuiteCollectionEntity testSuiteCollectionEntity;

    public TestSuiteCollectionBuilderJob(TestSuiteCollectionEntity testSuiteCollectionEntity) {
        super(StringConstants.JOB_TITLE_TEST_SUITE_COLLECTION_BUILDER);
        this.testSuiteCollectionEntity = testSuiteCollectionEntity;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            int totalSize = this.testSuiteCollectionEntity.getTestSuiteRunConfigurations().size() + 1;
            monitor.beginTask(StringConstants.JOB_TASK_BUILDING_TEST_SUITE_COLLECTION, totalSize);
            TestSuiteCollectionExecutedEntity executedEntity = new TestSuiteCollectionExecutedEntity(this.testSuiteCollectionEntity);
            ProjectEntity project = this.testSuiteCollectionEntity.getProject();
            ReportController reportController = ReportController.getInstance();
            ReportCollectionEntity reportCollection = reportController.newReportCollection(project, this.testSuiteCollectionEntity, executedEntity.getId());
            ArrayList<ReportableLauncher> tsLaunchers = new ArrayList<ReportableLauncher>();
            boolean cancelInstallWebDriver = false;
            for (TestSuiteRunConfiguration tsRunConfig : this.testSuiteCollectionEntity.getTestSuiteRunConfigurations()) {
                if (!cancelInstallWebDriver) {
                    cancelInstallWebDriver = !this.checkInstallWebDriver(tsRunConfig);
                }
                monitor.subTask(MessageFormat.format(StringConstants.JOB_TASK_BUILDING_LAUNCHER, tsRunConfig.getTestSuiteEntity().getIdForDisplay()));
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (!tsRunConfig.isRunEnabled()) continue;
                SubIDELauncher subLauncher = this.buildLauncher(tsRunConfig, reportCollection);
                if (subLauncher == null) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                TestSuiteExecutedEntity tsExecutedEntity = (TestSuiteExecutedEntity)subLauncher.getRunConfig().getExecutionSetting().getExecutedEntity();
                if (tsExecutedEntity.getTotalTestCases() == 0) {
                    this.openWarningDialogForEmptyTestSuite(tsExecutedEntity);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                executedEntity.addTestSuiteExecutedEntity(tsExecutedEntity);
                tsLaunchers.add((ReportableLauncher)subLauncher);
            }
            LauncherManager launcherManager = LauncherManager.getInstance();
            IDETestSuiteCollectionLauncher launcher = new IDETestSuiteCollectionLauncher(executedEntity, launcherManager, tsLaunchers, this.testSuiteCollectionEntity.getExecutionMode(), reportCollection);
            launcherManager.addLauncher((ILauncher)launcher);
            this.trackTestSuiteColletionExecution();
            reportController.updateReportCollection(reportCollection);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (DALException e) {
            LoggerSingleton.logError((Throwable)e);
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private void trackTestSuiteColletionExecution() {
        Trackings.trackExecuteTestSuiteCollectionInGuiMode();
    }

    private boolean checkInstallWebDriver(TestSuiteRunConfiguration tsRunConfig) {
        String runConfigId = tsRunConfig.getConfiguration().getRunConfigurationId();
        if (WebUIDriverType.SAFARI_DRIVER.toString().equals(runConfigId)) {
            final boolean[] result = new boolean[]{true};
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = WebDriverInstallationUtil.installSafariWebDriverAsNeed();
                }
            });
            return result[0];
        }
        return true;
    }

    private void openWarningDialogForEmptyTestSuite(final TestSuiteExecutedEntity tsExecutedEntity) {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning(null, (String)StringConstants.WARN, (String)MessageFormat.format(StringConstants.JOB_MSG_EMPTY_TEST_SUITE, tsExecutedEntity.getSourceId()));
            }
        });
    }

    private SubIDELauncher buildLauncher(final TestSuiteRunConfiguration tsRunConfig, ReportCollectionEntity reportCollection) {
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        try {
            RunConfigurationDescription configuration = tsRunConfig.getConfiguration();
            IRunConfiguration runConfig = RunConfigurationCollector.getInstance().getRunConfiguration(configuration.getRunConfigurationId(), projectDir, configuration);
            TestSuiteEntity testSuiteEntity = tsRunConfig.getTestSuiteEntity();
            TestSuiteExecutedEntity executedEntity = new TestSuiteExecutedEntity(testSuiteEntity);
            executedEntity.prepareTestCases();
            runConfig.build((FileEntity)testSuiteEntity, (IExecutedEntity)executedEntity);
            SubIDELauncher launcher = new SubIDELauncher(runConfig, LaunchMode.RUN, configuration);
            reportCollection.getReportItemDescriptions().add(ReportItemDescription.from((String)launcher.getReportEntity().getIdForDisplay(), (RunConfigurationDescription)configuration));
            return launcher;
        }
        catch (MobileSetupException e) {
            UISynchronizeService.syncExec(() -> MissingMobileDriverWarningDialog.showWarning((Shell)Display.getCurrent().getActiveShell(), (String)e.getMessage()));
            return null;
        }
        catch (Exception e) {
            UISynchronizeService.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)MessageFormat.format(StringConstants.JOB_MSG_UNABLE_TO_EXECUTE_TEST_SUITE, tsRunConfig.getTestSuiteEntity().getIdForDisplay()), (String)e.getMessage());
                }
            });
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }
}

