/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.collection.listeners;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.execution.collection.collector.TestExecutionGroupCollector;
import com.kms.katalon.composer.testsuite.collection.part.provider.TableViewerProvider;
import com.kms.katalon.composer.testsuite.collection.transfer.TestSuiteRunConfigurationTransferData;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;

public class TestSuiteTableDropListener
extends TableDropTargetEffect {
    private TableViewerProvider tableViewerProvider;

    public TestSuiteTableDropListener(TableViewerProvider testSuiteCollectionPart) {
        super(testSuiteCollectionPart.getTableViewer().getTable());
        this.tableViewerProvider = testSuiteCollectionPart;
    }

    public void drop(DropTargetEvent event) {
        TestSuiteRunConfiguration selectedItem = this.getSelectedItem(event);
        Object data = event.data;
        if (data instanceof ITreeEntity[]) {
            event.detail = 1;
            this.dropFromTreeToTable((ITreeEntity[])data, selectedItem);
            return;
        }
        if (data instanceof TestSuiteRunConfigurationTransferData[]) {
            TestSuiteRunConfigurationTransferData[] configurationTransferDatas = (TestSuiteRunConfigurationTransferData[])data;
            if (!configurationTransferDatas[0].getTestSuiteCollectionID().equals(this.tableViewerProvider.getTestSuiteCollection().getId())) {
                event.detail = 1;
                this.dropFromTableToTable(configurationTransferDatas, selectedItem);
            } else {
                event.detail = 2;
                this.dropInsideTable(configurationTransferDatas, selectedItem);
            }
        }
    }

    private TestSuiteRunConfiguration getSelectedItem(DropTargetEvent event) {
        TableViewer testSuiteCollectionTable = this.tableViewerProvider.getTableViewer();
        Point pt = Display.getCurrent().map(null, (Control)testSuiteCollectionTable.getTable(), event.x, event.y);
        TableItem tableItem = testSuiteCollectionTable.getTable().getItem(pt);
        TestSuiteRunConfiguration selectedItem = tableItem != null && tableItem.getData() instanceof TestSuiteRunConfiguration ? (TestSuiteRunConfiguration)tableItem.getData() : null;
        return selectedItem;
    }

    private void dropFromTableToTable(TestSuiteRunConfigurationTransferData[] configurationTransferDatas, TestSuiteRunConfiguration selectedItem) {
        ArrayList<TestSuiteRunConfiguration> addedTestSuiteRunConfiguration = new ArrayList<TestSuiteRunConfiguration>();
        TestSuiteController testSuiteController = TestSuiteController.getInstance();
        int i = 0;
        while (i < configurationTransferDatas.length) {
            TestSuiteRunConfiguration testSuiteRunConfiguration = configurationTransferDatas[i].getTestSuiteRunConfiguration();
            try {
                testSuiteRunConfiguration.setTestSuiteEntity(testSuiteController.getTestSuite(testSuiteRunConfiguration.getTestSuiteEntity().getId()));
                this.tableViewerProvider.getTableItems().add(testSuiteRunConfiguration);
                addedTestSuiteRunConfiguration.add(testSuiteRunConfiguration);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
            ++i;
        }
        this.refreshTestSuiteTable(addedTestSuiteRunConfiguration);
    }

    private void refreshTestSuiteTable(List<TestSuiteRunConfiguration> addedTestSuiteRunConfiguration) {
        this.tableViewerProvider.getTableViewer().refresh();
        this.tableViewerProvider.getTableViewer().setSelection((ISelection)new StructuredSelection(addedTestSuiteRunConfiguration));
        this.tableViewerProvider.getTableViewer().getTable().setFocus();
        this.tableViewerProvider.markDirty();
    }

    private void dropInsideTable(TestSuiteRunConfigurationTransferData[] testSuiteRunConfigurationTransferDatas, TestSuiteRunConfiguration selectedItem) {
        int selectedIndex;
        int cloneSelectedIndex = selectedIndex = this.getSelectedItemIndex(selectedItem);
        ArrayList<TestSuiteRunConfiguration> addedTestSuiteRunConfiguration = new ArrayList<TestSuiteRunConfiguration>();
        TestSuiteController controller = TestSuiteController.getInstance();
        int i = 0;
        while (i < testSuiteRunConfigurationTransferDatas.length) {
            TestSuiteRunConfiguration data = testSuiteRunConfigurationTransferDatas[i].getTestSuiteRunConfiguration();
            try {
                data.setTestSuiteEntity(controller.getTestSuite(data.getTestSuiteEntity().getId()));
                this.insertTestSuiteRunConfiguration(data, cloneSelectedIndex);
                addedTestSuiteRunConfiguration.add(data);
                ++cloneSelectedIndex;
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
            ++i;
        }
        this.refreshTestSuiteTable(addedTestSuiteRunConfiguration);
    }

    private int getSelectedItemIndex(TestSuiteRunConfiguration selectedItem) {
        List<TestSuiteRunConfiguration> testSuiteRunConfigurations = this.tableViewerProvider.getTableItems();
        int selectedIndex = selectedItem != null ? testSuiteRunConfigurations.indexOf(selectedItem) + 1 : testSuiteRunConfigurations.size();
        return selectedIndex;
    }

    private void dropFromTreeToTable(ITreeEntity[] treeEntities, TestSuiteRunConfiguration selectedItem) {
        int selectedIndex = this.getSelectedItemIndex(selectedItem);
        try {
            ArrayList<TestSuiteRunConfiguration> addedTestSuiteRunConfiguration = new ArrayList<TestSuiteRunConfiguration>();
            int i = treeEntities.length - 1;
            while (i >= 0) {
                if (treeEntities[i] instanceof TestSuiteTreeEntity) {
                    this.insertTestSuite(addedTestSuiteRunConfiguration, ((TestSuiteTreeEntity)treeEntities[i]).getObject(), selectedIndex);
                } else if (treeEntities[i] instanceof FolderTreeEntity) {
                    for (TestSuiteEntity testSuite : this.getTestSuiteFromFolderTree((FolderTreeEntity)treeEntities[i])) {
                        this.insertTestSuite(addedTestSuiteRunConfiguration, testSuite, selectedIndex);
                    }
                }
                --i;
            }
            this.refreshTestSuiteTable(addedTestSuiteRunConfiguration);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void insertTestSuite(List<TestSuiteRunConfiguration> addedTestSuiteRunConfiguration, TestSuiteEntity testSuite, int index) {
        if (this.isAlreadyAddedToTestSuiteCollection(addedTestSuiteRunConfiguration, testSuite)) {
            return;
        }
        try {
            TestSuiteEntity testSuiteEntity = TestSuiteController.getInstance().getTestSuite(testSuite.getId());
            TestSuiteRunConfiguration newTestSuiteRunConfig = TestSuiteRunConfiguration.newInstance((TestSuiteEntity)testSuiteEntity, (RunConfigurationDescription)TestExecutionGroupCollector.getInstance().getDefaultConfiguration(ProjectController.getInstance().getCurrentProject()));
            this.insertTestSuiteRunConfiguration(newTestSuiteRunConfig, index);
            addedTestSuiteRunConfiguration.add(newTestSuiteRunConfig);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void insertTestSuiteRunConfiguration(TestSuiteRunConfiguration configuration, int index) {
        if (index < 0 || index >= this.tableViewerProvider.getTableItems().size()) {
            this.tableViewerProvider.getTableItems().add(configuration);
            return;
        }
        this.tableViewerProvider.getTableItems().add(index, configuration);
    }

    private List<TestSuiteEntity> getTestSuiteFromFolderTree(FolderTreeEntity folderTree) {
        ArrayList<TestSuiteEntity> testSuitesList = new ArrayList<TestSuiteEntity>();
        try {
            Object[] objectArray = folderTree.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof TestSuiteTreeEntity) {
                    testSuitesList.add(((TestSuiteTreeEntity)child).getObject());
                } else if (child instanceof FolderTreeEntity) {
                    testSuitesList.addAll(this.getTestSuiteFromFolderTree((FolderTreeEntity)child));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return testSuitesList;
    }

    private boolean isAlreadyAddedToTestSuiteCollection(List<TestSuiteRunConfiguration> addedTestSuiteRunConfiguration, TestSuiteEntity testSuiteEntity) {
        for (TestSuiteRunConfiguration configuration : addedTestSuiteRunConfiguration) {
            if (!configuration.getTestSuiteEntity().equals((Object)testSuiteEntity)) continue;
            return true;
        }
        return false;
    }
}

